<?php

/**
 * Order tracking form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/form-tracking.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined('ABSPATH') || exit;

global $post;
?>

<div class="">
	<style>
		.woocommerce-error {
			display: none;
		}

		.info-notice {
			background: #e9f4ff;
			color: #004a75;
			border: 1px solid #b5dcff;
			padding: 12px 15px;
			border-radius: 8px;
			font-family: peydaBold;
			font-size: 14px;
			margin: 15px auto;
		}

		.woocommerce-form-track-order {
			display: flex;
			flex-direction: column;
			width: 100%;
			justify-content: center;
			align-items: center;
			margin: 30px 0px;
		}

		.form-control {
			padding: 12px;
			width: 400px;
			border: 0px solid;
			background-color: #fff;
			color: var(--main-color);
			font-family: peydaBold;
			margin: 10px 0px;
			outline: none;
			border-radius: 12px;
		}

		.btn-primary {
			cursor: pointer;
			border-radius: 100px;
			padding: 8px 12px;
			border: 1px solid var(--main-color);
			background-color: transparent;
			color: var(--main-color);
		}

		.description-form-tacking-order {
			margin-bottom: 30px;
		}

		@media (max-width: 768px) {
			.description-form-tacking-order {
				padding-left: 15px;
				padding-right: 15px;
				text-align: center;
			}
		}

		.woocommerce form .form-row {
			flex-direction: column;
			flex-wrap: wrap;
		}
	</style>
	<?php
	if (isset($_GET['orderid']) && !empty($_GET['orderid'])) {
		$order_number = wc_clean($_GET['orderid']);

		$order = wc_get_order($order_number);

		if ($order) {
			include(locate_template('woocommerce/order/tracking.php'));
		} else {
			echo '<div class="info-notice container">سفارشی با این اطلاعات یافت نشد . لطفا اطلاعات را بررسی و مجدد امتحان کنید</div>';
		}
	}
	?>

	<div class="container">
		<?php breadcrumb() ?>
	</div>

	<form action="" method="get" class="woocommerce-form woocommerce-form-track-order track_order">

		<?php
		/**
		 * Action hook fired at the beginning of the form-tracking form.
		 *
		 * @since 6.5.0
		 */
		do_action('woocommerce_order_tracking_form_start');
		?>

		<p class="description-form-tacking-order"><?php esc_html_e('برای پیگیری سفارش خود شماره سفارش خود را وارد کرده و اطلاعات سفارش خود را مشاهده کنید.', 'lamkadeh'); ?></p>

		<div>
			<p class="form-row">
				<label style="margin: 0px 8px;" for="orderid"><?php esc_html_e('Order ID', 'woocommerce'); ?></label> <input class="form-control" type="text" name="orderid" id="orderid" value="<?php echo isset($_REQUEST['orderid']) ? esc_attr(wp_unslash($_REQUEST['orderid'])) : ''; ?>" placeholder="<?php esc_attr_e('Found in your order confirmation email.', 'woocommerce'); ?>" />
			</p>
			<?php // @codingStandardsIgnoreLine 
			?>
		</div>
		<div class="clear"></div>

		<?php
		/**
		 * Action hook fired in the middle of the form-tracking form (before the submit button).
		 *
		 * @since 6.5.0
		 */
		do_action('woocommerce_order_tracking_form');
		?>

		<p class="form-row"><button type="submit" class="btn btn-primary" name="track" value="<?php esc_attr_e('Track', 'woocommerce'); ?>"><?php esc_html_e('Track', 'woocommerce'); ?></button></p>
		<?php wp_nonce_field('woocommerce-order_tracking', 'woocommerce-order-tracking-nonce'); ?>

		<?php
		/**
		 * Action hook fired at the end of the form-tracking form (after the submit button).
		 *
		 * @since 6.5.0
		 */
		do_action('woocommerce_order_tracking_form_end');
		?>

	</form>
</div>