<?php

/**
 * Edit address form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-edit-address.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */

defined('ABSPATH') || exit;

$page_title = ('billing' === $load_address) ? esc_html__('Billing address', 'woocommerce') : esc_html__('Shipping address', 'woocommerce');

do_action('woocommerce_before_edit_account_address_form'); ?>

<section class="header-categories-main">
	<div class="title-header-categories-main">
		<span>ADDRESS</span>
		<div class="text-header-categories-main">
			<span><?php echo __("<strong>آدرس هــــــــــا</strong>", "lamkadeh") ?></span>
			<svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
				<g clip-path="url(#clip0_26_3865)">
					<circle cx="32" cy="32" r="32" transform="matrix(-1 0 0 1 64 0)" fill="#FFD701" />
					<path fill-rule="evenodd" clip-rule="evenodd" d="M42 10.2917C40.9644 10.2917 40.125 11.1311 40.125 12.1667V12.3787C40.4729 12.375 40.8485 12.375 41.2543 12.375H42.7456C43.1515 12.375 43.5271 12.375 43.875 12.3787V12.1667C43.875 11.1311 43.0355 10.2917 42 10.2917ZM45.125 12.4224V12.1667C45.125 10.4408 43.7259 9.04166 42 9.04166C40.2741 9.04166 38.875 10.4408 38.875 12.1667V12.4224C38.7625 12.4306 38.6539 12.4403 38.5491 12.4516C37.8172 12.5305 37.205 12.6957 36.6615 13.0683C36.4745 13.1964 36.2989 13.3404 36.1366 13.4986C35.6646 13.9586 35.3825 14.5264 35.1616 15.2286C34.9471 15.9105 34.7738 16.7772 34.556 17.8663L34.5401 17.9458C34.2262 19.5151 33.9789 20.7517 33.9079 21.7366C33.8353 22.743 33.9367 23.5896 34.4134 24.3233C34.5725 24.5681 34.7581 24.7945 34.9669 24.9985C35.5929 25.6098 36.4032 25.8753 37.4042 26.0015C38.384 26.125 39.6451 26.125 41.2454 26.125H42.7545C44.3549 26.125 45.616 26.125 46.5957 26.0015C47.5968 25.8753 48.4071 25.6098 49.033 24.9985C49.2418 24.7945 49.4275 24.5681 49.5865 24.3233C50.0632 23.5896 50.1647 22.743 50.0921 21.7366C50.021 20.7517 49.7737 19.5151 49.4599 17.9459L49.444 17.8663C49.2261 16.7772 49.0528 15.9105 48.8383 15.2286C48.6174 14.5264 48.3353 13.9586 47.8634 13.4986C47.701 13.3404 47.5254 13.1964 47.3385 13.0683C46.7949 12.6957 46.1828 12.5305 45.4508 12.4516C45.346 12.4403 45.2375 12.4306 45.125 12.4224ZM38.6831 13.6944C38.0608 13.7614 37.6764 13.8881 37.3682 14.0994C37.2402 14.187 37.1201 14.2855 37.009 14.3938C36.7414 14.6546 36.5418 15.0067 36.354 15.6037C36.1621 16.2138 36.0011 17.0144 35.7746 18.1468C35.45 19.7699 35.2193 20.9294 35.1546 21.8265C35.0908 22.7115 35.1986 23.2374 35.4616 23.6422C35.5704 23.8097 35.6974 23.9647 35.8403 24.1042C36.1857 24.4415 36.6803 24.6504 37.5606 24.7613C38.453 24.8738 39.6352 24.875 41.2904 24.875H42.7095C44.3648 24.875 45.547 24.8738 46.4394 24.7613C47.3196 24.6504 47.8142 24.4415 48.1596 24.1042C48.3025 23.9647 48.4295 23.8097 48.5384 23.6422C48.8014 23.2374 48.9091 22.7115 48.8453 21.8265C48.7806 20.9294 48.5499 19.7699 48.2253 18.1468C47.9988 17.0144 47.8378 16.2138 47.6459 15.6037C47.4581 15.0067 47.2585 14.6546 46.9909 14.3938C46.8799 14.2855 46.7597 14.187 46.6318 14.0994C46.3236 13.8881 45.9391 13.7614 45.3169 13.6944C44.681 13.6258 43.8644 13.625 42.7095 13.625L41.2904 13.625C40.1355 13.625 39.319 13.6258 38.6831 13.6944ZM39.4341 19.9107C39.7596 19.7957 40.1166 19.9663 40.2317 20.2917C40.4894 21.0208 41.1847 21.5417 42.0001 21.5417C42.8155 21.5417 43.5109 21.0208 43.7686 20.2917C43.8836 19.9663 44.2407 19.7957 44.5662 19.9107C44.8916 20.0257 45.0622 20.3828 44.9472 20.7083C44.5185 21.9212 43.3618 22.7917 42.0001 22.7917C40.6385 22.7917 39.4818 21.9212 39.0531 20.7083C38.9381 20.3828 39.1087 20.0257 39.4341 19.9107Z" fill="#1D2977" />
					<circle cx="22" cy="60" r="17" fill="#F7F8FD" fill-opacity="0.64" />
				</g>
				<defs>
					<clipPath id="clip0_26_3865">
						<rect width="64" height="64" rx="32" fill="white" />
					</clipPath>
				</defs>
			</svg>
		</div>
		<div class="shape-header-categories-main"></div>
	</div>
</section>

<?php if (! $load_address) : ?>
	<?php wc_get_template('myaccount/my-address.php'); ?>
<?php else : ?>

	<form method="post" novalidate>

		<h2><?php echo apply_filters('woocommerce_my_account_edit_address_title', $page_title, $load_address); ?></h2><?php // @codingStandardsIgnoreLine 
																														?>

		<div class="woocommerce-address-fields">
			<?php do_action("woocommerce_before_edit_address_form_{$load_address}"); ?>

			<div class="woocommerce-address-fields__field-wrapper">
				<?php
				foreach ($address as $key => $field) {
					woocommerce_form_field($key, $field, wc_get_post_data_by_key($key, $field['value']));
				}
				?>
			</div>

			<?php do_action("woocommerce_after_edit_address_form_{$load_address}"); ?>

			<p>
				<button type="submit" class="button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="save_address" value="<?php esc_attr_e('Save address', 'woocommerce'); ?>"><?php esc_html_e('Save address', 'woocommerce'); ?></button>
				<?php wp_nonce_field('woocommerce-edit_address', 'woocommerce-edit-address-nonce'); ?>
				<input type="hidden" name="action" value="edit_address" />
			</p>
		</div>

	</form>

<?php endif; ?>

<?php do_action('woocommerce_after_edit_account_address_form'); ?>