<?php

/**
 * Cart totals
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-totals.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 2.3.6
 */

defined('ABSPATH') || exit;
if (WC()->cart->is_empty()) {
	include get_template_directory() . '/woocommerce/cart/cart-empty.php';
	return;
}
?>
<div class="cart_totals <?php echo (WC()->customer->has_calculated_shipping()) ? 'calculated_shipping' : ''; ?>">

	<?php do_action('woocommerce_before_cart_totals'); ?>

	<div class="title-header-categories-main">
		<span>BILL</span>
		<div class="text-header-categories-main">
			<span><?php echo __("<strong>صورتحســاب</strong>", "lamkadeh") ?></span>
			<svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
				<g clip-path="url(#clip0_32_2555)">
					<circle cx="32" cy="32" r="32" transform="matrix(-1 0 0 1 64 0)" fill="#FFD701" />
					<path fill-rule="evenodd" clip-rule="evenodd" d="M37.9157 9.04163C37.9557 9.04165 37.9963 9.04166 38.0376 9.04166H45.9625C46.0038 9.04166 46.0444 9.04165 46.0845 9.04163C46.9318 9.04126 47.5149 9.041 48.006 9.21188C48.9334 9.5346 49.6535 10.281 49.9622 11.2213L49.3684 11.4162L49.9622 11.2213C50.1256 11.7189 50.1254 12.3104 50.1251 13.1887C50.1251 13.228 50.1251 13.2679 50.1251 13.3084V24.9785C50.1251 26.1995 48.6859 26.9265 47.738 26.0591C47.6718 25.9985 47.5783 25.9985 47.5121 26.0591L47.1095 26.4275C46.336 27.1353 45.1641 27.1353 44.3906 26.4275C44.0948 26.1568 43.6553 26.1568 43.3595 26.4275C42.586 27.1353 41.4141 27.1353 40.6406 26.4275C40.3448 26.1568 39.9053 26.1568 39.6095 26.4275C38.836 27.1353 37.6641 27.1353 36.8906 26.4275L36.488 26.0591C36.4218 25.9985 36.3283 25.9985 36.2621 26.0591C35.3142 26.9265 33.8751 26.1995 33.8751 24.9785V13.3084C33.8751 13.2679 33.875 13.228 33.875 13.1887C33.8747 12.3104 33.8745 11.7189 34.0379 11.2213C34.3466 10.281 35.0667 9.5346 35.9942 9.21188C36.4853 9.041 37.0684 9.04126 37.9157 9.04163ZM38.0376 10.2917C37.02 10.2917 36.6695 10.3004 36.4049 10.3925C35.8555 10.5837 35.416 11.031 35.2255 11.6112C35.1329 11.8931 35.1251 12.2649 35.1251 13.3084V24.9785C35.1251 25.0777 35.175 25.1384 35.2376 25.1673C35.2703 25.1824 35.3022 25.1863 35.3288 25.1828C35.3522 25.1796 35.3826 25.1695 35.4182 25.1369C35.9621 24.6392 36.788 24.6392 37.3319 25.1369L37.7345 25.5053C38.0303 25.776 38.4698 25.776 38.7656 25.5053C39.5391 24.7975 40.711 24.7975 41.4845 25.5053C41.7803 25.776 42.2198 25.776 42.5156 25.5053C43.2891 24.7975 44.461 24.7975 45.2345 25.5053C45.5303 25.776 45.9698 25.776 46.2656 25.5053L46.6682 25.1369C47.2121 24.6392 48.038 24.6392 48.5819 25.1369C48.6175 25.1695 48.6479 25.1796 48.6713 25.1828C48.6979 25.1863 48.7298 25.1824 48.7625 25.1673C48.8251 25.1384 48.8751 25.0777 48.8751 24.9785V13.3084C48.8751 12.2649 48.8672 11.8931 48.7746 11.6112C48.5841 11.031 48.1447 10.5837 47.5952 10.3925C47.3306 10.3004 46.9801 10.2917 45.9625 10.2917H38.0376ZM37.2084 14.25C37.2084 13.9048 37.4882 13.625 37.8334 13.625H38.2501C38.5952 13.625 38.8751 13.9048 38.8751 14.25C38.8751 14.5952 38.5952 14.875 38.2501 14.875H37.8334C37.4882 14.875 37.2084 14.5952 37.2084 14.25ZM40.1251 14.25C40.1251 13.9048 40.4049 13.625 40.7501 13.625H46.1667C46.5119 13.625 46.7917 13.9048 46.7917 14.25C46.7917 14.5952 46.5119 14.875 46.1667 14.875H40.7501C40.4049 14.875 40.1251 14.5952 40.1251 14.25ZM37.2084 17.1667C37.2084 16.8215 37.4882 16.5417 37.8334 16.5417H38.2501C38.5952 16.5417 38.8751 16.8215 38.8751 17.1667C38.8751 17.5118 38.5952 17.7917 38.2501 17.7917H37.8334C37.4882 17.7917 37.2084 17.5118 37.2084 17.1667ZM40.1251 17.1667C40.1251 16.8215 40.4049 16.5417 40.7501 16.5417H46.1667C46.5119 16.5417 46.7917 16.8215 46.7917 17.1667C46.7917 17.5118 46.5119 17.7917 46.1667 17.7917H40.7501C40.4049 17.7917 40.1251 17.5118 40.1251 17.1667ZM37.2084 20.0833C37.2084 19.7382 37.4882 19.4583 37.8334 19.4583H38.2501C38.5952 19.4583 38.8751 19.7382 38.8751 20.0833C38.8751 20.4285 38.5952 20.7083 38.2501 20.7083H37.8334C37.4882 20.7083 37.2084 20.4285 37.2084 20.0833ZM40.1251 20.0833C40.1251 19.7382 40.4049 19.4583 40.7501 19.4583H46.1667C46.5119 19.4583 46.7917 19.7382 46.7917 20.0833C46.7917 20.4285 46.5119 20.7083 46.1667 20.7083H40.7501C40.4049 20.7083 40.1251 20.4285 40.1251 20.0833Z" fill="#1D2977" />
					<circle cx="22" cy="60" r="17" fill="#F7F8FD" fill-opacity="0.64" />
				</g>
				<defs>
					<clipPath id="clip0_32_2555">
						<rect width="64" height="64" rx="32" fill="white" />
					</clipPath>
				</defs>
			</svg>
		</div>
		<div class="shape-header-categories-main"></div>
	</div>

	<table cellspacing="0" class="shop_table shop_table_responsive">

		<tr class="cart-subtotal">
			<th><?php esc_html_e('مبلغ سفارش', 'lamkadeh'); ?></th>
			<td data-title="<?php esc_attr_e('مبلغ سفارش', 'lamkadeh'); ?>"><?php wc_cart_totals_subtotal_html(); ?></td>
		</tr>

		<?php foreach (WC()->cart->get_coupons() as $code => $coupon) : ?>
			<tr class="cart-discount coupon-<?php echo esc_attr(sanitize_title($code)); ?>">
				<th><?php wc_cart_totals_coupon_label($coupon); ?></th>
				<td data-title="<?php echo esc_attr(wc_cart_totals_coupon_label($coupon, false)); ?>"><?php wc_cart_totals_coupon_html($coupon); ?></td>
			</tr>
		<?php endforeach; ?>

		<?php if (WC()->cart->needs_shipping() && WC()->cart->show_shipping()) : ?>

			<?php do_action('woocommerce_cart_totals_before_shipping'); ?>

			<?php wc_cart_totals_shipping_html(); ?>

			<?php do_action('woocommerce_cart_totals_after_shipping'); ?>

		<?php elseif (WC()->cart->needs_shipping() && 'yes' === get_option('woocommerce_enable_shipping_calc')) : ?>

			<tr class="shipping">
				<th><?php esc_html_e('Shipping', 'woocommerce'); ?></th>
				<td data-title="<?php esc_attr_e('Shipping', 'woocommerce'); ?>"><?php woocommerce_shipping_calculator(); ?></td>
			</tr>

		<?php endif; ?>

		<?php foreach (WC()->cart->get_fees() as $fee) : ?>
			<tr class="fee">
				<th><?php echo esc_html($fee->name); ?></th>
				<td data-title="<?php echo esc_attr($fee->name); ?>"><?php wc_cart_totals_fee_html($fee); ?></td>
			</tr>
		<?php endforeach; ?>

		<?php
		if (wc_tax_enabled() && ! WC()->cart->display_prices_including_tax()) {
			$taxable_address = WC()->customer->get_taxable_address();
			$estimated_text  = '';

			if (WC()->customer->is_customer_outside_base() && ! WC()->customer->has_calculated_shipping()) {
				/* translators: %s location. */
				$estimated_text = sprintf(' <small>' . esc_html__('(estimated for %s)', 'woocommerce') . '</small>', WC()->countries->estimated_for_prefix($taxable_address[0]) . WC()->countries->countries[$taxable_address[0]]);
			}

			if ('itemized' === get_option('woocommerce_tax_total_display')) {
				foreach (WC()->cart->get_tax_totals() as $code => $tax) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
		?>
					<tr class="tax-rate tax-rate-<?php echo esc_attr(sanitize_title($code)); ?>">
						<th><?php echo esc_html($tax->label) . $estimated_text; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
							?></th>
						<td data-title="<?php echo esc_attr($tax->label); ?>"><?php echo wp_kses_post($tax->formatted_amount); ?></td>
					</tr>
				<?php
				}
			} else {
				?>
				<tr class="tax-total">
					<th><?php echo esc_html(WC()->countries->tax_or_vat()) . $estimated_text; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
						?></th>
					<td data-title="<?php echo esc_attr(WC()->countries->tax_or_vat()); ?>"><?php wc_cart_totals_taxes_total_html(); ?></td>
				</tr>
			<?php
			}
		}

		$subtotal = WC()->cart->get_subtotal();
		$discount_total = WC()->cart->get_discount_total();

		if ($discount_total > 0 && $subtotal > 0) {
			$discount_percentage = round(($discount_total / $subtotal) * 100);
			?>
			<tr class="discount-percentage">
				<th><?php echo __("تخفیف", "lamkadeh"); ?></th>
				<td data-title="<?php echo __("میزان تخفیف", "lamkadeh"); ?>">
					<p>٪<?php echo esc_html($discount_percentage); ?></p>
					<div class="discount-percentage-shape-circle-one"></div>
					<div class="discount-percentage-shape-circle-two"></div>
					<div class="discount-percentage-shape-circle-three"></div>
					<div class="discount-percentage-shape-circle-four"></div>
				</td>
			</tr>
		<?php
		}
		?>

		<?php do_action('woocommerce_cart_totals_before_order_total'); ?>

		<tr class="order-total">
			<th><?php esc_html_e('مبلغ نهایی سفارش', 'lamkadeh'); ?></th>
			<td data-title="<?php esc_attr_e('Total', 'woocommerce'); ?>"><?php wc_cart_totals_order_total_html(); ?></td>
		</tr>

		<?php do_action('woocommerce_cart_totals_after_order_total'); ?>

	</table>

	<div class="wc-proceed-to-checkout">
		<?php do_action('woocommerce_proceed_to_checkout'); ?>
	</div>

	<?php do_action('woocommerce_after_cart_totals'); ?>

</div>