<?php
class Lamkadeh_Filter_Product_Category_Widget extends WP_Widget
{
    public function __construct()
    {
        parent::__construct(
            'lamkadeh_filter_product_category',
            __('فیلتر دسته بندی محصولات - لمکده', 'lamkadeh'),
            array('description' => __('نمایش فیلتر دسته بندی محصولات در سایدبار فروشگاه', 'lamkadeh'))
        );
    }

    // تابع دریافت دسته‌بندی فعلی از URL
    private function get_current_category()
    {
        if (is_product_category()) {
            $category = get_queried_object();
            return array(
                'slug' => $category->slug,
                'name' => $category->name,
                'url' => get_term_link($category)
            );
        }
        return null;
    }

    // تابع دریافت دسته‌بندی‌های محصولات
    private function get_product_categories($hide_empty = true)
    {
        $args = array(
            'taxonomy' => 'product_cat',
            'hide_empty' => $hide_empty,
            'orderby' => 'name',
            'order' => 'ASC'
        );

        $terms = get_terms($args);

        if (is_wp_error($terms)) {
            return array();
        }

        $categories = array();
        foreach ($terms as $term) {
            $categories[] = array(
                'id' => $term->term_id,
                'name' => $term->name,
                'slug' => $term->slug,
                'count' => $term->count,
                'url' => get_term_link($term)
            );
        }

        return $categories;
    }

    // تابع رندر لیست دسته‌بندی‌ها
    private function render_categories_list($categories, $current_category_slug = '')
    {
        if (empty($categories)) {
            echo '<div class="no-categories-message">' . __('دسته‌بندی‌ای یافت نشد.', 'lamkadeh') . '</div>';
            return;
        }

        foreach ($categories as $category) {
            $is_active = ($category['slug'] === $current_category_slug);
?>
            <div class="content-category-item <?php echo $is_active ? 'active' : ''; ?>"
                data-category-slug="<?php echo esc_attr($category['slug']); ?>"
                data-category-name="<?php echo esc_attr($category['name']); ?>"
                data-category-url="<?php echo esc_url($category['url']); ?>">
                <div class="content-category-item-data">
                    <span><?php echo esc_html($category['name']); ?></span>
                    <span><?php echo $category['count'] . ' ' . __('کالا', 'lamkadeh'); ?></span>
                </div>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <circle cx="12" cy="12" r="10" stroke="white" stroke-width="1.5" />
                    <path d="M8.5 12.5L10.5 14.5L15.5 9.5" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                </svg>
            </div>
        <?php
        }
    }

    public function widget($args, $instance)
    {
        // دریافت تنظیمات
        $hide_empty = !empty($instance['hide_empty']) ? (bool)$instance['hide_empty'] : true;

        // دریافت دسته‌بندی فعلی
        $current_category = $this->get_current_category();
        $current_category_slug = $current_category ? $current_category['slug'] : '';
        $current_category_name = $current_category ? $current_category['name'] : '';

        $all_categories = $this->get_product_categories($hide_empty);

        // بررسی آیا در دسته‌بندی خاصی هستیم یا نه
        $has_current_category = !empty($current_category_slug);

        echo $args['before_widget'];
        ?>
        <section class="filter-product-category">
            <div class="filter-product-category-buttom <?php echo $has_current_category ? 'active' : ''; ?>">
                <span><?php echo __("دسته بندی", "lamkadeh"); ?></span>
                <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M21.0813 15.96C20.8597 15.96 20.638 16.0417 20.463 16.2167L13.9997 22.68L7.53632 16.2167C7.19798 15.8783 6.63798 15.8783 6.29965 16.2167C5.96132 16.555 5.96132 17.115 6.29965 17.4533L13.3813 24.535C13.7197 24.8733 14.2796 24.8733 14.618 24.535L21.6997 17.4533C22.038 17.115 22.038 16.555 21.6997 16.2167C21.5363 16.0417 21.303 15.96 21.0813 15.96Z" fill="white" />
                    <path d="M14 3.20833C13.5217 3.20833 13.125 3.60499 13.125 4.08333L13.125 23.7183C13.125 24.1967 13.5217 24.5933 14 24.5933C14.4783 24.5933 14.875 24.1967 14.875 23.7183L14.875 4.08333C14.875 3.60499 14.4783 3.20833 14 3.20833Z" fill="white" />
                </svg>
                <div class="content">
                    <div class="content-category-me" id="selected-categories-container" <?php echo !$has_current_category ? 'style="display:none;"' : ''; ?>>
                        <span><?php echo __("دسته بندی های شمـــــــــا", "lamkadeh") ?></span>
                        <div class="content-category-me-items" id="selected-categories-items">
                            <?php if ($has_current_category): ?>
                                <div class="content-category-me-item" data-category-slug="<?php echo esc_attr($current_category_slug); ?>">
                                    <span><?php echo esc_html($current_category_name); ?></span>
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M8.35891 7.4747C8.11483 7.23062 7.7191 7.23062 7.47502 7.4747C7.23095 7.71878 7.23095 8.11451 7.47502 8.35858L9.11642 9.99998L7.47504 11.6414C7.23096 11.8854 7.23096 12.2812 7.47504 12.5253C7.71912 12.7693 8.11485 12.7693 8.35893 12.5253L10.0003 10.8839L11.6417 12.5252C11.8858 12.7693 12.2815 12.7693 12.5256 12.5252C12.7696 12.2812 12.7696 11.8854 12.5256 11.6414L10.8842 9.99998L12.5256 8.3586C12.7697 8.11452 12.7697 7.7188 12.5256 7.47472C12.2815 7.23064 11.8858 7.23064 11.6417 7.47472L10.0003 9.1161L8.35891 7.4747Z" fill="#1D2977" />
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M10.0003 1.04166C5.05277 1.04166 1.04199 5.05244 1.04199 9.99999C1.04199 14.9475 5.05277 18.9583 10.0003 18.9583C14.9479 18.9583 18.9587 14.9475 18.9587 9.99999C18.9587 5.05244 14.9479 1.04166 10.0003 1.04166ZM2.29199 9.99999C2.29199 5.74279 5.74313 2.29166 10.0003 2.29166C14.2575 2.29166 17.7087 5.74279 17.7087 9.99999C17.7087 14.2572 14.2575 17.7083 10.0003 17.7083C5.74313 17.7083 2.29199 14.2572 2.29199 9.99999Z" fill="#1D2977" />
                                    </svg>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <span><?php echo __("دسته بنـــــــــدی ها", "lamkadeh") ?></span>

                    <div class="content-category">
                        <?php $this->render_categories_list($all_categories, $current_category_slug); ?>
                    </div>
                </div>
            </div>
        </section>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const filterWidget = {
                    init() {
                        this.currentCategorySlug = '<?php echo $current_category_slug; ?>';
                        this.currentCategoryName = '<?php echo $current_category_name; ?>';

                        // اگر دسته‌بندی‌ای انتخاب شده، آکوردین رو active کن
                        if (this.currentCategorySlug) {
                            this.openAccordion();
                        }

                        this.bindEvents();
                    },

                    // تابع باز کردن آکوردین
                    openAccordion() {
                        const accordionButton = document.querySelector('.filter-product-category-buttom');
                        accordionButton.classList.add('active');
                    },

                    // تابع بستن آکوردین
                    closeAccordion() {
                        const accordionButton = document.querySelector('.filter-product-category-buttom');
                        accordionButton.classList.remove('active');
                    },

                    bindEvents() {
                        // آکاردیون - فقط روی دکمه اصلی کار کنه
                        const accordionButton = document.querySelector('.filter-product-category-buttom');

                        accordionButton.addEventListener('click', (e) => {
                            // فقط اگر روی خود دکمه اصلی کلیک شده (نه روی محتوای داخلش)
                            if (e.target === accordionButton ||
                                e.target.tagName.toLowerCase() === 'span' ||
                                e.target.tagName.toLowerCase() === 'svg' ||
                                e.target.tagName.toLowerCase() === 'path') {

                                // اگر روی content کلیک شده، کاری نکن
                                const content = accordionButton.querySelector('.content');
                                if (content.contains(e.target)) {
                                    return;
                                }

                                accordionButton.classList.toggle('active');
                            }
                        });

                        // کلیک روی دسته‌بندی
                        document.addEventListener('click', (e) => {
                            const categoryItem = e.target.closest('.content-category-item');
                            if (categoryItem) {
                                this.selectCategory(categoryItem);
                            }

                            // حذف دسته‌بندی
                            const removeBtn = e.target.closest('.content-category-me-item');
                            if (removeBtn) {
                                this.removeCategory();
                            }
                        });
                    },

                    selectCategory(categoryItem) {
                        const categoryUrl = categoryItem.dataset.categoryUrl;

                        // رفتن به صفحه دسته‌بندی انتخاب شده
                        window.location.href = categoryUrl;
                    },

                    removeCategory() {
                        // رفتن به صفحه shop (آرشیو اصلی)
                        const shopUrl = '<?php echo esc_url(get_permalink(wc_get_page_id('shop'))); ?>';
                        window.location.href = shopUrl;
                    }
                };

                filterWidget.init();
            });
        </script>
    <?php
        echo $args['after_widget'];
    }

    public function form($instance)
    {
        $hide_empty = isset($instance['hide_empty']) ? (bool)$instance['hide_empty'] : true;
    ?>
        <p>
            <input type="checkbox"
                id="<?php echo $this->get_field_id('hide_empty'); ?>"
                name="<?php echo $this->get_field_name('hide_empty'); ?>"
                value="1"
                <?php checked($hide_empty, true); ?> />
            <label for="<?php echo $this->get_field_id('hide_empty'); ?>">
                <?php echo __('مخفی کردن دسته‌بندی‌های خالی', 'lamkadeh'); ?>
            </label>
            <br>
            <small><?php echo __('اگر فعال باشد، دسته‌بندی‌هایی که محصولی ندارند نمایش داده نمی‌شوند.', 'lamkadeh'); ?></small>
        </p>

        <p><?php echo __('این ویجت فیلتر دسته‌بندی محصولات را نمایش می‌دهد.', 'lamkadeh'); ?></p>
<?php
    }

    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['hide_empty'] = !empty($new_instance['hide_empty']) ? 1 : 0;
        return $instance;
    }
}

add_action('widgets_init', function () {
    register_widget('Lamkadeh_Filter_Product_Category_Widget');
});
?>