<?php

function lamkadeh_track_post_views()
{
    if (!is_single())
        return;

    global $post;
    $post_id = $post->ID;

    if (is_user_logged_in()) {
        $user_id = get_current_user_id();
        $meta_key = 'viewed_by_user_' . $user_id;
    } else {
        $user_ip = $_SERVER['REMOTE_ADDR'];
        $meta_key = 'viewed_by_ip_' . md5($user_ip);
    }

    $already_viewed = get_post_meta($post_id, $meta_key, true);

    if (!$already_viewed) {
        update_post_meta($post_id, $meta_key, true);

        $views = (int) get_post_meta($post_id, 'lamkadeh_post_views_count', true);
        $views++;
        update_post_meta($post_id, 'lamkadeh_post_views_count', $views);
    }
}
add_action('wp', 'lamkadeh_track_post_views');

add_action('wp_ajax_like_post_action', 'handle_like_post_action');
add_action('wp_ajax_nopriv_like_post_action', 'handle_like_post_action');

function handle_like_post_action()
{
    $post_id = intval($_POST['post_id']);
    if (!$post_id)
        wp_send_json_error('Invalid post ID');

    $user_id = get_current_user_id();
    $ip = $_SERVER['REMOTE_ADDR'];

    $liked_users = get_post_meta($post_id, '_liked_users', true) ?: [];
    $liked_ips = get_post_meta($post_id, '_liked_ips', true) ?: [];

    $already_liked = false;

    if ($user_id && in_array($user_id, $liked_users)) {
        $already_liked = true;
    } elseif (!$user_id && in_array($ip, $liked_ips)) {
        $already_liked = true;
    }

    if (!$already_liked) {
        if ($user_id) {
            $liked_users[] = $user_id;
            update_post_meta($post_id, '_liked_users', $liked_users);
        } else {
            $liked_ips[] = $ip;
            update_post_meta($post_id, '_liked_ips', $liked_ips);
        }

        $count = intval(get_post_meta($post_id, '_like_count', true));
        update_post_meta($post_id, '_like_count', $count + 1);

        wp_send_json_success(['liked' => true]);
    } else {
        wp_send_json_success(['liked' => false]);
    }
}

add_action("wp_footer", "likeBlog");
function likeBlog()
{
    ?>
    <script>
        jQuery(document).ready(function ($) {
            $('.sidebar-blog-item-left-meta-like').on('click', function () {
                const likeBtn = $(this);
                const postId = likeBtn.data('post-id');
                if (!postId) return;

                $.post('<?php echo admin_url("admin-ajax.php"); ?>', {
                    action: 'lamkadeh_toggle_like',
                    post_id: postId
                }, function (response) {
                    if (response.success) {
                        if (response.data.liked) {
                            likeBtn.addClass('active');
                        } else {
                            likeBtn.removeClass('active');
                        }
                    }
                });
            })
        });

        document.addEventListener('DOMContentLoaded', function () {
            const likeBtn = document.getElementById('like-post');
            if (!likeBtn) return;

            const postID = likeBtn.getAttribute('data-postid');
            fetch('<?php echo admin_url("admin-ajax.php"); ?>?action=check_liked_status&post_id=' + postID)
                .then(res => res.json())
                .then(data => {
                    if (data.liked) likeBtn.classList.add('active');
                });

            likeBtn.addEventListener('click', function () {
                fetch('<?php echo admin_url("admin-ajax.php"); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded'
                    },
                    body: new URLSearchParams({
                        'action': 'like_post_action',
                        'post_id': postID
                    })
                })
                    .then(res => res.json())
                    .then(data => {
                        if (data.success && data.data.liked) {
                            likeBtn.classList.add('active');
                        }
                    });
            });
        });
    </script>
    <?php
}

add_action('wp_ajax_check_liked_status', 'check_liked_status');
add_action('wp_ajax_nopriv_check_liked_status', 'check_liked_status');

function check_liked_status()
{
    $post_id = intval($_GET['post_id']);
    $user_id = get_current_user_id();
    $ip = $_SERVER['REMOTE_ADDR'];

    $liked_users = get_post_meta($post_id, '_liked_users', true) ?: [];
    $liked_ips = get_post_meta($post_id, '_liked_ips', true) ?: [];

    $liked = false;
    if ($user_id && in_array($user_id, $liked_users))
        $liked = true;
    if (!$user_id && in_array($ip, $liked_ips))
        $liked = true;

    wp_send_json(['liked' => $liked]);
}

add_action('wp_ajax_lamkadeh_toggle_like', 'lamkadeh_toggle_like');
add_action('wp_ajax_nopriv_lamkadeh_toggle_like', 'lamkadeh_toggle_like');

function lamkadeh_toggle_like()
{
    $post_id = intval($_POST['post_id']);
    $user_id = get_current_user_id();
    $user_ip = $_SERVER['REMOTE_ADDR'];

    if (!$post_id) {
        wp_send_json_error('invalid_post');
    }

    // گرفتن آرایه‌ی لایک‌ها از متای پست
    $likes = get_post_meta($post_id, '_lamkadeh_likes', true);
    if (!is_array($likes))
        $likes = [];

    $unique_key = $user_id ? 'user_' . $user_id : 'ip_' . $user_ip;

    // بررسی لایک قبلی
    if (in_array($unique_key, $likes)) {
        // اگر قبلاً لایک کرده بود، حذف کن (آنلایک)
        $likes = array_diff($likes, [$unique_key]);
        update_post_meta($post_id, '_lamkadeh_likes', $likes);
        wp_send_json_success(['liked' => false]);
    } else {
        // اگر لایک نکرده بود، اضافه کن
        $likes[] = $unique_key;
        update_post_meta($post_id, '_lamkadeh_likes', $likes);
        wp_send_json_success(['liked' => true]);
    }
}

add_action('comment_post', function ($comment_id) {
    if (isset($_POST['rating']) && !empty($_POST['rating'])) {
        $rating = intval($_POST['rating']);
        add_comment_meta($comment_id, 'rating', $rating);
    }
});

add_action('comment_post', 'save_comment_lastname');
function save_comment_lastname($comment_id)
{
    if (isset($_POST['lastname']) && $_POST['lastname'] !== '') {
        update_comment_meta($comment_id, 'lastname', sanitize_text_field($_POST['lastname']));
    }
}

function calculate_reading_time($content)
{
    $text = strip_tags($content);
    $text = preg_replace('/\s+/', ' ', $text);
    $text = trim($text);

    if (empty($text)) {
        return __('۵ دقیقه', "lamkadeh");
    }

    $words = explode(' ', $text);
    $word_count = count($words);

    $word_count = count(array_filter($words, function ($word) {
        return !empty(trim($word));
    }));

    $reading_time = ceil($word_count / 150);
    $reading_time = max(1, $reading_time);

    return $reading_time . __(' دقیقه', "lamkadeh");
}
