<?php

add_action('template_redirect', function () {
    ob_start('minify_html_and_css');
});

function minify_html_and_css($buffer)
{
    if (
        strpos($_SERVER['HTTP_ACCEPT'] ?? '', 'text/html') !== false &&
        !is_admin() &&
        !defined('DOING_AJAX')
    ) {
        preg_match_all('#<script\b[^>]*>.*?</script>#is', $buffer, $scripts);
        $placeholders = [];
        foreach ($scripts[0] as $i => $script) {
            $key = "###SCRIPT_PLACEHOLDER_$i###";
            $placeholders[$key] = $script;
            $buffer = str_replace($script, $key, $buffer);
        }
        $buffer = preg_replace('/>\s+</', '><', $buffer);
        $buffer = preg_replace_callback(
            '#<style\b[^>]*>(.*?)</style>#is',
            function ($matches) {
                $css = $matches[1];
                $css = preg_replace('/\s+/', ' ', $css);
                return "<style>{$css}</style>";
            },
            $buffer
        );
        foreach ($placeholders as $key => $script) {
            $buffer = str_replace($key, $script, $buffer);
        }
    }
    return $buffer;
}
