<?php

require_once(__DIR__ . "/minification-html/webmarkupmin.php");
require_once(__DIR__ . "/tgmpa/install-requirements.php");
require_once(__DIR__ . "/property-color-products/property-color-products.php");
require_once(__DIR__ . "/nav-menu/nav-menu.php");
require_once(__DIR__ . "/breadcrumb/breadcrumb.php");
require_once(__DIR__ . "/sidebars/sidebars.php");
require_once(__DIR__ . "/single/single-blog.php");

require_once(__DIR__ . "/widgets/init.php");

require_once(__DIR__ . "/hook-woocommerce/cart.php");
require_once(__DIR__ . "/hook-woocommerce/myaccount.php");
require_once(__DIR__ . "/hook-woocommerce/single-product.php");
require_once(__DIR__ . "/hook-woocommerce/tickets/tickets.php");
require_once(__DIR__ . "/hook-woocommerce/whishlist.php");
require_once(__DIR__ . "/hook-woocommerce/notification/notification.php");
require_once(__DIR__ . "/hook-woocommerce/checkout.php");
require_once(__DIR__ . "/hook-woocommerce/archive-product.php");

add_action('after_switch_theme', 'lamkadeh_check_required_plugins');

function lamkadeh_check_required_plugins()
{
    $missing_plugins = lamkadeh_get_missing_plugins();

    if (! empty($missing_plugins)) {
        switch_theme(WP_DEFAULT_THEME);

        wp_die(
            __('<h1>فعال‌سازی قالب ناموفق بود</h1>', "lamkadeh") .
                __('<p>برای استفاده از این قالب باید پلاگین‌های زیر نصب و فعال باشند:</p>', "lamkadeh") .
                '<ul><li>' . implode('</li><li>', $missing_plugins) . '</li></ul>' .
                '<p><a href="' . admin_url('plugins.php') . '"> ' . __("بازگشت به مدیریت افزونه‌ها ", "lamkadeh") . '</a></p>',
            __('خطای فعال‌سازی قالب', "lamkadeh"),
            ['back_link' => true]
        );
    }
}

add_action('admin_init', function () {
    $missing_plugins = lamkadeh_get_missing_plugins();

    if (! empty($missing_plugins)) {
        add_action('admin_notices', function () use ($missing_plugins) {
            echo '<div class="notice notice-error"><p>';
            echo __('قالب <strong>لمکده</strong> نیازمند نصب و فعال بودن پلاگین‌های زیر است: ', "lamkadeh");
            echo '<ul><li>' . implode('</li><li>', $missing_plugins) . '</li></ul>';
            echo '</p></div>';
        });

        switch_theme(WP_DEFAULT_THEME);
    }
});

function lamkadeh_get_missing_plugins()
{
    $missing_plugins = [];

    if (! class_exists('WooCommerce')) {
        $missing_plugins[] = 'WooCommerce';
    }

    if (! class_exists('\Elementor\Plugin')) {
        $missing_plugins[] = 'Elementor';
    }

    return $missing_plugins;
}
