<?php

// مدیریت علاقه‌مندی‌ها
add_action('wp_ajax_toggle_wishlist', 'handle_toggle_wishlist');
add_action('wp_ajax_nopriv_toggle_wishlist', 'handle_toggle_wishlist_not_logged_in');

function handle_toggle_wishlist()
{
    if (!wp_verify_nonce($_POST['nonce'], 'wishlist_nonce')) {
        wp_send_json_error(__('خطای امنیتی', "lamkadeh"));
        return;
    }

    if (!is_user_logged_in()) {
        wp_send_json_error(__('لطفاً ابتدا وارد حساب کاربری خود شوید', "lamkadeh"));
        return;
    }

    $product_id = intval($_POST['product_id']);
    $user_id = get_current_user_id();

    $wishlist = get_user_meta($user_id, 'lamkadeh_wishlist', true);
    if (empty($wishlist) || !is_array($wishlist)) {
        $wishlist = [];
    }

    $product_index = array_search($product_id, $wishlist);

    if ($product_index !== false) {
        unset($wishlist[$product_index]);
        $wishlist = array_values($wishlist);
        $added = false;
        $message = __('محصول از علاقه‌مندی‌ها حذف شد', "lamkadeh");
    } else {
        $wishlist[] = $product_id;
        $added = true;
        $message = __('محصول به علاقه‌مندی‌ها اضافه شد', "lamkadeh");
    }

    update_user_meta($user_id, 'lamkadeh_wishlist', $wishlist);

    wp_send_json_success([
        'added' => $added,
        'count' => count($wishlist),
        'message' => $message
    ]);
}

function handle_toggle_wishlist_not_logged_in()
{
    wp_send_json_error(__('لطفاً ابتدا وارد حساب کاربری خود شوید', "lamkadeh"));
}

add_action('wp_ajax_toggle_wishlist', 'lamkadeh_toggle_wishlist');
function lamkadeh_toggle_wishlist()
{
    check_ajax_referer('lamkadeh_wishlist_nonce', 'security');

    if (!is_user_logged_in()) {
        wp_send_json_error(['message' => __('ابتدا وارد حساب کاربری شوید', "lamkadeh")]);
    }

    $user_id = get_current_user_id();
    $product_id = intval($_POST['product_id']);
    $wishlist = get_user_meta($user_id, 'lamkadeh_wishlist', true);

    if (!is_array($wishlist)) {
        $wishlist = [];
    }

    if (in_array($product_id, $wishlist)) {
        $wishlist = array_diff($wishlist, [$product_id]);
        update_user_meta($user_id, 'lamkadeh_wishlist', $wishlist);
        wp_send_json_success(['added' => false]);
    } else {
        $wishlist[] = $product_id;
        update_user_meta($user_id, 'lamkadeh_wishlist', $wishlist);
        wp_send_json_success(['added' => true]);
    }
}

add_filter('woocommerce_account_menu_items', function ($items) {
    $wishlist_item = ['wishlist' => 'علاقه‌مندی‌ها'];
    $items = array_slice($items, 0, 4, true)
        + $wishlist_item
        + array_slice($items, 1, null, true);

    return $items;
});

add_action('init', function () {
    add_rewrite_endpoint('wishlist', EP_ROOT | EP_PAGES);
});

add_action('woocommerce_account_wishlist_endpoint', function () {
    $user_id = get_current_user_id();
    $wishlist = get_user_meta($user_id, 'lamkadeh_wishlist', true);
?>
    <section class="header-categories-main">
        <div class="title-header-categories-main">
            <span>FAVORITES</span>
            <div class="text-header-categories-main">
                <span><?php echo __("<strong>علاقه مندی هــــــــــا</strong>", "lamkadeh") ?></span>
                <svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_26_3865)">
                        <circle cx="32" cy="32" r="32" transform="matrix(-1 0 0 1 64 0)" fill="#FFD701" />
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M42 10.2917C40.9644 10.2917 40.125 11.1311 40.125 12.1667V12.3787C40.4729 12.375 40.8485 12.375 41.2543 12.375H42.7456C43.1515 12.375 43.5271 12.375 43.875 12.3787V12.1667C43.875 11.1311 43.0355 10.2917 42 10.2917ZM45.125 12.4224V12.1667C45.125 10.4408 43.7259 9.04166 42 9.04166C40.2741 9.04166 38.875 10.4408 38.875 12.1667V12.4224C38.7625 12.4306 38.6539 12.4403 38.5491 12.4516C37.8172 12.5305 37.205 12.6957 36.6615 13.0683C36.4745 13.1964 36.2989 13.3404 36.1366 13.4986C35.6646 13.9586 35.3825 14.5264 35.1616 15.2286C34.9471 15.9105 34.7738 16.7772 34.556 17.8663L34.5401 17.9458C34.2262 19.5151 33.9789 20.7517 33.9079 21.7366C33.8353 22.743 33.9367 23.5896 34.4134 24.3233C34.5725 24.5681 34.7581 24.7945 34.9669 24.9985C35.5929 25.6098 36.4032 25.8753 37.4042 26.0015C38.384 26.125 39.6451 26.125 41.2454 26.125H42.7545C44.3549 26.125 45.616 26.125 46.5957 26.0015C47.5968 25.8753 48.4071 25.6098 49.033 24.9985C49.2418 24.7945 49.4275 24.5681 49.5865 24.3233C50.0632 23.5896 50.1647 22.743 50.0921 21.7366C50.021 20.7517 49.7737 19.5151 49.4599 17.9459L49.444 17.8663C49.2261 16.7772 49.0528 15.9105 48.8383 15.2286C48.6174 14.5264 48.3353 13.9586 47.8634 13.4986C47.701 13.3404 47.5254 13.1964 47.3385 13.0683C46.7949 12.6957 46.1828 12.5305 45.4508 12.4516C45.346 12.4403 45.2375 12.4306 45.125 12.4224ZM38.6831 13.6944C38.0608 13.7614 37.6764 13.8881 37.3682 14.0994C37.2402 14.187 37.1201 14.2855 37.009 14.3938C36.7414 14.6546 36.5418 15.0067 36.354 15.6037C36.1621 16.2138 36.0011 17.0144 35.7746 18.1468C35.45 19.7699 35.2193 20.9294 35.1546 21.8265C35.0908 22.7115 35.1986 23.2374 35.4616 23.6422C35.5704 23.8097 35.6974 23.9647 35.8403 24.1042C36.1857 24.4415 36.6803 24.6504 37.5606 24.7613C38.453 24.8738 39.6352 24.875 41.2904 24.875H42.7095C44.3648 24.875 45.547 24.8738 46.4394 24.7613C47.3196 24.6504 47.8142 24.4415 48.1596 24.1042C48.3025 23.9647 48.4295 23.8097 48.5384 23.6422C48.8014 23.2374 48.9091 22.7115 48.8453 21.8265C48.7806 20.9294 48.5499 19.7699 48.2253 18.1468C47.9988 17.0144 47.8378 16.2138 47.6459 15.6037C47.4581 15.0067 47.2585 14.6546 46.9909 14.3938C46.8799 14.2855 46.7597 14.187 46.6318 14.0994C46.3236 13.8881 45.9391 13.7614 45.3169 13.6944C44.681 13.6258 43.8644 13.625 42.7095 13.625L41.2904 13.625C40.1355 13.625 39.319 13.6258 38.6831 13.6944ZM39.4341 19.9107C39.7596 19.7957 40.1166 19.9663 40.2317 20.2917C40.4894 21.0208 41.1847 21.5417 42.0001 21.5417C42.8155 21.5417 43.5109 21.0208 43.7686 20.2917C43.8836 19.9663 44.2407 19.7957 44.5662 19.9107C44.8916 20.0257 45.0622 20.3828 44.9472 20.7083C44.5185 21.9212 43.3618 22.7917 42.0001 22.7917C40.6385 22.7917 39.4818 21.9212 39.0531 20.7083C38.9381 20.3828 39.1087 20.0257 39.4341 19.9107Z" fill="#1D2977" />
                        <circle cx="22" cy="60" r="17" fill="#F7F8FD" fill-opacity="0.64" />
                    </g>
                    <defs>
                        <clipPath id="clip0_26_3865">
                            <rect width="64" height="64" rx="32" fill="white" />
                        </clipPath>
                    </defs>
                </svg>
            </div>
            <div class="shape-header-categories-main"></div>
        </div>
    </section>
    <?php
    if (empty($wishlist)) {
    ?>

        <section class="no-dashboard-lamkadeh">
            <svg width="72" height="72" viewBox="0 0 72 72" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M16.8731 13.2726C11.8961 15.5475 8.25 20.9587 8.25 27.4113C8.25 34.0035 10.9477 39.0847 14.8149 43.4393C18.0022 47.0283 21.8605 50.0029 25.6234 52.9038C26.5171 53.5928 27.4054 54.2777 28.2781 54.9656C29.8562 56.2097 31.264 57.3016 32.6208 58.0944C33.9784 58.8878 35.0712 59.25 36 59.25C36.9288 59.25 38.0216 58.8878 39.3792 58.0944C40.736 57.3016 42.1438 56.2097 43.7219 54.9656C44.5946 54.2777 45.4829 53.5928 46.3766 52.9038C50.1395 50.0029 53.9978 47.0283 57.1851 43.4393C61.0523 39.0847 63.75 34.0035 63.75 27.4113C63.75 20.9587 60.1039 15.5475 55.1269 13.2726C50.2918 11.0624 43.795 11.6477 37.6211 18.0622C37.1969 18.5029 36.6116 18.7519 36 18.7519C35.3884 18.7519 34.8031 18.5029 34.3789 18.0622C28.205 11.6477 21.7082 11.0624 16.8731 13.2726ZM36 13.3764C29.0638 7.1707 21.2969 6.30259 15.0023 9.17986C8.35414 12.2187 3.75 19.2751 3.75 27.4113C3.75 35.4079 7.08149 41.5081 11.4502 46.4274C14.9486 50.3668 19.2307 53.6638 23.0125 56.5757C23.8698 57.2358 24.7013 57.8761 25.4923 58.4996C27.029 59.711 28.6786 61.0028 30.3505 61.9797C32.0216 62.9562 33.9288 63.75 36 63.75C38.0712 63.75 39.9784 62.9562 41.6495 61.9797C43.3214 61.0028 44.971 59.711 46.5077 58.4996C47.2987 57.8761 48.1302 57.2358 48.9875 56.5757C52.7693 53.6638 57.0514 50.3668 60.5499 46.4274C64.9185 41.5081 68.25 35.4079 68.25 27.4113C68.25 19.2751 63.6459 12.2187 56.9977 9.17986C50.7031 6.30259 42.9362 7.1707 36 13.3764Z" fill="#1D2977" />
            </svg>
            <span><?php echo __("شما هنوز محصولی را به علاقمندی های خود اضافه نکرده اید.", "lamkadeh") ?></span>
            <a href="<?php echo esc_url(wc_get_page_permalink('shop')) ?>"><?php echo __("مشاهده محصولات", "lamkadeh") ?></a>
        </section>

    <?php
        return;
    }
    ?>
    <section class="wishlist-products">
        <?php
        foreach ($wishlist as $product_id) :
            $product = wc_get_product($product_id);
            if (!$product) continue;
        ?>
            <div class="product-archive-content-item">
                <div class="product-archive-content-item-header">
                    <?php
                    if (has_post_thumbnail($product->get_id())) {
                        echo get_the_post_thumbnail($product->get_id(), 'woocommerce_thumbnail', array(
                            'class' => 'lamkadeh-product-image',
                            'alt'   => get_the_title($product->get_id()),
                        ));
                    } else {
                        echo '<img src="' . esc_url(wc_placeholder_img_src()) . '" alt="' . esc_attr(get_the_title($product->get_id())) . '" class="lamkadeh-product-image" />';
                    }
                    ?>
                    <div class="product-archive-content-item-header-button">
                        <div class="product-archive-content-item-header-button-item">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M16.5 2.25C14.7051 2.25 13.25 3.70507 13.25 5.5C13.25 5.69591 13.2673 5.88776 13.3006 6.07412L8.56991 9.38558C8.54587 9.4024 8.52312 9.42038 8.50168 9.43939C7.94993 9.00747 7.25503 8.75 6.5 8.75C4.70507 8.75 3.25 10.2051 3.25 12C3.25 13.7949 4.70507 15.25 6.5 15.25C7.25503 15.25 7.94993 14.9925 8.50168 14.5606C8.52312 14.5796 8.54587 14.5976 8.56991 14.6144L13.3006 17.9259C13.2673 18.1122 13.25 18.3041 13.25 18.5C13.25 20.2949 14.7051 21.75 16.5 21.75C18.2949 21.75 19.75 20.2949 19.75 18.5C19.75 16.7051 18.2949 15.25 16.5 15.25C15.4472 15.25 14.5113 15.7506 13.9174 16.5267L9.43806 13.3911C9.63809 12.9694 9.75 12.4978 9.75 12C9.75 11.5022 9.63809 11.0306 9.43806 10.6089L13.9174 7.4733C14.5113 8.24942 15.4472 8.75 16.5 8.75C18.2949 8.75 19.75 7.29493 19.75 5.5C19.75 3.70507 18.2949 2.25 16.5 2.25ZM14.75 5.5C14.75 4.5335 15.5335 3.75 16.5 3.75C17.4665 3.75 18.25 4.5335 18.25 5.5C18.25 6.4665 17.4665 7.25 16.5 7.25C15.5335 7.25 14.75 6.4665 14.75 5.5ZM6.5 10.25C5.5335 10.25 4.75 11.0335 4.75 12C4.75 12.9665 5.5335 13.75 6.5 13.75C7.4665 13.75 8.25 12.9665 8.25 12C8.25 11.0335 7.4665 10.25 6.5 10.25ZM16.5 16.75C15.5335 16.75 14.75 17.5335 14.75 18.5C14.75 19.4665 15.5335 20.25 16.5 20.25C17.4665 20.25 18.25 19.4665 18.25 18.5C18.25 17.5335 17.4665 16.75 16.5 16.75Z" fill="#1D2977" />
                            </svg>
                        </div>
                        <?php
                        if (is_user_logged_in()) :
                            $user_id = get_current_user_id();
                            $wishlist = get_user_meta($user_id, 'lamkadeh_wishlist', true);
                            $is_favorite = is_array($wishlist) && in_array($product->get_id(), $wishlist);
                        ?>
                            <div class="product-archive-content-item-header-button-item <?php echo $is_favorite ? 'active' : ''; ?>" data-product-id="<?php echo esc_attr($product->get_id()); ?>">
                                <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M4.21827 3.31808C2.97403 3.88683 2.0625 5.23961 2.0625 6.85276C2.0625 8.50081 2.73691 9.77111 3.70371 10.8598C4.50054 11.757 5.46513 12.5007 6.40584 13.2259C6.62928 13.3981 6.85136 13.5694 7.06953 13.7413C7.46406 14.0524 7.81599 14.3253 8.15521 14.5236C8.49461 14.7219 8.7678 14.8124 9 14.8124C9.2322 14.8124 9.50539 14.7219 9.84479 14.5236C10.184 14.3253 10.5359 14.0524 10.9305 13.7413C11.1486 13.5694 11.3707 13.3981 11.5942 13.2259C12.5349 12.5007 13.4995 11.757 14.2963 10.8598C15.2631 9.77111 15.9375 8.50081 15.9375 6.85276C15.9375 5.23961 15.026 3.88683 13.7817 3.31808C12.5729 2.76554 10.9488 2.91187 9.40527 4.51548C9.29923 4.62566 9.15291 4.68791 9 4.68791C8.84709 4.68791 8.70077 4.62566 8.59473 4.51548C7.05125 2.91187 5.42705 2.76554 4.21827 3.31808ZM9 3.34404C7.26596 1.79261 5.32422 1.57559 3.75057 2.2949C2.08853 3.05463 0.9375 4.81871 0.9375 6.85276C0.9375 8.85191 1.77037 10.377 2.86254 11.6068C3.73715 12.5916 4.80767 13.4159 5.75312 14.1439C5.96744 14.3089 6.17533 14.469 6.37306 14.6248C6.75724 14.9277 7.16966 15.2506 7.58762 15.4949C8.00539 15.739 8.4822 15.9374 9 15.9374C9.5178 15.9374 9.99461 15.739 10.4124 15.4949C10.8303 15.2506 11.2428 14.9277 11.6269 14.6248C11.8247 14.469 12.0326 14.3089 12.2469 14.1439C13.1923 13.4159 14.2628 12.5916 15.1375 11.6068C16.2296 10.377 17.0625 8.85191 17.0625 6.85276C17.0625 4.81871 15.9115 3.05463 14.2494 2.2949C12.6758 1.57559 10.734 1.79261 9 3.34404Z" fill="#1D2977" />
                                </svg>
                            </div>
                        <?php else : ?>
                            <div class="product-archive-content-item-header-button-item" onclick="loginBeforeWhishlist()">
                                <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M4.21827 3.31808C2.97403 3.88683 2.0625 5.23961 2.0625 6.85276C2.0625 8.50081 2.73691 9.77111 3.70371 10.8598C4.50054 11.757 5.46513 12.5007 6.40584 13.2259C6.62928 13.3981 6.85136 13.5694 7.06953 13.7413C7.46406 14.0524 7.81599 14.3253 8.15521 14.5236C8.49461 14.7219 8.7678 14.8124 9 14.8124C9.2322 14.8124 9.50539 14.7219 9.84479 14.5236C10.184 14.3253 10.5359 14.0524 10.9305 13.7413C11.1486 13.5694 11.3707 13.3981 11.5942 13.2259C12.5349 12.5007 13.4995 11.757 14.2963 10.8598C15.2631 9.77111 15.9375 8.50081 15.9375 6.85276C15.9375 5.23961 15.026 3.88683 13.7817 3.31808C12.5729 2.76554 10.9488 2.91187 9.40527 4.51548C9.29923 4.62566 9.15291 4.68791 9 4.68791C8.84709 4.68791 8.70077 4.62566 8.59473 4.51548C7.05125 2.91187 5.42705 2.76554 4.21827 3.31808ZM9 3.34404C7.26596 1.79261 5.32422 1.57559 3.75057 2.2949C2.08853 3.05463 0.9375 4.81871 0.9375 6.85276C0.9375 8.85191 1.77037 10.377 2.86254 11.6068C3.73715 12.5916 4.80767 13.4159 5.75312 14.1439C5.96744 14.3089 6.17533 14.469 6.37306 14.6248C6.75724 14.9277 7.16966 15.2506 7.58762 15.4949C8.00539 15.739 8.4822 15.9374 9 15.9374C9.5178 15.9374 9.99461 15.739 10.4124 15.4949C10.8303 15.2506 11.2428 14.9277 11.6269 14.6248C11.8247 14.469 12.0326 14.3089 12.2469 14.1439C13.1923 13.4159 14.2628 12.5916 15.1375 11.6068C16.2296 10.377 17.0625 8.85191 17.0625 6.85276C17.0625 4.81871 15.9115 3.05463 14.2494 2.2949C12.6758 1.57559 10.734 1.79261 9 3.34404Z" fill="#1D2977" />
                                </svg>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="single-product-lamkadeh-item-bottom">
                    <div class="single-product-lamkadeh-item-bottom-header">

                        <div class="single-product-lamkadeh-item-bottom-header-name">
                            <div class="single-product-lamkadeh-item-bottom-header-category">
                                <?php

                                $categories = get_the_terms($product->get_id(), 'product_cat');

                                if ($categories && !is_wp_error($categories)) {
                                    $main_category = null;
                                    foreach ($categories as $category) {
                                        if ($category->parent == 0) {
                                            $main_category = $category;
                                            break;
                                        }
                                    }

                                    if (!$main_category) {
                                        $main_category = reset($categories);
                                    }

                                    if ($main_category) {
                                        $thumbnail_id = get_term_meta($main_category->term_id, 'thumbnail_id', true);
                                        $image_url = $thumbnail_id
                                            ? wp_get_attachment_image_url($thumbnail_id, 'thumbnail')
                                            : wc_placeholder_img_src();
                                ?>
                                        <a href="<?php echo esc_url(get_term_link($main_category)) ?>" target="_blank" rel="follow" class="single-product-lamkadeh-item-bottom-header-category-name">

                                            <img src="<?php echo esc_url($image_url) ?>" alt="<?php echo esc_attr($main_category->name) ?>">
                                            <span><?php echo esc_html($main_category->name) ?></span>
                                        </a>
                                <?php
                                    }
                                }
                                ?>
                                <?php
                                if ($product && is_a($product, 'WC_Product')) {

                                    $is_in_stock = $product->is_in_stock();

                                    $stock_class = $is_in_stock ? 'in-stock' : 'out-of-stock';
                                    $stock_text  = $is_in_stock ? __('موجود در انبار', 'lamkadeh') : __('ناموجود در انبار', 'lamkadeh');
                                    $stock_color = $is_in_stock ? '#02734C' : '#CC0000';
                                ?>

                                    <div class="single-product-lamkadeh-item-bottom-header-category-stock <?php echo esc_attr($stock_class); ?>">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_1_11360)">
                                                <?php if ($is_in_stock) : ?>
                                                    <path d="M10.6866 6.68693C10.8818 6.49167 10.8818 6.17508 10.6866 5.97982C10.4913 5.78456 10.1747 5.78456 9.97945 5.97982L6.99968 8.9596L6.01989 7.97982C5.82463 7.78456 5.50805 7.78456 5.31279 7.97982C5.11753 8.17508 5.11753 8.49167 5.31279 8.68693L6.64612 10.0203C6.84138 10.2155 7.15797 10.2155 7.35323 10.0203L10.6866 6.68693Z" fill="<?php echo esc_attr($stock_color); ?>" />
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M7.99967 0.833373C4.04163 0.833374 0.833008 4.042 0.833008 8.00004C0.833009 11.9581 4.04164 15.1667 7.99968 15.1667C11.9577 15.1667 15.1663 11.9581 15.1663 8.00004C15.1663 4.042 11.9577 0.833373 7.99967 0.833373ZM1.83301 8.00004C1.83301 4.59429 4.59392 1.83337 7.99967 1.83337C11.4054 1.83337 14.1663 4.59428 14.1663 8.00004C14.1663 11.4058 11.4054 14.1667 7.99968 14.1667C4.59392 14.1667 1.83301 11.4058 1.83301 8.00004Z" fill="<?php echo esc_attr($stock_color); ?>" />
                                                <?php else : ?>
                                                    <path d="M5.5 5.5L10.5 10.5M10.5 5.5L5.5 10.5" stroke="<?php echo esc_attr($stock_color); ?>" stroke-width="1.2" stroke-linecap="round" />
                                                    <circle cx="8" cy="8" r="7.2" stroke="<?php echo esc_attr($stock_color); ?>" stroke-width="1.2" />
                                                <?php endif; ?>
                                            </g>
                                            <defs>
                                                <clipPath id="clip0_1_11360">
                                                    <rect width="16" height="16" fill="white" />
                                                </clipPath>
                                            </defs>
                                        </svg>
                                        <span><?php echo esc_html($stock_text); ?></span>
                                    </div>

                                <?php } ?>
                            </div>
                            <a href="<?php echo esc_url($product->get_permalink()) ?>" class="single-product-lamkadeh-item-bottom-header-name-title"><?php echo $product->get_name() ?></a>
                        </div>

                        <div class="underline-lamkadeh">
                            <div class="underline-lamkadeh-line"></div>
                            <div class="underline-lamkadeh-circle"></div>
                        </div>
                        <?php
                        $regular_price = floatval($product->get_regular_price());
                        $sale_price = floatval($product->get_sale_price());
                        $discount_percent = 0;
                        if ($product->is_type('variable')) {
                            $prices = $product->get_variation_prices(true);
                            $max_regular = !empty($prices['regular_price']) ? max($prices['regular_price']) : 0;
                            $min_sale = !empty($prices['sale_price']) ? min($prices['sale_price']) : 0;

                            if ($min_sale && $min_sale < $max_regular) {
                                $discount_percent = round((($max_regular - $min_sale) / $max_regular) * 100);
                            }
                            $display_regular = $max_regular;
                            $display_sale = $min_sale ? $min_sale : $max_regular;
                        } else {
                            $display_regular = $regular_price;
                            $display_sale = $sale_price ? $sale_price : $regular_price;

                            if ($sale_price && $sale_price < $regular_price) {
                                $discount_percent = round((($regular_price - $sale_price) / $regular_price) * 100);
                            }
                        }
                        ?>
                        <div class="single-product-lamkadeh-item-bottom-header-price" data-product-id="<?php echo esc_attr($product->get_id()); ?>">

                            <?php if ($discount_percent > 0): ?>
                                <div class="single-product-lamkadeh-item-bottom-header-price-regular">
                                    <div class="single-product-lamkadeh-item-bottom-header-price-regular-number">
                                        <?php echo format_price($display_regular); ?>
                                    </div>
                                    <div class="single-product-lamkadeh-item-bottom-header-price-regular-discount">
                                        %<?php echo esc_html($discount_percent); ?>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <div class="single-product-lamkadeh-item-bottom-header-price-sales-off">
                                <div class="single-product-lamkadeh-item-bottom-header-price-sales-off-shape"></div>
                                <span class="single-product-lamkadeh-item-bottom-header-price-sales-off-number">
                                    <?php echo format_price($display_sale); ?>
                                </span>
                                <span class="single-product-lamkadeh-item-bottom-header-price-sales-off-symbol">تومان</span>
                            </div>
                        </div>

                        <?php if ($product->is_type('variable')): ?>
                            <script>
                                document.addEventListener('DOMContentLoaded', function() {
                                    const wrapper = document.querySelector('.single-product-lamkadeh-item-bottom-header-price');
                                    const form = document.querySelector('form.variations_form');

                                    if (form && wrapper) {
                                        jQuery(form).on('found_variation', function(event, variation) {
                                            const regular = variation.display_regular_price;
                                            const sale = variation.display_price;
                                            const discount = regular > sale ? Math.round(((regular - sale) / regular) * 100) : 0;

                                            const regularBox = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-regular');
                                            const regularNumber = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-regular-number');
                                            const discountEl = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-regular-discount');
                                            const saleNumber = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-sales-off-number');

                                            if (discount > 0) {
                                                regularBox.style.display = 'flex';
                                                regularNumber.textContent = regular.toLocaleString();
                                                discountEl.textContent = '%' + discount;
                                            } else {
                                                regularBox.style.display = 'none';
                                            }

                                            saleNumber.textContent = sale.toLocaleString();
                                        });

                                        jQuery(form).on('reset_data', function() {
                                            const regularBox = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-regular');
                                            const regularNumber = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-regular-number');
                                            const discountEl = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-regular-discount');
                                            const saleNumber = wrapper.querySelector('.single-product-lamkadeh-item-bottom-header-price-sales-off-number');

                                            <?php if ($discount_percent > 0): ?>
                                                regularBox.style.display = 'flex';
                                                regularNumber.textContent = '<?php echo format_price($display_regular); ?>';
                                                discountEl.textContent = '%<?php echo $discount_percent; ?>';
                                            <?php else: ?>
                                                regularBox.style.display = 'none';
                                            <?php endif; ?>

                                            saleNumber.textContent = '<?php echo format_price($display_sale); ?>';
                                        });
                                    }
                                });
                            </script>
                        <?php endif; ?>

                        <div class="underline-lamkadeh">
                            <div class="underline-lamkadeh-line"></div>
                            <div class="underline-lamkadeh-circle"></div>
                        </div>
                    </div>
                    <?php
                    $product_id = (int) $product->get_id();

                    $buyers_map = lamkadeh_get_buyers_for_product($product_id);
                    $buyer_count = count($buyers_map);

                    $buyers_list = array_values($buyers_map);
                    shuffle($buyers_list);
                    $random_buyers = array_slice($buyers_list, 0, 3);

                    $fallback_avatar = esc_url(get_template_directory_uri() . '/assets/images/theme/avatar.png');

                    if ($buyer_count >= 1) {
                    ?>
                        <div class="single-product-lamkadeh-item-bottom-content">
                            <div class="single-product-lamkadeh-item-bottom-content-img">
                                <?php
                                if (! empty($random_buyers)) {
                                    foreach ($random_buyers as $b) {
                                        $avatar_url = $fallback_avatar;

                                        if (isset($b['type']) && $b['type'] === 'user' && ! empty($b['id'])) {
                                            $custom_avatar = get_user_meta((int)$b['id'], 'lamkadeh_user_avatar', true);
                                            if ($custom_avatar) {
                                                $avatar_url = esc_url($custom_avatar);
                                            } else {
                                                $avatar_url = get_avatar_url((int) $b['id'], array('size' => 80));
                                            }
                                        } elseif (isset($b['type']) && $b['type'] === 'email' && ! empty($b['email'])) {
                                            $avatar_url = get_avatar_url($b['email'], array('size' => 80));
                                        }
                                ?>
                                        <img src="<?php echo esc_url($avatar_url); ?>" alt="">
                                    <?php
                                    }
                                } else {
                                    ?>
                                    <img src="<?php echo $fallback_avatar; ?>" alt="">
                                    <img src="<?php echo $fallback_avatar; ?>" alt="">
                                <?php
                                }
                                ?>
                            </div>
                            <span>
                                <strong><?php echo esc_html(number_format_i18n($buyer_count)); ?>+ </strong>
                                <?php echo esc_html__('نفر از این محصول خرید کرده‌اند', 'lamkadeh'); ?>
                            </span>
                        </div>
                    <?php
                    }
                    ?>
                </div>
            </div>

        <?php
        endforeach;
        ?>
    </section>
<?php
});


add_action("wp_footer", "add_script_whishlist");
function add_script_whishlist()
{
?>
    <script>
        jQuery(document).ready(function($) {

            $('.wishlist-btn').on('click', function() {
                var button = $(this);
                var productId = button.data('product-id');

                if (!productId) {
                    console.log("productId is missing");
                    return;
                }

                $.ajax({
                    url: '<?php echo admin_url("admin-ajax.php"); ?>',
                    method: 'POST',
                    data: {
                        action: 'wishlist',
                        product_id: productId
                    },
                    success: function(response) {
                        if (response.success) {
                            if (response.data.status === 'added') {
                                button.addClass('active');
                                const Toast = Swal.mixin({
                                    toast: true,
                                    position: "bottom-end",
                                    showConfirmButton: false,
                                    timer: 4000,
                                    timerProgressBar: true,
                                    didOpen: (toast) => {
                                        toast.onmouseenter = Swal.stopTimer;
                                        toast.onmouseleave = Swal.resumeTimer;
                                    }
                                });
                                Toast.fire({
                                    icon: "success",
                                    title: "<?php echo esc_html__("محصول به علاقه مندی ها اضافه شد", "lamkadeh") ?>"
                                });
                            } else {
                                button.removeClass('active');
                                const Toast = Swal.mixin({
                                    toast: true,
                                    position: "bottom-end",
                                    showConfirmButton: false,
                                    timer: 4000,
                                    timerProgressBar: true,
                                    didOpen: (toast) => {
                                        toast.onmouseenter = Swal.stopTimer;
                                        toast.onmouseleave = Swal.resumeTimer;
                                    }
                                });
                                Toast.fire({
                                    icon: "info",
                                    title: "<?php echo esc_html__("محصول از علاقه مندی ها حذف شد", "lamkadeh") ?>"
                                });
                            }
                        } else {
                            const Toast = Swal.mixin({
                                toast: true,
                                position: "bottom-end",
                                showConfirmButton: false,
                                timer: 4000,
                                timerProgressBar: true,
                                didOpen: (toast) => {
                                    toast.onmouseenter = Swal.stopTimer;
                                    toast.onmouseleave = Swal.resumeTimer;
                                }
                            });
                            Toast.fire({
                                icon: "error",
                                title: "<?php echo esc_html__("خطای غیرمنتظره ای رخ داد مجدد تلاش کنید", "lamkadeh") ?>"
                            });
                        }
                    }
                });
            });
        });

        jQuery(document).ready(function($) {
            $('.product-share-btn').on('click', function() {
                const button = $(this);
                const url = button.data('product-url');
                const title = button.data('product-title');

                if (navigator.share) {
                    navigator.share({
                        title: title,
                        url: url
                    }).then(() => {
                        button.addClass('active');
                    }).catch(console.error);
                } else if (navigator.clipboard && navigator.clipboard.writeText) {
                    navigator.clipboard.writeText(url).then(() => {
                        const Toast = Swal.mixin({
                            toast: true,
                            position: "bottom-end",
                            showConfirmButton: false,
                            timer: 4000,
                            timerProgressBar: true,
                            didOpen: (toast) => {
                                toast.onmouseenter = Swal.stopTimer;
                                toast.onmouseleave = Swal.resumeTimer;
                            }
                        });
                        Toast.fire({
                            icon: "success",
                            title: "<?php echo esc_html__("لینک محصول در کلیپ بورد ذخیره شد", "lamkadeh") ?>"
                        });
                        button.addClass('active');
                    }).catch(err => {
                        console.error('Clipboard error:', err);
                        fallbackCopy(url, button);
                    });
                } else {
                    fallbackCopy(url, button);
                }
            });

            function fallbackCopy(text, button) {
                const tempInput = document.createElement('input');
                document.body.appendChild(tempInput);
                tempInput.value = text;
                tempInput.select();
                document.execCommand('copy');
                document.body.removeChild(tempInput);
                const Toast = Swal.mixin({
                    toast: true,
                    position: "bottom-end",
                    showConfirmButton: false,
                    timer: 4000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.onmouseenter = Swal.stopTimer;
                        toast.onmouseleave = Swal.resumeTimer;
                    }
                });
                Toast.fire({
                    icon: "success",
                    title: "<?php echo esc_html__("لینک محصول در کلیپ بورد ذخیره شد", "lamkadeh") ?>"
                });
                button.addClass('active');
            }
        });
    </script>
<?php
}

add_action('wp_ajax_wishlist', 'toggle_wishlist');
add_action('wp_ajax_nopriv_wishlist', 'toggle_wishlist');

function toggle_wishlist()
{
    if (!is_user_logged_in()) {
        wp_send_json_error(['message' => 'user not logged in']);
    }

    $user_id = get_current_user_id();
    $product_id = intval($_POST['product_id']);
    $wishlist = get_user_meta($user_id, 'lamkadeh_wishlist', true);

    if (!is_array($wishlist)) {
        $wishlist = [];
    }

    if (in_array($product_id, $wishlist)) {
        $wishlist = array_diff($wishlist, [$product_id]);
        update_user_meta($user_id, 'lamkadeh_wishlist', $wishlist);
        wp_send_json_success(['status' => 'removed']);
    } else {
        $wishlist[] = $product_id;
        update_user_meta($user_id, 'lamkadeh_wishlist', $wishlist);
        wp_send_json_success(['status' => 'added']);
    }

    wp_send_json_error(['message' => 'unexpected error']);
}
