<?php

add_action('wp_ajax_get_cart_count', 'lamkadeh_get_cart_count');
add_action('wp_ajax_nopriv_get_cart_count', 'lamkadeh_get_cart_count');

function lamkadeh_get_cart_count()
{
    if (! class_exists('WooCommerce')) {
        wp_send_json_error('WooCommerce not active');
    }

    $count = WC()->cart->get_cart_contents_count();
    wp_send_json_success(['count' => $count]);
}

add_action('wp_ajax_get_cart_data', 'get_cart_data_ajax');
add_action('wp_ajax_nopriv_get_cart_data', 'get_cart_data_ajax');

function get_cart_data_ajax()
{
    if (!class_exists('WooCommerce')) {
        wp_send_json_error('WooCommerce not active');
    }

    $cart = WC()->cart->get_cart();
    $items = [];
    $count = WC()->cart->get_cart_contents_count();

    // تابع برای حذف نماد تومان و فرمت کردن قیمت
    function format_price_without_toman($price_html)
    {
        // حذف نماد تومان و فاصله‌های اضافی
        $clean_price = str_replace(['تومان', '&#x200c;', '&nbsp;', ' ', ','], '', $price_html);
        // حذف تگ‌های HTML
        $clean_price = wp_strip_all_tags($clean_price);
        // حذف کاراکترهای غیرعددی
        $clean_price = preg_replace('/[^\d]/', '', $clean_price);

        // تبدیل به عدد و فرمت کردن با جداکننده هزارگان
        if (is_numeric($clean_price)) {
            return number_format((float)$clean_price);
        }

        return $clean_price;
    }

    foreach ($cart as $cart_item_key => $cart_item) {
        $product = $cart_item['data'];
        $regular_price = $product->get_regular_price();
        $sale_price = $product->get_sale_price();
        $price = $product->get_price();

        // محاسبه درصد تخفیف
        $discount_percentage = '';
        if ($sale_price && $regular_price && $sale_price < $regular_price) {
            $discount_percentage = round(($regular_price - $sale_price) / $regular_price * 100);
        }

        // قیمت‌های تمیز شده بدون نماد تومان و با جداکننده هزارگان
        $clean_price = format_price_without_toman(wc_price($price));
        $clean_regular_price = format_price_without_toman(wc_price($regular_price));
        $clean_sale_price = format_price_without_toman(wc_price($sale_price));

        $items[] = [
            'title' => $product->get_name(),
            'qty' => $cart_item['quantity'],
            'price' => $price,
            'price_html' => $clean_price,
            'regular_price_html' => $clean_regular_price,
            'sale_price_html' => $clean_sale_price,
            'discount_percentage' => $discount_percentage,
            'img' => get_the_post_thumbnail_url($product->get_id(), 'thumbnail'),
            'cart_item_key' => $cart_item_key,
            'product_id' => $product->get_id(),
            'product_url' => get_permalink($product->get_id())
        ];
    }

    // تمیز کردن قیمت کل با جداکننده هزارگان
    $clean_total = format_price_without_toman(WC()->cart->get_cart_total());
    $clean_subtotal = format_price_without_toman(WC()->cart->get_cart_subtotal());

    wp_send_json_success([
        'items' => $items,
        'total' => $clean_total,
        'count' => $count,
        'subtotal' => $clean_subtotal
    ]);
}

// افزودن action برای به‌روزرسانی آیتم‌های سبد خرید
add_action('wp_ajax_update_cart_item', 'update_cart_item_ajax');
add_action('wp_ajax_nopriv_update_cart_item', 'update_cart_item_ajax');

function update_cart_item_ajax()
{
    if (!class_exists('WooCommerce')) {
        wp_send_json_error('WooCommerce not active');
    }

    if (isset($_POST['key']) && isset($_POST['qty'])) {
        $cart_item_key = sanitize_text_field($_POST['key']);
        $quantity = intval($_POST['qty']);

        $cart = WC()->cart;

        if ($quantity === 0) {
            // حذف آیتم از سبد خرید
            $cart->remove_cart_item($cart_item_key);
        } else {
            // به‌روزرسانی تعداد
            $cart->set_quantity($cart_item_key, $quantity);
        }

        // محاسبه مجدد مجموع
        $cart->calculate_totals();

        wp_send_json_success();
    } else {
        wp_send_json_error('Invalid data');
    }
}

// افزودن action برای حذف آیتم از سبد خرید
add_action('wp_ajax_remove_cart_item', 'remove_cart_item_ajax');
add_action('wp_ajax_nopriv_remove_cart_item', 'remove_cart_item_ajax');

function remove_cart_item_ajax()
{
    if (!class_exists('WooCommerce')) {
        wp_send_json_error('WooCommerce not active');
    }

    if (isset($_POST['key'])) {
        $cart_item_key = sanitize_text_field($_POST['key']);
        WC()->cart->remove_cart_item($cart_item_key);

        // محاسبه مجدد مجموع
        WC()->cart->calculate_totals();

        wp_send_json_success();
    } else {
        wp_send_json_error('Invalid data');
    }
}

add_filter('template_include', 'is_cart_page');

function is_cart_page($template)
{
    if (is_cart()) {
        $custom_cart_file = get_template_directory() . '/woocommerce/cart/cart.php';

        if (file_exists($custom_cart_file)) {
            return $custom_cart_file;
        } else {
            wp_die('فایل سبد خرید یافت نشد.');
        }
    }

    return $template;
}
