<?php

// اضافه کردن هندلر AJAX برای دریافت محصولات برند
add_action('wp_ajax_get_brand_products', 'handle_get_brand_products');
add_action('wp_ajax_nopriv_get_brand_products', 'handle_get_brand_products');

function handle_get_brand_products()
{
    // بررسی brand_id
    if (!isset($_POST['brand_id']) || empty($_POST['brand_id'])) {
        wp_send_json_error('Brand ID is required');
    }

    $brand_id = intval($_POST['brand_id']);

    if ($brand_id <= 0) {
        wp_send_json_error('Invalid brand ID');
    }

    // تعریف توابع کمکی در صورت نیاز
    if (!function_exists('get_brand_products')) {
        function get_brand_products($brand_id, $posts_per_page = 4)
        {
            $args = array(
                'post_type' => 'product',
                'posts_per_page' => $posts_per_page,
                'tax_query' => array(
                    array(
                        'taxonomy' => 'product_brand',
                        'field' => 'term_id',
                        'terms' => $brand_id,
                    )
                ),
                'meta_key' => 'total_sales',
                'orderby' => 'meta_value_num',
                'order' => 'DESC'
            );
            return get_posts($args);
        }
    }

    if (!function_exists('get_product_prices')) {
        function get_product_prices($product)
        {
            $prices = array(
                'regular_price' => '',
                'sale_price' => '',
                'price' => '',
                'is_on_sale' => false,
                'discount_percentage' => 0
            );

            if ($product->is_type('variable')) {
                $variation_prices = $product->get_variation_prices(true);

                if (!empty($variation_prices['price'])) {
                    $min_regular_price = min($variation_prices['regular_price']);
                    $min_price = min($variation_prices['price']);

                    $prices['regular_price'] = $min_regular_price;
                    $prices['price'] = $min_price;
                    $prices['sale_price'] = $min_price;
                    $prices['is_on_sale'] = $min_price < $min_regular_price;

                    if ($prices['is_on_sale'] && $min_regular_price > 0) {
                        $prices['discount_percentage'] = round(($min_regular_price - $min_price) / $min_regular_price * 100);
                    }
                }
            } else {
                $prices['regular_price'] = $product->get_regular_price();
                $prices['sale_price'] = $product->get_sale_price();
                $prices['price'] = $product->get_price();
                $prices['is_on_sale'] = $product->is_on_sale();

                if ($prices['is_on_sale'] && $prices['regular_price'] > 0) {
                    $prices['discount_percentage'] = round(($prices['regular_price'] - $prices['sale_price']) / $prices['regular_price'] * 100);
                }
            }

            return $prices;
        }
    }

    if (!function_exists('get_product_category')) {
        function get_product_category($product_id)
        {
            $categories = get_the_terms($product_id, 'product_cat');
            if ($categories && !is_wp_error($categories)) {
                return $categories[0];
            }
            return null;
        }
    }

    if (!function_exists('format_price_without_symbol')) {
        function format_price_without_symbol($price)
        {
            if (empty($price)) return '';

            $price = floatval($price);
            $formatted = number_format($price);

            if (floor($price) == $price) {
                return $formatted;
            } else {
                return number_format($price, 0, '.', ',');
            }
        }
    }

    // دریافت محصولات
    $products = get_brand_products($brand_id);

    // تولید خروجی
    ob_start();

    if ($products) {
        $product_chunks = array_chunk($products, 2);

        foreach ($product_chunks as $chunk_index => $product_chunk): ?>
            <div class="product-brands-list-left-bottom-items" data-brand-id="<?php echo $brand_id; ?>">
                <?php foreach ($product_chunk as $product):
                    $product_id = $product->ID;
                    $wc_product = wc_get_product($product_id);

                    if (!$wc_product) continue;

                    $product_prices = get_product_prices($wc_product);
                    $product_category = get_product_category($product_id);
                ?>
                    <div class="product-brands-list-left-bottom-item">
                        <div class="product-brands-list-left-bottom-item-image">
                            <?php
                            $product_image = get_the_post_thumbnail_url($product_id, 'medium');
                            $fallback_image = 'http://lamkadeh.com/wp-content/uploads/2025/08/6ab22bedd099068b507027f9225221324b2b9b85-300x300.png';
                            ?>
                            <img src="<?php echo esc_url($product_image ?: $fallback_image); ?>" alt="<?php echo esc_attr(get_the_title($product_id)); ?>">
                        </div>
                        <div class="product-brands-list-left-bottom-item-content">
                            <div class="product-brands-list-left-bottom-item-content-header">
                                <a href="<?php echo esc_url(get_permalink($product_id)); ?>"><?php echo esc_html(get_the_title($product_id)); ?></a>
                                <div class="product-brands-list-left-bottom-item-content-header-category">
                                    <?php if ($product_category): ?>
                                        <a href="<?php echo esc_url(get_term_link($product_category)); ?>" class="product-brands-list-left-bottom-item-content-header-category-item">
                                            <span><?php echo esc_html($product_category->name); ?></span>
                                            <?php
                                            $category_image = get_term_meta($product_category->term_id, 'thumbnail_id', true);
                                            $category_image_url = $category_image ? wp_get_attachment_image_url($category_image, 'thumbnail') : 'http://lamkadeh.com/wp-content/uploads/2025/08/chair-1-150x150.png';
                                            ?>
                                            <img src="<?php echo esc_url($category_image_url); ?>" alt="" />
                                        </a>
                                    <?php endif; ?>
                                    <div class="product-brands-list-left-bottom-item-content-header-category-item">
                                        <span><?php echo get_comments_number($product_id); ?> نظر</span>
                                        <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_1_7131)">
                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M6.74174 3.98083C7.62671 2.17909 9.48027 0.9375 11.625 0.9375C14.628 0.9375 17.0625 3.37195 17.0625 6.375C17.0625 7.17907 16.8876 7.94382 16.5733 8.632C16.4912 8.81161 16.4753 8.98125 16.5117 9.11757L16.6073 9.4746C16.913 10.6175 15.8675 11.663 14.7246 11.3573L14.3676 11.2617C14.2661 11.2346 14.1462 11.2365 14.0174 11.2731C13.6349 14.5331 10.8628 17.0625 7.5 17.0625C6.48752 17.0625 5.52711 16.8328 4.66942 16.4222C4.49963 16.3409 4.33245 16.3244 4.19493 16.3612L3.2754 16.6073C2.13253 16.913 1.08695 15.8675 1.39275 14.7246L1.63878 13.8051C1.67558 13.6676 1.65908 13.5004 1.5778 13.3306C1.16718 12.4729 0.9375 11.5125 0.9375 10.5C0.9375 7.13209 3.47455 4.35673 6.74174 3.98083ZM8.05124 3.96033C11.2948 4.23009 13.8686 6.85883 14.052 10.1262C14.2489 10.1074 14.4536 10.1202 14.6584 10.175L15.0154 10.2705C15.322 10.3525 15.6025 10.072 15.5205 9.76538L15.425 9.40835C15.3071 8.96785 15.3839 8.52811 15.55 8.16458C15.7986 7.62016 15.9375 7.01456 15.9375 6.375C15.9375 3.99327 14.0067 2.0625 11.625 2.0625C10.1386 2.0625 8.8269 2.81463 8.05124 3.96033ZM7.5 5.0625C4.49695 5.0625 2.0625 7.49695 2.0625 10.5C2.0625 11.3408 2.25294 12.1355 2.5925 12.8448C2.76906 13.2136 2.84309 13.6566 2.72555 14.0959L2.47952 15.0154C2.39748 15.322 2.678 15.6025 2.98462 15.5205L3.90415 15.2744C4.34345 15.1569 4.78643 15.2309 5.15521 15.4075C5.86449 15.7471 6.65922 15.9375 7.5 15.9375C10.503 15.9375 12.9375 13.503 12.9375 10.5C12.9375 7.49695 10.503 5.0625 7.5 5.0625Z" fill="#020308" fill-opacity="0.64" />
                                                <path d="M5.625 10.5C5.625 10.9142 5.28921 11.25 4.875 11.25C4.46079 11.25 4.125 10.9142 4.125 10.5C4.125 10.0858 4.46079 9.75 4.875 9.75C5.28921 9.75 5.625 10.0858 5.625 10.5Z" fill="#020308" fill-opacity="0.64" />
                                                <path d="M8.25 10.5C8.25 10.9142 7.91421 11.25 7.5 11.25C7.08579 11.25 6.75 10.9142 6.75 10.5C6.75 10.0858 7.08579 9.75 7.5 9.75C7.91421 9.75 8.25 10.0858 8.25 10.5Z" fill="#020308" fill-opacity="0.64" />
                                                <path d="M10.875 10.5C10.875 10.9142 10.5392 11.25 10.125 11.25C9.71079 11.25 9.375 10.9142 9.375 10.5C9.375 10.0858 9.71079 9.75 10.125 9.75C10.5392 9.75 10.875 10.0858 10.875 10.5Z" fill="#020308" fill-opacity="0.64" />
                                            </g>
                                            <defs>
                                                <clipPath id="clip0_1_7131">
                                                    <rect width="18" height="18" fill="white" />
                                                </clipPath>
                                            </defs>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="underline-lamkadeh">
                                <div class="underline-lamkadeh-line"></div>
                                <div class="underline-lamkadeh-circle"></div>
                            </div>
                            <div class="product-brands-list-left-bottom-item-content-footer">
                                <div class="product-brands-list-left-bottom-item-content-footer-item">
                                    <?php if ($product_prices['is_on_sale'] && $product_prices['regular_price'] > 0 && $product_prices['price'] < $product_prices['regular_price']): ?>
                                        <div class="product-brands-list-left-bottom-item-content-footer-item-regular-price">
                                            <span><?php echo format_price_without_symbol($product_prices['regular_price']); ?></span>
                                        </div>
                                        <div class="product-brands-list-left-bottom-item-content-footer-item-line"></div>
                                        <div class="product-brands-list-left-bottom-item-content-footer-item-salesoff-price">
                                            <div class="product-brands-list-left-bottom-item-content-footer-item-salesoff-price-rectangle"></div>
                                            <span><?php echo format_price_without_symbol($product_prices['price']); ?></span>
                                            <div class="product-brands-list-left-bottom-item-content-footer-item-salesoff-price-symbol">تــــو مان</div>
                                        </div>
                                    <?php else: ?>
                                        <div class="product-brands-list-left-bottom-item-content-footer-item-salesoff-price">
                                            <span><?php echo format_price_without_symbol($product_prices['price']); ?></span>
                                            <div class="product-brands-list-left-bottom-item-content-footer-item-salesoff-price-symbol">تــــو مان</div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="product-brands-list-left-bottom-item-content-footer-item">
                                    <div class="product-brands-list-left-bottom-item-content-footer-item-icon">
                                        <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M4.21827 3.31808C2.97403 3.88683 2.0625 5.23961 2.0625 6.85276C2.0625 8.50081 2.73691 9.77111 3.70371 10.8598C4.50054 11.757 5.46513 12.5007 6.40584 13.2259C6.62928 13.3981 6.85136 13.5694 7.06953 13.7413C7.46406 14.0524 7.81599 14.3253 8.15521 14.5236C8.49461 14.7219 8.7678 14.8124 9 14.8124C9.2322 14.8124 9.50539 14.7219 9.84479 14.5236C10.184 14.3253 10.5359 14.0524 10.9305 13.7413C11.1486 13.5694 11.3707 13.3981 11.5942 13.2259C12.5349 12.5007 13.4995 11.757 14.2963 10.8598C15.2631 9.77111 15.9375 8.50081 15.9375 6.85276C15.9375 5.23961 15.026 3.88683 13.7817 3.31808C12.5729 2.76554 10.9488 2.91187 9.40527 4.51548C9.29923 4.62566 9.15291 4.68791 9 4.68791C8.84709 4.68791 8.70077 4.62566 8.59473 4.51548C7.05125 2.91187 5.42705 2.76554 4.21827 3.31808ZM9 3.34404C7.26596 1.79261 5.32422 1.57559 3.75057 2.2949C2.08853 3.05463 0.9375 4.81871 0.9375 6.85276C0.9375 8.85191 1.77037 10.377 2.86254 11.6068C3.73715 12.5916 4.80767 13.4159 5.75312 14.1439C5.96744 14.3089 6.17533 14.469 6.37306 14.6248C6.75724 14.9277 7.16966 15.2506 7.58762 15.4949C8.00539 15.739 8.4822 15.9374 9 15.9374C9.5178 15.9374 9.99461 15.739 10.4124 15.4949C10.8303 15.2506 11.2428 14.9277 11.6269 14.6248C11.8247 14.469 12.0326 14.3089 12.2469 14.1439C13.1923 13.4159 14.2628 12.5916 15.1375 11.6068C16.2296 10.377 17.0625 8.85191 17.0625 6.85276C17.0625 4.81871 15.9115 3.05463 14.2494 2.2949C12.6758 1.57559 10.734 1.79261 9 3.34404Z" fill="#1D2977" />
                                        </svg>
                                    </div>
                                    <a href="<?php echo esc_url(get_permalink($product_id)); ?>" class="product-brands-list-left-bottom-item-content-footer-item-icon">
                                        <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M9.00017 2.0625C8.06819 2.0625 7.31267 2.81802 7.31267 3.75V3.94086C7.62579 3.93749 7.96382 3.9375 8.3291 3.9375L9.67124 3.9375C10.0365 3.9375 10.3745 3.93749 10.6877 3.94086V3.75C10.6877 2.81802 9.93215 2.0625 9.00017 2.0625ZM11.8127 3.9802V3.75C11.8127 2.1967 10.5535 0.9375 9.00017 0.9375C7.44687 0.9375 6.18767 2.1967 6.18767 3.75V3.9802C6.08642 3.98759 5.98872 3.99626 5.8944 4.00642C5.23563 4.07742 4.68473 4.22616 4.19551 4.56148C4.02725 4.67681 3.8692 4.80637 3.72312 4.94875C3.29837 5.36271 3.04448 5.87374 2.84566 6.50579C2.65263 7.11944 2.49662 7.8995 2.30059 8.87969L2.28628 8.95123C2.0038 10.3636 1.78121 11.4765 1.71728 12.363C1.65195 13.2687 1.74324 14.0306 2.17226 14.691C2.31541 14.9113 2.48249 15.1151 2.67045 15.2987C3.2338 15.8488 3.96306 16.0878 4.86401 16.2014C5.74577 16.3125 6.88075 16.3125 8.32107 16.3125H9.67927C11.1196 16.3125 12.2546 16.3125 13.1363 16.2014C14.0373 16.0878 14.7665 15.8488 15.3299 15.2987C15.5179 15.1151 15.6849 14.9113 15.8281 14.691C16.2571 14.0306 16.3484 13.2687 16.2831 12.363C16.2191 11.4765 15.9965 10.3636 15.7141 8.95129L15.6998 8.87972C15.5037 7.89951 15.3477 7.11944 15.1547 6.50579C14.9559 5.87374 14.702 5.36271 14.2772 4.94875C14.1311 4.80637 13.9731 4.6768 13.8048 4.56148C13.3156 4.22616 12.7647 4.07742 12.1059 4.00642C12.0116 3.99626 11.9139 3.98759 11.8127 3.9802ZM6.01496 5.12494C5.45493 5.1853 5.10895 5.29929 4.83153 5.48943C4.71641 5.56834 4.60827 5.65699 4.50832 5.75441C4.26746 5.98914 4.08784 6.30605 3.91882 6.84337C3.74609 7.39246 3.60122 8.11294 3.39738 9.13216C3.10522 10.5929 2.89759 11.6365 2.83936 12.4439C2.78192 13.2403 2.87891 13.7137 3.11563 14.078C3.21357 14.2288 3.32789 14.3682 3.45649 14.4938C3.76732 14.7974 4.21247 14.9853 5.00471 15.0852C5.80788 15.1864 6.87185 15.1875 8.36157 15.1875H9.63877C11.1285 15.1875 12.1925 15.1864 12.9956 15.0852C13.7879 14.9853 14.233 14.7974 14.5439 14.4938C14.6725 14.3682 14.7868 14.2288 14.8847 14.078C15.1214 13.7137 15.2184 13.2403 15.161 12.4439C15.1027 11.6365 14.8951 10.5929 14.603 9.13216C14.3991 8.11294 14.2542 7.39246 14.0815 6.84337C13.9125 6.30605 13.7329 5.98914 13.492 5.75441C13.3921 5.65699 13.2839 5.56834 13.1688 5.48943C12.8914 5.29929 12.5454 5.1853 11.9854 5.12494C11.4131 5.06326 10.6782 5.0625 9.63877 5.0625H8.36157C7.32216 5.0625 6.58726 5.06326 6.01496 5.12494ZM6.69089 10.7197C6.9838 10.6161 7.30517 10.7696 7.40869 11.0625C7.64062 11.7187 8.26645 12.1875 9.00032 12.1875C9.73418 12.1875 10.36 11.7187 10.5919 11.0625C10.6955 10.7696 11.0168 10.6161 11.3097 10.7197C11.6026 10.8232 11.7562 11.1445 11.6526 11.4375C11.2668 12.5291 10.2258 13.3125 9.00032 13.3125C7.77486 13.3125 6.73383 12.5291 6.348 11.4375C6.24447 11.1445 6.39799 10.8232 6.69089 10.7197Z" fill="#1D2977" />
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <?php if ($product_prices['discount_percentage'] > 0): ?>
                            <div class="product-brands-list-left-bottom-item-badge">
                                <span>%<?php echo esc_html($product_prices['discount_percentage']); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
    <?php endforeach;
    } else {
        echo '<div class="no-products">هیچ محصولی برای این برند یافت نشد.</div>';
    }

    $output = ob_get_clean();
    wp_send_json_success($output);
}

function lamkadeh_product_pagination()
{
    global $wp_query, $wp_rewrite;

    $total   = isset($total) ? $total : wc_get_loop_prop('total_pages');
    $current = isset($current) ? $current : wc_get_loop_prop('current_page');

    if ($total <= 1) {
        return;
    }

    // ساخت base URL به صورت ساده و مطمئن
    $current_url = remove_query_arg('paged', get_pagenum_link(1, false));

    if ($wp_rewrite->using_permalinks()) {
        // برای permalink: آدرس پایه + page/عدد
        $base = trailingslashit($current_url) . 'page/%#%/';
    } else {
        // برای غیر permalink: آدرس پایه + ?paged=عدد
        $base = add_query_arg('paged', '%#%', $current_url);
    }

    // آیکون‌های فلش
    $prev_icon = '<svg width="32" height="20" viewBox="0 0 32 20" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M28.6668 10L29.1972 10.5303C29.4901 10.2374 29.4901 9.76256 29.1972 9.46967L28.6668 10ZM24.1972 4.46967C23.9043 4.17678 23.4294 4.17678 23.1365 4.46967C22.8436 4.76256 22.8436 5.23744 23.1365 5.53033L24.1972 4.46967ZM23.1365 14.4697C22.8436 14.7626 22.8436 15.2374 23.1365 15.5303C23.4294 15.8232 23.9043 15.8232 24.1972 15.5303L23.1365 14.4697ZM0 10V10.75H28.6668V10V9.25H0V10ZM28.6668 10L29.1972 9.46967L24.1972 4.46967L23.6668 5L23.1365 5.53033L28.1365 10.5303L28.6668 10ZM28.6668 10L28.1365 9.46967L23.1365 14.4697L23.6668 15L24.1972 15.5303L29.1972 10.5303L28.6668 10Z" fill="white" />
    </svg>';

    $next_icon = '<svg width="32" height="20" viewBox="0 0 32 20" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M3.33317 10L2.80284 10.5303C2.50995 10.2374 2.50995 9.76256 2.80284 9.46967L3.33317 10ZM7.80284 4.46967C8.09574 4.17678 8.57061 4.17678 8.8635 4.46967C9.15639 4.76256 9.15639 5.23744 8.8635 5.53033L7.80284 4.46967ZM8.8635 14.4697C9.15639 14.7626 9.15639 15.2374 8.8635 15.5303C8.57061 15.8232 8.09574 15.8232 7.80284 15.5303L8.8635 14.4697ZM32 10V10.75H3.33317V10V9.25H32V10ZM3.33317 10L2.80284 9.46967L7.80284 4.46967L8.33317 5L8.8635 5.53033L3.8635 10.5303L3.33317 10ZM3.33317 10L3.8635 9.46967L8.8635 14.4697L8.33317 15L7.80284 15.5303L2.80284 10.5303L3.33317 10Z" fill="white" />
    </svg>';

    // لینک قبلی
    $prev_link = '';
    if ($current > 1) {
        $prev_page = $current - 1;
        if ($prev_page == 1) {
            // برای صفحه اول، لینک بدون /page/ می‌سازیم
            $prev_url = $current_url;
        } else {
            // برای صفحات دیگر
            if ($wp_rewrite->using_permalinks()) {
                $prev_url = trailingslashit($current_url) . 'page/' . $prev_page . '/';
            } else {
                $prev_url = add_query_arg('paged', $prev_page, $current_url);
            }
        }
        $prev_link = '<div class="pagination-archive-arrow-prev" data-url="' . esc_url($prev_url) . '">' . $prev_icon . '</div>';
    } else {
        $prev_link = '<div class="pagination-archive-arrow-prev disabled">' . $prev_icon . '</div>';
    }

    // لینک بعدی
    $next_link = '';
    if ($current < $total) {
        $next_page = $current + 1;
        if ($wp_rewrite->using_permalinks()) {
            $next_url = trailingslashit($current_url) . 'page/' . $next_page . '/';
        } else {
            $next_url = add_query_arg('paged', $next_page, $current_url);
        }
        $next_link = '<div class="pagination-archive-arrow-next" data-url="' . esc_url($next_url) . '">' . $next_icon . '</div>';
    } else {
        $next_link = '<div class="pagination-archive-arrow-next disabled">' . $next_icon . '</div>';
    }

    // تولید آیتم‌های صفحه‌بندی
    $page_items = '';
    $display_pages = array();

    // منطق نمایش صفحات: حداکثر 5 صفحه نمایش داده شود
    if ($total <= 5) {
        // اگر کل صفحات کمتر از 5 باشد، همه نمایش داده شوند
        for ($i = 1; $i <= $total; $i++) {
            $display_pages[] = $i;
        }
    } else {
        // اگر صفحات بیشتر از 5 باشد
        if ($current <= 3) {
            // صفحات ابتدایی: 1, 2, 3, 4, ...
            $display_pages = [1, 2, 3, 4];
            if ($total > 4) $display_pages[] = 'dots';
            if ($total > 4) $display_pages[] = $total;
        } elseif ($current >= $total - 2) {
            // صفحات انتهایی: ..., n-3, n-2, n-1, n
            $display_pages = [1, 'dots'];
            for ($i = $total - 3; $i <= $total; $i++) {
                $display_pages[] = $i;
            }
        } else {
            // صفحات میانی: ..., current-1, current, current+1, ...
            $display_pages = [1, 'dots'];
            for ($i = $current - 1; $i <= $current + 1; $i++) {
                $display_pages[] = $i;
            }
            $display_pages[] = 'dots';
            $display_pages[] = $total;
        }
    }

    // تولید HTML برای صفحات
    foreach ($display_pages as $page) {
        if ($page === 'dots') {
            $page_items .= '<div class="pagination-archive-counter-item dots">...</div>';
        } else {
            $is_current = ($page == $current);
            $class = 'pagination-archive-counter-item';
            if ($is_current) {
                $class .= ' active';
            }

            // ساخت URL برای هر صفحه
            if ($page == 1) {
                // صفحه اول: بدون /page/
                $page_url = $current_url;
            } else {
                // صفحات دیگر: با /page/عدد/
                if ($wp_rewrite->using_permalinks()) {
                    $page_url = trailingslashit($current_url) . 'page/' . $page . '/';
                } else {
                    $page_url = add_query_arg('paged', $page, $current_url);
                }
            }

            // فرمت کردن عدد به صورت دو رقمی برای اعداد 1 تا 9
            $display_number = ($page < 10) ? sprintf('%02d', $page) : $page;

            $page_items .= '<div class="' . $class . '" data-url="' . esc_url($page_url) . '">' . $display_number . '</div>';
        }
    }
    ?>

    <section class="pagination-archive">
        <section class="pagination-archive-counter">
            <?php echo $page_items; ?>
        </section>
        <section class="pagination-archive-arrow">
            <?php echo $prev_link; ?>
            <?php echo $next_link; ?>
        </section>
    </section>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // مدیریت کلیک روی صفحات
            document.querySelectorAll('.pagination-archive-counter-item:not(.dots):not(.active)').forEach(item => {
                item.addEventListener('click', function() {
                    const url = this.getAttribute('data-url');
                    if (url) {
                        window.location.href = url;
                    }
                });
            });

            // مدیریت کلیک روی فلش قبلی
            document.querySelector('.pagination-archive-arrow-prev:not(.disabled)')?.addEventListener('click', function() {
                const url = this.getAttribute('data-url');
                if (url) {
                    window.location.href = url;
                }
            });

            // مدیریت کلیک روی فلش بعدی
            document.querySelector('.pagination-archive-arrow-next:not(.disabled)')?.addEventListener('click', function() {
                const url = this.getAttribute('data-url');
                if (url) {
                    window.location.href = url;
                }
            });
        });
    </script>
<?php
}
add_action('woocommerce_after_shop_loop', 'lamkadeh_product_pagination', 10);

function lamkadeh_blog_pagination($query = null)
{
    global $wp_query, $wp_rewrite;

    // اگر کوئری خاصی داده نشده، از کوئری اصلی استفاده کن
    if (!$query) {
        $query = $wp_query;
    }

    $total = $query->max_num_pages;
    $current = max(1, get_query_var('paged'));

    if ($total <= 1) {
        return;
    }

    // ساخت base URL
    $current_url = remove_query_arg('paged', get_pagenum_link(1, false));

    if ($wp_rewrite->using_permalinks()) {
        $base = trailingslashit($current_url) . 'page/%#%/';
    } else {
        $base = add_query_arg('paged', '%#%', $current_url);
    }

    // آیکون‌های فلش
    $prev_icon = '<svg width="32" height="20" viewBox="0 0 32 20" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M28.6668 10L29.1972 10.5303C29.4901 10.2374 29.4901 9.76256 29.1972 9.46967L28.6668 10ZM24.1972 4.46967C23.9043 4.17678 23.4294 4.17678 23.1365 4.46967C22.8436 4.76256 22.8436 5.23744 23.1365 5.53033L24.1972 4.46967ZM23.1365 14.4697C22.8436 14.7626 22.8436 15.2374 23.1365 15.5303C23.4294 15.8232 23.9043 15.8232 24.1972 15.5303L23.1365 14.4697ZM0 10V10.75H28.6668V10V9.25H0V10ZM28.6668 10L29.1972 9.46967L24.1972 4.46967L23.6668 5L23.1365 5.53033L28.1365 10.5303L28.6668 10ZM28.6668 10L28.1365 9.46967L23.1365 14.4697L23.6668 15L24.1972 15.5303L29.1972 10.5303L28.6668 10Z" fill="white" />
    </svg>';

    $next_icon = '<svg width="32" height="20" viewBox="0 0 32 20" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M3.33317 10L2.80284 10.5303C2.50995 10.2374 2.50995 9.76256 2.80284 9.46967L3.33317 10ZM7.80284 4.46967C8.09574 4.17678 8.57061 4.17678 8.8635 4.46967C9.15639 4.76256 9.15639 5.23744 8.8635 5.53033L7.80284 4.46967ZM8.8635 14.4697C9.15639 14.7626 9.15639 15.2374 8.8635 15.5303C8.57061 15.8232 8.09574 15.8232 7.80284 15.5303L8.8635 14.4697ZM32 10V10.75H3.33317V10V9.25H32V10ZM3.33317 10L2.80284 9.46967L7.80284 4.46967L8.33317 5L8.8635 5.53033L3.8635 10.5303L3.33317 10ZM3.33317 10L3.8635 9.46967L8.8635 14.4697L8.33317 15L7.80284 15.5303L2.80284 10.5303L3.33317 10Z" fill="white" />
    </svg>';

    // لینک قبلی
    $prev_link = '';
    if ($current > 1) {
        $prev_page = $current - 1;
        if ($prev_page == 1) {
            $prev_url = $current_url;
        } else {
            if ($wp_rewrite->using_permalinks()) {
                $prev_url = trailingslashit($current_url) . 'page/' . $prev_page . '/';
            } else {
                $prev_url = add_query_arg('paged', $prev_page, $current_url);
            }
        }
        $prev_link = '<div class="pagination-archive-arrow-prev" data-url="' . esc_url($prev_url) . '">' . $prev_icon . '</div>';
    } else {
        $prev_link = '<div class="pagination-archive-arrow-prev disabled">' . $prev_icon . '</div>';
    }

    // لینک بعدی
    $next_link = '';
    if ($current < $total) {
        $next_page = $current + 1;
        if ($wp_rewrite->using_permalinks()) {
            $next_url = trailingslashit($current_url) . 'page/' . $next_page . '/';
        } else {
            $next_url = add_query_arg('paged', $next_page, $current_url);
        }
        $next_link = '<div class="pagination-archive-arrow-next" data-url="' . esc_url($next_url) . '">' . $next_icon . '</div>';
    } else {
        $next_link = '<div class="pagination-archive-arrow-next disabled">' . $next_icon . '</div>';
    }

    // تولید آیتم‌های صفحه‌بندی
    $page_items = '';
    $display_pages = array();

    // منطق نمایش صفحات
    if ($total <= 5) {
        for ($i = 1; $i <= $total; $i++) {
            $display_pages[] = $i;
        }
    } else {
        if ($current <= 3) {
            $display_pages = [1, 2, 3, 4];
            if ($total > 4) $display_pages[] = 'dots';
            if ($total > 4) $display_pages[] = $total;
        } elseif ($current >= $total - 2) {
            $display_pages = [1, 'dots'];
            for ($i = $total - 3; $i <= $total; $i++) {
                $display_pages[] = $i;
            }
        } else {
            $display_pages = [1, 'dots'];
            for ($i = $current - 1; $i <= $current + 1; $i++) {
                $display_pages[] = $i;
            }
            $display_pages[] = 'dots';
            $display_pages[] = $total;
        }
    }

    // تولید HTML برای صفحات
    foreach ($display_pages as $page) {
        if ($page === 'dots') {
            $page_items .= '<div class="pagination-archive-counter-item dots">...</div>';
        } else {
            $is_current = ($page == $current);
            $class = 'pagination-archive-counter-item';
            if ($is_current) {
                $class .= ' active';
            }

            // ساخت URL برای هر صفحه
            if ($page == 1) {
                $page_url = $current_url;
            } else {
                if ($wp_rewrite->using_permalinks()) {
                    $page_url = trailingslashit($current_url) . 'page/' . $page . '/';
                } else {
                    $page_url = add_query_arg('paged', $page, $current_url);
                }
            }

            $page_items .= '<div class="' . $class . '" data-url="' . esc_url($page_url) . '">' . $page . '</div>';
        }
    }
?>

    <section class="pagination-archive">
        <section class="pagination-archive-counter">
            <?php echo $page_items; ?>
        </section>
        <section class="pagination-archive-arrow">
            <?php echo $prev_link; ?>
            <?php echo $next_link; ?>
        </section>
    </section>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // مدیریت کلیک روی صفحات
            document.querySelectorAll('.pagination-archive-counter-item:not(.dots):not(.active)').forEach(item => {
                item.addEventListener('click', function() {
                    const url = this.getAttribute('data-url');
                    if (url) {
                        window.location.href = url;
                    }
                });
            });

            // مدیریت کلیک روی فلش قبلی
            document.querySelector('.pagination-archive-arrow-prev:not(.disabled)')?.addEventListener('click', function() {
                const url = this.getAttribute('data-url');
                if (url) {
                    window.location.href = url;
                }
            });

            // مدیریت کلیک روی فلش بعدی
            document.querySelector('.pagination-archive-arrow-next:not(.disabled)')?.addEventListener('click', function() {
                const url = this.getAttribute('data-url');
                if (url) {
                    window.location.href = url;
                }
            });
        });
    </script>
<?php
}
