<?php

function breadcrumb()
{
    if (is_front_page()) {
        return;
    }

    echo '<div class="title-breadcrumb-special dt-sl mb-3">';
    echo '<div class="breadcrumb dt-sl">';
    echo '<nav>';

    echo '<a href="' . home_url() . '">
    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.3763 15C9.3763 15.3452 9.65612 15.625 10.0013 15.625C10.3465 15.625 10.6263 15.3452 10.6263 15V12.5C10.6263 12.1548 10.3465 11.875 10.0013 11.875C9.65612 11.875 9.3763 12.1548 9.3763 12.5V15Z" fill="#020308" fill-opacity="0.64"/><path fill-rule="evenodd" clip-rule="evenodd" d="M10.0013 1.04167C9.39709 1.04167 8.84581 1.2076 8.24237 1.48926C7.65823 1.76191 6.98274 2.1643 6.13616 2.66861L4.92315 3.3912C3.99056 3.94673 3.24743 4.3894 2.68476 4.81271C2.10392 5.24969 1.66796 5.69967 1.38386 6.29227C1.09962 6.88516 1.02259 7.50567 1.0473 8.22987C1.07122 8.93086 1.19384 9.78305 1.34761 10.8516L1.59123 12.5447C1.78906 13.9197 1.94604 15.0107 2.18057 15.8601C2.42233 16.7358 2.76535 17.4308 3.38434 17.9638C4.00283 18.4963 4.74284 18.7345 5.64826 18.8481C6.52759 18.9584 7.63697 18.9583 9.03655 18.9583H10.966C12.3656 18.9583 13.475 18.9584 14.3544 18.8481C15.2598 18.7345 15.9998 18.4963 16.6183 17.9638C17.2373 17.4308 17.5803 16.7358 17.822 15.8601C18.0566 15.0107 18.2135 13.9197 18.4114 12.5448L18.655 10.8515C18.8088 9.78304 18.9314 8.93085 18.9553 8.22987C18.98 7.50567 18.903 6.88516 18.6187 6.29227C18.3346 5.69967 17.8987 5.24969 17.3178 4.81271C16.7552 4.3894 16.012 3.94673 15.0795 3.3912L13.8664 2.66861C13.0199 2.1643 12.3444 1.76191 11.7602 1.48926C11.1568 1.2076 10.6055 1.04167 10.0013 1.04167ZM6.74762 3.75935C7.62887 3.23439 8.25066 2.86485 8.77106 2.62195C9.27864 2.38503 9.64359 2.29167 10.0013 2.29167C10.359 2.29167 10.724 2.38503 11.2315 2.62195C11.7519 2.86485 12.3737 3.23439 13.255 3.75935L14.409 4.4468C15.3793 5.02478 16.064 5.43362 16.5664 5.81159C17.0567 6.18052 17.3253 6.48579 17.4916 6.83265C17.6577 7.17921 17.7268 7.57781 17.706 8.18725C17.6847 8.81212 17.5727 9.59693 17.4126 10.7092L17.1803 12.3237C16.9749 13.7513 16.828 14.7635 16.6171 15.5275C16.411 16.2741 16.1629 16.7064 15.8026 17.0165C15.4419 17.3272 14.9743 17.5105 14.1988 17.6078C13.4063 17.7072 12.3753 17.7083 10.923 17.7083H9.07958C7.62734 17.7083 6.59635 17.7072 5.8038 17.6078C5.02835 17.5105 4.56071 17.3272 4.19998 17.0165C3.83975 16.7064 3.59162 16.2741 3.38548 15.5275C3.17456 14.7635 3.02772 13.7513 2.8223 12.3237L2.58999 10.7092C2.42995 9.59692 2.31789 8.81211 2.29657 8.18724C2.27577 7.57781 2.34488 7.17921 2.51102 6.83265C2.67731 6.48579 2.94586 6.18052 3.43625 5.81159C3.93865 5.43362 4.62333 5.02478 5.59359 4.4468L6.74762 3.75935Z" fill="#020308" fill-opacity="0.64"/></svg>
    ' . __("خانه", "lamkadeh") . '</a> 
    <i class="fa-solid fa-angle-left"></i>';

    if (function_exists('dokan_is_seller_dashboard') && dokan_is_seller_dashboard()) {

        echo '<a href="' . dokan_get_navigation_url() . '">داشبورد فروشنده</a>  ';

        $nav = dokan_get_dashboard_nav();
        $current_title = $nav->get_current_url_title();
        if ($current_title) {
            echo '<span>' . esc_html($current_title) . '</span>';
        }
    } elseif (is_product()) {

        echo '<a href="' . get_permalink(wc_get_page_id('shop')) . '"><svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M10.0003 1.04167C9.49638 1.04167 9.03237 1.16691 8.52431 1.37702C8.03372 1.57991 7.46393 1.87893 6.75441 2.25128L5.03148 3.15543C4.16067 3.6124 3.46379 3.9781 2.92572 4.33743C2.36827 4.7097 1.93893 5.10168 1.62626 5.63265C1.31464 6.16185 1.17446 6.73487 1.10723 7.41727C1.04198 8.07965 1.04199 8.89429 1.04199 9.91881V10.0812C1.04199 11.1057 1.04198 11.9204 1.10723 12.5827C1.17446 13.2651 1.31464 13.8382 1.62626 14.3674C1.93893 14.8983 2.36827 15.2903 2.92572 15.6626C3.46379 16.0219 4.16066 16.3876 5.03147 16.8446L6.75433 17.7487C7.46389 18.1211 8.0337 18.4201 8.5243 18.623C9.03237 18.8331 9.49638 18.9583 10.0003 18.9583C10.5043 18.9583 10.9683 18.8331 11.4763 18.623C11.9669 18.4201 12.5367 18.1211 13.2462 17.7487L14.9691 16.8446C15.84 16.3876 16.5369 16.0219 17.0749 15.6626C17.6324 15.2903 18.0617 14.8983 18.3744 14.3674C18.686 13.8382 18.8262 13.2651 18.8934 12.5827C18.9587 11.9204 18.9587 11.1057 18.9587 10.0812V9.91879C18.9587 8.89429 18.9587 8.07965 18.8934 7.41727C18.8262 6.73487 18.686 6.16185 18.3744 5.63265C18.0617 5.10168 17.6324 4.7097 17.0749 4.33743C16.5369 3.9781 15.84 3.6124 14.9692 3.15542L13.2463 2.25129C12.5367 1.87894 11.9669 1.57991 11.4763 1.37702C10.9683 1.16691 10.5043 1.04167 10.0003 1.04167ZM7.30933 3.37173C8.05076 2.98265 8.57033 2.71067 9.00201 2.53214C9.42219 2.35837 9.71737 2.29167 10.0003 2.29167C10.2833 2.29167 10.5785 2.35837 10.9986 2.53214C11.4303 2.71067 11.9499 2.98265 12.6913 3.37174L14.358 4.24636C15.2661 4.7229 15.904 5.05861 16.3807 5.37694C16.6159 5.53399 16.8007 5.67982 16.9499 5.82645L14.1743 7.21424L7.09111 3.48625L7.30933 3.37173ZM5.78754 4.17033L5.64266 4.24636C4.73458 4.7229 4.0966 5.05861 3.61992 5.37694C3.38475 5.53399 3.19996 5.67982 3.05077 5.82646L10.0003 9.30123L12.798 7.90241L5.95923 4.30308C5.89279 4.26811 5.83525 4.22287 5.78754 4.17033ZM2.44839 6.92281C2.40631 7.10105 2.3745 7.30344 2.35121 7.53982C2.29269 8.13383 2.29199 8.88701 2.29199 9.95126V10.0487C2.29199 11.113 2.29269 11.8662 2.35121 12.4602C2.40844 13.0412 2.51717 13.4169 2.70339 13.7331C2.88855 14.0475 3.15638 14.3135 3.61992 14.6231C4.0966 14.9414 4.73458 15.2771 5.64266 15.7536L7.30933 16.6283C8.05076 17.0174 8.57033 17.2893 9.00201 17.4679C9.13832 17.5242 9.26147 17.5693 9.37532 17.6046V10.3863L2.44839 6.92281ZM10.6253 17.6046C10.7392 17.5693 10.8623 17.5242 10.9986 17.4679C11.4303 17.2893 11.9499 17.0174 12.6913 16.6283L14.358 15.7536C15.2661 15.2771 15.904 14.9414 16.3807 14.6231C16.8443 14.3135 17.1121 14.0475 17.2973 13.7331C17.4835 13.4169 17.5922 13.0412 17.6494 12.4602C17.708 11.8662 17.7087 11.113 17.7087 10.0487V9.95126C17.7087 8.88701 17.708 8.13383 17.6494 7.53982C17.6262 7.30344 17.5943 7.10104 17.5523 6.92281L14.792 8.30294V10.8333C14.792 11.1785 14.5122 11.4583 14.167 11.4583C13.8218 11.4583 13.542 11.1785 13.542 10.8333V8.92794L10.6253 10.3863V17.6046Z" fill="#020308" fill-opacity="0.64"/>
</svg>
 دسته بندی محصولات</a> <i class="fa-solid fa-angle-left"></i>';

        $terms = get_the_terms(get_the_ID(), 'product_cat');
        if ($terms && !is_wp_error($terms)) {

            $main_cat = $terms[0];

            $ancestors = get_ancestors($main_cat->term_id, 'product_cat');
            $ancestors = array_reverse($ancestors);
            foreach ($ancestors as $ancestor_id) {
                $ancestor = get_term($ancestor_id, 'product_cat');
                echo '<a href="' . get_term_link($ancestor) . '">' . $ancestor->name . '</a> <i class="fa-solid fa-angle-left"></i>';
            }

            $thumbnail_id = get_term_meta($main_cat->term_id, 'thumbnail_id', true);
            $image_url = wp_get_attachment_url($thumbnail_id);

            echo '<a href="' . get_term_link($main_cat) . '">';

            echo $main_cat->name . '</a> <i class="fa-solid fa-angle-left"></i>';
        }

        echo '<span>' . get_the_title() . '</span>';
    } elseif (is_single()) {

        $categories = get_the_category();
        if (!empty($categories)) {
            $main_category = $categories[0];
            echo '<a href="' . get_category_link($main_category->term_id) . '">' . $main_category->name . '</a>  <i class="fa-solid fa-angle-left"></i>';
        }
        echo '<span>' . get_the_title() . '</span>';
    } elseif (is_page_template('archive.php')) {
        echo '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M9.11965 1.0415H10.8803C12.4118 1.04149 13.6248 1.04148 14.5742 1.16912C15.5512 1.30047 16.342 1.57724 16.9656 2.20087C17.5893 2.82451 17.866 3.6153 17.9974 4.59232C18.125 5.54166 18.125 6.75469 18.125 8.28616V11.7135C18.125 13.245 18.125 14.458 17.9974 15.4074C17.866 16.3844 17.5893 17.1752 16.9656 17.7988C16.342 18.4224 15.5512 18.6992 14.5742 18.8306C13.6248 18.9582 12.4118 18.9582 10.8803 18.9582H9.11966C7.58819 18.9582 6.37516 18.9582 5.42581 18.8306C4.4488 18.6992 3.65801 18.4224 3.03437 17.7988C2.41073 17.1752 2.13397 16.3844 2.00261 15.4074C1.87498 14.458 1.87499 13.245 1.875 11.7135V8.28616C1.87499 6.75469 1.87498 5.54166 2.00261 4.59232C2.13397 3.6153 2.41073 2.82451 3.03437 2.20087C3.65801 1.57724 4.4488 1.30047 5.42581 1.16912C6.37516 1.04148 7.58819 1.04149 9.11965 1.0415ZM5.59237 2.40797C4.75397 2.52069 4.27093 2.73208 3.91825 3.08476C3.56558 3.43743 3.35419 3.92047 3.24147 4.75888C3.12633 5.61526 3.125 6.74415 3.125 8.33317V11.6665C3.125 13.2555 3.12633 14.3844 3.24147 15.2408C3.35419 16.0792 3.56558 16.5622 3.91825 16.9149C4.27093 17.2676 4.75397 17.479 5.59237 17.5917C6.44876 17.7068 7.57765 17.7082 9.16667 17.7082H10.8333C12.4224 17.7082 13.5512 17.7068 14.4076 17.5917C15.246 17.479 15.7291 17.2676 16.0817 16.9149C16.4344 16.5622 16.6458 16.0792 16.7585 15.2408C16.8737 14.3844 16.875 13.2555 16.875 11.6665V8.33317C16.875 6.74415 16.8737 5.61527 16.7585 4.75888C16.6458 3.92047 16.4344 3.43743 16.0817 3.08476C15.7291 2.73208 15.246 2.52069 14.4076 2.40797C13.5512 2.29283 12.4224 2.2915 10.8333 2.2915H9.16667C7.57765 2.2915 6.44876 2.29283 5.59237 2.40797ZM6.04167 6.6665C6.04167 6.32133 6.32149 6.0415 6.66667 6.0415H13.3333C13.6785 6.0415 13.9583 6.32133 13.9583 6.6665C13.9583 7.01168 13.6785 7.2915 13.3333 7.2915H6.66667C6.32149 7.2915 6.04167 7.01168 6.04167 6.6665ZM6.04167 9.99984C6.04167 9.65466 6.32149 9.37484 6.66667 9.37484H13.3333C13.6785 9.37484 13.9583 9.65466 13.9583 9.99984C13.9583 10.345 13.6785 10.6248 13.3333 10.6248H6.66667C6.32149 10.6248 6.04167 10.345 6.04167 9.99984ZM6.04167 13.3332C6.04167 12.988 6.32149 12.7082 6.66667 12.7082H10.8333C11.1785 12.7082 11.4583 12.988 11.4583 13.3332C11.4583 13.6783 11.1785 13.9582 10.8333 13.9582H6.66667C6.32149 13.9582 6.04167 13.6783 6.04167 13.3332Z" fill="#1D2977"/>
</svg>
';
        echo '<span>' . get_the_title() . '</span>';
    } elseif (function_exists('is_account_page') && is_account_page()) {
        echo '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M10.0008 1.04167C7.81464 1.04167 6.04243 2.81388 6.04243 5.00001C6.04243 7.18613 7.81464 8.95834 10.0008 8.95834C12.1869 8.95834 13.9591 7.18613 13.9591 5.00001C13.9591 2.81388 12.1869 1.04167 10.0008 1.04167ZM7.29243 5.00001C7.29243 3.50423 8.50499 2.29167 10.0008 2.29167C11.4965 2.29167 12.7091 3.50423 12.7091 5.00001C12.7091 6.49578 11.4965 7.70834 10.0008 7.70834C8.50499 7.70834 7.29243 6.49578 7.29243 5.00001Z" fill="#1D2977"/><path fill-rule="evenodd" clip-rule="evenodd" d="M10.0008 10.2083C8.0728 10.2083 6.29653 10.6466 4.9803 11.387C3.68367 12.1163 2.7091 13.2217 2.7091 14.5833L2.70904 14.6683C2.7081 15.6365 2.70692 16.8517 3.77277 17.7196C4.29733 18.1468 5.03116 18.4505 6.0226 18.6512C7.01681 18.8525 8.31262 18.9583 10.0008 18.9583C11.6889 18.9583 12.9847 18.8525 13.9789 18.6512C14.9704 18.4505 15.7042 18.1468 16.2288 17.7196C17.2946 16.8517 17.2934 15.6365 17.2925 14.6683L17.2924 14.5833C17.2924 13.2217 16.3179 12.1163 15.0212 11.387C13.705 10.6466 11.9287 10.2083 10.0008 10.2083ZM3.9591 14.5833C3.9591 13.8739 4.47691 13.1043 5.59313 12.4764C6.68976 11.8596 8.24682 11.4583 10.0008 11.4583C11.7547 11.4583 13.3118 11.8596 14.4084 12.4764C15.5246 13.1043 16.0424 13.8739 16.0424 14.5833C16.0424 15.6732 16.0088 16.2867 15.4394 16.7504C15.1307 17.0018 14.6145 17.2472 13.7309 17.4261C12.8501 17.6044 11.646 17.7083 10.0008 17.7083C8.35558 17.7083 7.15138 17.6044 6.27059 17.4261C5.38703 17.2472 4.87086 17.0018 4.56209 16.7504C3.99269 16.2867 3.9591 15.6732 3.9591 14.5833Z" fill="#1D2977"/></svg>';
        echo '<span>' . get_the_title() . '</span>';
    } elseif (is_cart()) {
        echo '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M9.99997 2.29167C8.96444 2.29167 8.12497 3.13114 8.12497 4.16667V4.37873C8.47289 4.375 8.84847 4.375 9.25434 4.37501H10.7456C11.1515 4.375 11.5271 4.375 11.875 4.37873V4.16667C11.875 3.13114 11.0355 2.29167 9.99997 2.29167ZM13.125 4.42245V4.16667C13.125 2.44078 11.7259 1.04167 9.99997 1.04167C8.27408 1.04167 6.87497 2.44078 6.87497 4.16667V4.42245C6.76247 4.43066 6.65391 4.44029 6.54912 4.45158C5.81715 4.53048 5.20504 4.69574 4.66146 5.06831C4.4745 5.19646 4.2989 5.34042 4.13658 5.49861C3.66464 5.95857 3.38253 6.52639 3.16163 7.22866C2.94715 7.91049 2.77381 8.77723 2.556 9.86633L2.5401 9.94582C2.22623 11.5151 1.9789 12.7517 1.90787 13.7366C1.83529 14.743 1.93671 15.5896 2.41341 16.3233C2.57246 16.5681 2.7581 16.7945 2.96695 16.9985C3.59289 17.6098 4.40319 17.8753 5.40423 18.0015C6.38397 18.125 7.64506 18.125 9.24542 18.125H10.7545C12.3549 18.125 13.616 18.125 14.5957 18.0015C15.5968 17.8753 16.4071 17.6098 17.033 16.9985C17.2418 16.7945 17.4275 16.5681 17.5865 16.3233C18.0632 15.5896 18.1647 14.743 18.0921 13.7366C18.021 12.7517 17.7737 11.5151 17.4599 9.94589L17.444 9.86636C17.2261 8.77724 17.0528 7.9105 16.8383 7.22866C16.6174 6.52639 16.3353 5.95857 15.8634 5.49861C15.701 5.34042 15.5254 5.19646 15.3385 5.06831C14.7949 4.69574 14.1828 4.53048 13.4508 4.45158C13.346 4.44029 13.2375 4.43066 13.125 4.42245ZM6.68307 5.69439C6.06081 5.76145 5.67639 5.88811 5.36815 6.09937C5.24023 6.18705 5.12008 6.28555 5.00902 6.39379C4.74141 6.65461 4.54182 7.00673 4.35402 7.60375C4.16211 8.21385 4.00114 9.01438 3.77465 10.1469C3.45003 11.7699 3.21933 12.9294 3.15463 13.8266C3.0908 14.7115 3.19857 15.2374 3.46159 15.6423C3.57042 15.8097 3.69743 15.9647 3.84033 16.1042C4.1857 16.4415 4.6803 16.6504 5.56057 16.7613C6.45298 16.8738 7.63517 16.875 9.29041 16.875H10.7095C12.3648 16.875 13.547 16.8738 14.4394 16.7613C15.3196 16.6504 15.8142 16.4415 16.1596 16.1042C16.3025 15.9647 16.4295 15.8097 16.5384 15.6423C16.8014 15.2374 16.9091 14.7115 16.8453 13.8266C16.7806 12.9294 16.5499 11.7699 16.2253 10.1469C15.9988 9.01438 15.8378 8.21385 15.6459 7.60375C15.4581 7.00673 15.2585 6.65461 14.9909 6.39379C14.8799 6.28555 14.7597 6.18705 14.6318 6.09937C14.3236 5.88811 13.9391 5.76145 13.3169 5.69439C12.681 5.62585 11.8644 5.62501 10.7095 5.62501L9.29041 5.62501C8.13551 5.62501 7.31896 5.62585 6.68307 5.69439ZM7.43411 11.9107C7.75956 11.7957 8.11663 11.9663 8.23166 12.2917C8.48936 13.0208 9.18472 13.5417 10.0001 13.5417C10.8155 13.5417 11.5109 13.0208 11.7686 12.2917C11.8836 11.9663 12.2407 11.7957 12.5662 11.9107C12.8916 12.0258 13.0622 12.3828 12.9472 12.7083C12.5185 13.9212 11.3618 14.7917 10.0001 14.7917C8.63851 14.7917 7.48181 13.9212 7.05311 12.7083C6.93808 12.3828 7.10866 12.0258 7.43411 11.9107Z" fill="#1D2977"/></svg>';
        echo '<span>' . get_the_title() . '</span>';
    } elseif (is_checkout()) {
        echo '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M9.99997 2.29167C8.96444 2.29167 8.12497 3.13114 8.12497 4.16667V4.37873C8.47289 4.375 8.84847 4.375 9.25434 4.37501H10.7456C11.1515 4.375 11.5271 4.375 11.875 4.37873V4.16667C11.875 3.13114 11.0355 2.29167 9.99997 2.29167ZM13.125 4.42245V4.16667C13.125 2.44078 11.7259 1.04167 9.99997 1.04167C8.27408 1.04167 6.87497 2.44078 6.87497 4.16667V4.42245C6.76247 4.43066 6.65391 4.44029 6.54912 4.45158C5.81715 4.53048 5.20504 4.69574 4.66146 5.06831C4.4745 5.19646 4.2989 5.34042 4.13658 5.49861C3.66464 5.95857 3.38253 6.52639 3.16163 7.22866C2.94715 7.91049 2.77381 8.77723 2.556 9.86633L2.5401 9.94582C2.22623 11.5151 1.9789 12.7517 1.90787 13.7366C1.83529 14.743 1.93671 15.5896 2.41341 16.3233C2.57246 16.5681 2.7581 16.7945 2.96695 16.9985C3.59289 17.6098 4.40319 17.8753 5.40423 18.0015C6.38397 18.125 7.64506 18.125 9.24542 18.125H10.7545C12.3549 18.125 13.616 18.125 14.5957 18.0015C15.5968 17.8753 16.4071 17.6098 17.033 16.9985C17.2418 16.7945 17.4275 16.5681 17.5865 16.3233C18.0632 15.5896 18.1647 14.743 18.0921 13.7366C18.021 12.7517 17.7737 11.5151 17.4599 9.94589L17.444 9.86636C17.2261 8.77724 17.0528 7.9105 16.8383 7.22866C16.6174 6.52639 16.3353 5.95857 15.8634 5.49861C15.701 5.34042 15.5254 5.19646 15.3385 5.06831C14.7949 4.69574 14.1828 4.53048 13.4508 4.45158C13.346 4.44029 13.2375 4.43066 13.125 4.42245ZM6.68307 5.69439C6.06081 5.76145 5.67639 5.88811 5.36815 6.09937C5.24023 6.18705 5.12008 6.28555 5.00902 6.39379C4.74141 6.65461 4.54182 7.00673 4.35402 7.60375C4.16211 8.21385 4.00114 9.01438 3.77465 10.1469C3.45003 11.7699 3.21933 12.9294 3.15463 13.8266C3.0908 14.7115 3.19857 15.2374 3.46159 15.6423C3.57042 15.8097 3.69743 15.9647 3.84033 16.1042C4.1857 16.4415 4.6803 16.6504 5.56057 16.7613C6.45298 16.8738 7.63517 16.875 9.29041 16.875H10.7095C12.3648 16.875 13.547 16.8738 14.4394 16.7613C15.3196 16.6504 15.8142 16.4415 16.1596 16.1042C16.3025 15.9647 16.4295 15.8097 16.5384 15.6423C16.8014 15.2374 16.9091 14.7115 16.8453 13.8266C16.7806 12.9294 16.5499 11.7699 16.2253 10.1469C15.9988 9.01438 15.8378 8.21385 15.6459 7.60375C15.4581 7.00673 15.2585 6.65461 14.9909 6.39379C14.8799 6.28555 14.7597 6.18705 14.6318 6.09937C14.3236 5.88811 13.9391 5.76145 13.3169 5.69439C12.681 5.62585 11.8644 5.62501 10.7095 5.62501L9.29041 5.62501C8.13551 5.62501 7.31896 5.62585 6.68307 5.69439ZM7.43411 11.9107C7.75956 11.7957 8.11663 11.9663 8.23166 12.2917C8.48936 13.0208 9.18472 13.5417 10.0001 13.5417C10.8155 13.5417 11.5109 13.0208 11.7686 12.2917C11.8836 11.9663 12.2407 11.7957 12.5662 11.9107C12.8916 12.0258 13.0622 12.3828 12.9472 12.7083C12.5185 13.9212 11.3618 14.7917 10.0001 14.7917C8.63851 14.7917 7.48181 13.9212 7.05311 12.7083C6.93808 12.3828 7.10866 12.0258 7.43411 11.9107Z" fill="#020308"/></svg>';
        echo '<span>' . __("سبد خرید", "lamkadeh") . '</span>';
        echo '<i class="fa-solid fa-angle-left"></i>';
        echo '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M9.9992 2.29167C8.96367 2.29167 8.1242 3.13114 8.1242 4.16667V4.38324C8.58843 4.37499 9.09781 4.375 9.65682 4.375H10.3416C10.9006 4.375 11.41 4.37499 11.8742 4.38324V4.16667C11.8742 3.13114 11.0347 2.29167 9.9992 2.29167ZM13.1242 4.43994V4.16667C13.1242 2.44078 11.7251 1.04167 9.9992 1.04167C8.27331 1.04167 6.8742 2.44078 6.8742 4.16667V4.43994C6.75526 4.45018 6.64033 4.46204 6.52926 4.47576C5.68762 4.57975 4.99377 4.7982 4.40436 5.28736C3.81495 5.77653 3.47237 6.41824 3.21506 7.2263C2.96569 8.00941 2.77693 9.01617 2.53965 10.2817L2.52242 10.3737C2.18759 12.1593 1.92372 13.5666 1.87529 14.676C1.82566 15.8132 1.99484 16.755 2.63632 17.5279C3.2778 18.3009 4.17231 18.6407 5.29914 18.8015C6.39849 18.9584 7.83025 18.9584 9.64702 18.9583H10.3513C12.1681 18.9584 13.5999 18.9584 14.6993 18.8015C15.8261 18.6407 16.7206 18.3009 17.3621 17.5279C18.0036 16.755 18.1727 15.8132 18.1231 14.676C18.0747 13.5666 17.8108 12.1593 17.476 10.3737L17.4588 10.2818C17.2215 9.01619 17.0327 8.00941 16.7833 7.2263C16.526 6.41824 16.1835 5.77653 15.594 5.28736C15.0046 4.7982 14.3108 4.57975 13.4691 4.47576C13.3581 4.46204 13.2431 4.45018 13.1242 4.43994ZM6.68254 5.71633C5.96959 5.80441 5.53899 5.97012 5.20265 6.24925C4.86631 6.52839 4.6241 6.92107 4.40613 7.60558C4.18291 8.30657 4.00729 9.2372 3.76052 10.5533C3.41409 12.4009 3.16819 13.7206 3.12411 14.7305C3.08078 15.7232 3.24 16.298 3.5982 16.7296C3.95641 17.1613 4.49203 17.4237 5.47571 17.564C6.47647 17.7068 7.81886 17.7083 9.69871 17.7083H10.2997C12.1795 17.7083 13.5219 17.7068 14.5227 17.564C15.5064 17.4237 16.042 17.1613 16.4002 16.7296C16.7584 16.298 16.9176 15.7232 16.8743 14.7305C16.8302 13.7206 16.5843 12.4009 16.2379 10.5533C15.9911 9.2372 15.8155 8.30657 15.5923 7.60558C15.3743 6.92107 15.1321 6.52839 14.7958 6.24925C14.4594 5.97012 14.0288 5.80441 13.3159 5.71633C12.5857 5.62612 11.6387 5.625 10.2997 5.625H9.69871C8.35972 5.625 7.41266 5.62612 6.68254 5.71633ZM12.0811 9.94954C12.3391 10.1789 12.3623 10.5739 12.133 10.8319L9.91078 13.3319C9.80021 13.4563 9.64459 13.5314 9.47842 13.5407C9.31225 13.55 9.14925 13.4926 9.02554 13.3812L7.91443 12.3812C7.65786 12.1503 7.63707 11.7551 7.86798 11.4986C8.09889 11.242 8.49407 11.2212 8.75064 11.4521L9.39431 12.0314L11.1987 10.0014C11.4281 9.74345 11.8231 9.72022 12.0811 9.94954Z" fill="#1D2977"/></svg>';
        echo '<span>' . get_the_title() . '</span>';
    } elseif (is_search()) {
        echo '<span>نتایج جستجو برای: ' . get_search_query() . '</span>';
    } elseif (is_product_category()) {
        $term = get_queried_object();

        $thumbnail_id = get_term_meta($term->term_id, 'thumbnail_id', true);
        $image_url = wp_get_attachment_url($thumbnail_id);
        echo '<a href="' . get_permalink(wc_get_page_id('shop')) . '">';
        echo '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M10.0003 1.04167C9.49638 1.04167 9.03237 1.16691 8.52431 1.37702C8.03372 1.57991 7.46393 1.87893 6.75441 2.25128L5.03148 3.15543C4.16067 3.6124 3.46379 3.9781 2.92572 4.33743C2.36827 4.7097 1.93893 5.10168 1.62626 5.63265C1.31464 6.16185 1.17446 6.73487 1.10723 7.41727C1.04198 8.07965 1.04199 8.89429 1.04199 9.91881V10.0812C1.04199 11.1057 1.04198 11.9204 1.10723 12.5827C1.17446 13.2651 1.31464 13.8382 1.62626 14.3674C1.93893 14.8983 2.36827 15.2903 2.92572 15.6626C3.46379 16.0219 4.16066 16.3876 5.03147 16.8446L6.75433 17.7487C7.46389 18.1211 8.0337 18.4201 8.5243 18.623C9.03237 18.8331 9.49638 18.9583 10.0003 18.9583C10.5043 18.9583 10.9683 18.8331 11.4763 18.623C11.9669 18.4201 12.5367 18.1211 13.2462 17.7487L14.9691 16.8446C15.84 16.3876 16.5369 16.0219 17.0749 15.6626C17.6324 15.2903 18.0617 14.8983 18.3744 14.3674C18.686 13.8382 18.8262 13.2651 18.8934 12.5827C18.9587 11.9204 18.9587 11.1057 18.9587 10.0812V9.91879C18.9587 8.89429 18.9587 8.07965 18.8934 7.41727C18.8262 6.73487 18.686 6.16185 18.3744 5.63265C18.0617 5.10168 17.6324 4.7097 17.0749 4.33743C16.5369 3.9781 15.84 3.6124 14.9692 3.15542L13.2463 2.25129C12.5367 1.87894 11.9669 1.57991 11.4763 1.37702C10.9683 1.16691 10.5043 1.04167 10.0003 1.04167ZM7.30933 3.37173C8.05076 2.98265 8.57033 2.71067 9.00201 2.53214C9.42219 2.35837 9.71737 2.29167 10.0003 2.29167C10.2833 2.29167 10.5785 2.35837 10.9986 2.53214C11.4303 2.71067 11.9499 2.98265 12.6913 3.37174L14.358 4.24636C15.2661 4.7229 15.904 5.05861 16.3807 5.37694C16.6159 5.53399 16.8007 5.67982 16.9499 5.82645L14.1743 7.21424L7.09111 3.48625L7.30933 3.37173ZM5.78754 4.17033L5.64266 4.24636C4.73458 4.7229 4.0966 5.05861 3.61992 5.37694C3.38475 5.53399 3.19996 5.67982 3.05077 5.82646L10.0003 9.30123L12.798 7.90241L5.95923 4.30308C5.89279 4.26811 5.83525 4.22287 5.78754 4.17033ZM2.44839 6.92281C2.40631 7.10105 2.3745 7.30344 2.35121 7.53982C2.29269 8.13383 2.29199 8.88701 2.29199 9.95126V10.0487C2.29199 11.113 2.29269 11.8662 2.35121 12.4602C2.40844 13.0412 2.51717 13.4169 2.70339 13.7331C2.88855 14.0475 3.15638 14.3135 3.61992 14.6231C4.0966 14.9414 4.73458 15.2771 5.64266 15.7536L7.30933 16.6283C8.05076 17.0174 8.57033 17.2893 9.00201 17.4679C9.13832 17.5242 9.26147 17.5693 9.37532 17.6046V10.3863L2.44839 6.92281ZM10.6253 17.6046C10.7392 17.5693 10.8623 17.5242 10.9986 17.4679C11.4303 17.2893 11.9499 17.0174 12.6913 16.6283L14.358 15.7536C15.2661 15.2771 15.904 14.9414 16.3807 14.6231C16.8443 14.3135 17.1121 14.0475 17.2973 13.7331C17.4835 13.4169 17.5922 13.0412 17.6494 12.4602C17.708 11.8662 17.7087 11.113 17.7087 10.0487V9.95126C17.7087 8.88701 17.708 8.13383 17.6494 7.53982C17.6262 7.30344 17.5943 7.10104 17.5523 6.92281L14.792 8.30294V10.8333C14.792 11.1785 14.5122 11.4583 14.167 11.4583C13.8218 11.4583 13.542 11.1785 13.542 10.8333V8.92794L10.6253 10.3863V17.6046Z" fill="#1D2977" fill-opacity="0.64"/>
</svg>';
        echo '<span>' . __("دسته بندی محصولات", "lamkadeh") . '</span> <i class="fa-solid fa-angle-left"></i>';
        if ($image_url) {
            echo '<img class="lamkadeh-category-thumb" src="' . esc_url($image_url) . '" alt="' . esc_attr($term->name) . '">';
        }
        echo '<span>' . esc_html($term->name) . '</span></a>';
    } elseif (is_page()) {
        echo '<span>' . get_the_title() . '</span>';
    } elseif (is_category()) {
        $category = get_queried_object();
        echo '<span>' . $category->name . '</span>';
    } elseif (is_tag()) {
        $tag = get_queried_object();
        echo '<span>' . $tag->name . '</span>';
    } elseif (is_archive()) {
        echo '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M10.0003 1.04167C9.49638 1.04167 9.03237 1.16691 8.52431 1.37702C8.03372 1.57991 7.46393 1.87893 6.75441 2.25128L5.03148 3.15543C4.16067 3.6124 3.46379 3.9781 2.92572 4.33743C2.36827 4.7097 1.93893 5.10168 1.62626 5.63265C1.31464 6.16185 1.17446 6.73487 1.10723 7.41727C1.04198 8.07965 1.04199 8.89429 1.04199 9.91881V10.0812C1.04199 11.1057 1.04198 11.9204 1.10723 12.5827C1.17446 13.2651 1.31464 13.8382 1.62626 14.3674C1.93893 14.8983 2.36827 15.2903 2.92572 15.6626C3.46379 16.0219 4.16066 16.3876 5.03147 16.8446L6.75433 17.7487C7.46389 18.1211 8.0337 18.4201 8.5243 18.623C9.03237 18.8331 9.49638 18.9583 10.0003 18.9583C10.5043 18.9583 10.9683 18.8331 11.4763 18.623C11.9669 18.4201 12.5367 18.1211 13.2462 17.7487L14.9691 16.8446C15.84 16.3876 16.5369 16.0219 17.0749 15.6626C17.6324 15.2903 18.0617 14.8983 18.3744 14.3674C18.686 13.8382 18.8262 13.2651 18.8934 12.5827C18.9587 11.9204 18.9587 11.1057 18.9587 10.0812V9.91879C18.9587 8.89429 18.9587 8.07965 18.8934 7.41727C18.8262 6.73487 18.686 6.16185 18.3744 5.63265C18.0617 5.10168 17.6324 4.7097 17.0749 4.33743C16.5369 3.9781 15.84 3.6124 14.9692 3.15542L13.2463 2.25129C12.5367 1.87894 11.9669 1.57991 11.4763 1.37702C10.9683 1.16691 10.5043 1.04167 10.0003 1.04167ZM7.30933 3.37173C8.05076 2.98265 8.57033 2.71067 9.00201 2.53214C9.42219 2.35837 9.71737 2.29167 10.0003 2.29167C10.2833 2.29167 10.5785 2.35837 10.9986 2.53214C11.4303 2.71067 11.9499 2.98265 12.6913 3.37174L14.358 4.24636C15.2661 4.7229 15.904 5.05861 16.3807 5.37694C16.6159 5.53399 16.8007 5.67982 16.9499 5.82645L14.1743 7.21424L7.09111 3.48625L7.30933 3.37173ZM5.78754 4.17033L5.64266 4.24636C4.73458 4.7229 4.0966 5.05861 3.61992 5.37694C3.38475 5.53399 3.19996 5.67982 3.05077 5.82646L10.0003 9.30123L12.798 7.90241L5.95923 4.30308C5.89279 4.26811 5.83525 4.22287 5.78754 4.17033ZM2.44839 6.92281C2.40631 7.10105 2.3745 7.30344 2.35121 7.53982C2.29269 8.13383 2.29199 8.88701 2.29199 9.95126V10.0487C2.29199 11.113 2.29269 11.8662 2.35121 12.4602C2.40844 13.0412 2.51717 13.4169 2.70339 13.7331C2.88855 14.0475 3.15638 14.3135 3.61992 14.6231C4.0966 14.9414 4.73458 15.2771 5.64266 15.7536L7.30933 16.6283C8.05076 17.0174 8.57033 17.2893 9.00201 17.4679C9.13832 17.5242 9.26147 17.5693 9.37532 17.6046V10.3863L2.44839 6.92281ZM10.6253 17.6046C10.7392 17.5693 10.8623 17.5242 10.9986 17.4679C11.4303 17.2893 11.9499 17.0174 12.6913 16.6283L14.358 15.7536C15.2661 15.2771 15.904 14.9414 16.3807 14.6231C16.8443 14.3135 17.1121 14.0475 17.2973 13.7331C17.4835 13.4169 17.5922 13.0412 17.6494 12.4602C17.708 11.8662 17.7087 11.113 17.7087 10.0487V9.95126C17.7087 8.88701 17.708 8.13383 17.6494 7.53982C17.6262 7.30344 17.5943 7.10104 17.5523 6.92281L14.792 8.30294V10.8333C14.792 11.1785 14.5122 11.4583 14.167 11.4583C13.8218 11.4583 13.542 11.1785 13.542 10.8333V8.92794L10.6253 10.3863V17.6046Z" fill="#1D2977" fill-opacity="0.64"/>
</svg>';
        echo '<span>' . __("دسته بندی محصولات", "lamkadeh") . '</span>';
    } elseif (is_404()) {
        echo '<span>' . __("صفحه مورد نظر یافت نشد", "lamkadeh") . '</span>';
    }

    echo '</nav>';
    echo '</div>';
    echo '</div>';
}
