<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php get_bloginfo("charset") ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <link rel="pingback" href="<?php get_bloginfo('pingback_url'); ?>">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <?php wp_head(); ?>
</head>

<body <?php body_class() ?>>
    <header>
        <div class="header-top-container">
            <section class="header-top">
                <section class="header-top-one">
                    <p>
                        <?php
                        $site_text_welcome_header = get_option("site_text_welcome_header");
                        $site_enable_thumbnail_welcome_header = get_option("site_enable_thumbnail_welcome_header");
                        $site_image_welcome_header = get_option("site_image_welcome_header");
                        echo esc_html($site_text_welcome_header);
                        ?>
                    </p>
                    <?php
                    if ($site_enable_thumbnail_welcome_header === "yes") {
                        echo '<div class="img-top-header" style="background: url(' . esc_url($site_image_welcome_header) . ')"></div>';
                    }
                    ?>
                </section>
                <section class="header-top-two">
                    <div class="circle-top"></div>
                    <div class="signup-top">
                        <?php
                        if (!is_user_logged_in()):
                        ?>
                            <a
                                href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>"><?php echo __("ورود | ثبت نام", "lamkadeh") ?></a>
                            <div>
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M7.99993 0.833333C6.25102 0.833333 4.83326 2.2511 4.83326 4C4.83326 5.7489 6.25102 7.16667 7.99993 7.16667C9.74883 7.16667 11.1666 5.7489 11.1666 4C11.1666 2.2511 9.74883 0.833333 7.99993 0.833333ZM5.83326 4C5.83326 2.80338 6.80331 1.83333 7.99993 1.83333C9.19654 1.83333 10.1666 2.80338 10.1666 4C10.1666 5.19662 9.19654 6.16667 7.99993 6.16667C6.80331 6.16667 5.83326 5.19662 5.83326 4Z"
                                        fill="#1D2977" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M7.99993 8.16667C6.45756 8.16667 5.03654 8.51725 3.98356 9.10956C2.94625 9.69305 2.16659 10.5774 2.16659 11.6667L2.16655 11.7346C2.1658 12.5092 2.16485 13.4813 3.01753 14.1757C3.43718 14.5174 4.02424 14.7604 4.8174 14.921C5.61277 15.082 6.64941 15.1667 7.99993 15.1667C9.35044 15.1667 10.3871 15.082 11.1825 14.921C11.9756 14.7604 12.5627 14.5174 12.9823 14.1757C13.835 13.4813 13.8341 12.5092 13.8333 11.7346L13.8333 11.6667C13.8333 10.5774 13.0536 9.69305 12.0163 9.10956C10.9633 8.51725 9.54229 8.16667 7.99993 8.16667ZM3.16659 11.6667C3.16659 11.0991 3.58085 10.4834 4.47382 9.98113C5.35112 9.48765 6.59678 9.16667 7.99993 9.16667C9.40308 9.16667 10.6487 9.48765 11.526 9.98113C12.419 10.4834 12.8333 11.0991 12.8333 11.6667C12.8333 12.5385 12.8064 13.0293 12.3509 13.4003C12.1038 13.6014 11.6909 13.7978 10.9841 13.9408C10.2794 14.0835 9.31608 14.1667 7.99993 14.1667C6.68378 14.1667 5.72042 14.0835 5.01579 13.9408C4.30894 13.7978 3.89601 13.6014 3.64899 13.4003C3.19347 13.0293 3.16659 12.5385 3.16659 11.6667Z"
                                        fill="#1D2977" />
                                </svg>
                            </div>
                        <?php
                        else:
                            $current_user = wp_get_current_user();
                        ?>
                            <a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>"
                                class="my-account-header-name"><?php echo $current_user->display_name; ?></a>
                            <section class="my-account-header-top">
                                <section class="header-my-account-top-header">
                                    <?php
                                    $roles = $current_user->roles;
                                    $role_name = !empty($roles) ? translate_user_role(ucfirst($roles[0])) : __("بدون نقش", "lamkadeh");
                                    echo '<span  class="badge-my-account-customer">' . esc_html($role_name) . '</span>';
                                    ?>
                                    <?php echo get_avatar(
                                        $current_user->ID,
                                        320
                                    ); ?>
                                    <section class="my-account-header-name-customer">
                                        <span><?php echo $current_user->display_name; ?></span>
                                    </section>
                                    <section class="shape-my-account-header-top-one"></section>
                                    <section class="shape-my-account-header-top-two"></section>
                                    <section class="shape-my-account-header-top-three"></section>
                                </section>
                                <section class="content-my-account-header-top">
                                    <section class="content-my-account-header-list">
                                        <section class="content-my-account-item">
                                            <a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>"
                                                class="nav-my-account-item">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M2 6.21053C2 4.22567 2 3.23323 2.65901 2.61662C3.31802 2 4.37868 2 6.5 2C8.62132 2 9.68198 2 10.341 2.61662C11 3.23323 11 4.22567 11 6.21053V17.7895C11 19.7743 11 20.7668 10.341 21.3834C9.68198 22 8.62132 22 6.5 22C4.37868 22 3.31802 22 2.65901 21.3834C2 20.7668 2 19.7743 2 17.7895V6.21053Z"
                                                        fill="#1D2977" />
                                                    <path
                                                        d="M13 15.4C13 13.3258 13 12.2887 13.659 11.6444C14.318 11 15.3787 11 17.5 11C19.6213 11 20.682 11 21.341 11.6444C22 12.2887 22 13.3258 22 15.4V17.6C22 19.6742 22 20.7113 21.341 21.3556C20.682 22 19.6213 22 17.5 22C15.3787 22 14.318 22 13.659 21.3556C13 20.7113 13 19.6742 13 17.6V15.4Z"
                                                        fill="#1D2977" />
                                                    <path
                                                        d="M13 5.5C13 4.4128 13 3.8692 13.1713 3.44041C13.3996 2.86867 13.8376 2.41443 14.389 2.17761C14.8024 2 15.3266 2 16.375 2H18.625C19.6734 2 20.1976 2 20.611 2.17761C21.1624 2.41443 21.6004 2.86867 21.8287 3.44041C22 3.8692 22 4.4128 22 5.5C22 6.5872 22 7.1308 21.8287 7.55959C21.6004 8.13133 21.1624 8.58557 20.611 8.82239C20.1976 9 19.6734 9 18.625 9H16.375C15.3266 9 14.8024 9 14.389 8.82239C13.8376 8.58557 13.3996 8.13133 13.1713 7.55959C13 7.1308 13 6.5872 13 5.5Z"
                                                        fill="#1D2977" />
                                                </svg>
                                                <?php echo __("داشبورد", "lamkadeh") ?>
                                            </a>
                                            <a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>"
                                                class="button-my-account-item">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M20 12H4M4 12L10 6M4 12L10 18" stroke="#1D2977"
                                                        stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                            </a>
                                        </section>
                                        <section class="content-my-account-item">
                                            <a href="<?php echo esc_url(wc_get_account_endpoint_url('orders')); ?>"
                                                class="nav-my-account-item">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M20.3116 12.6473L20.8293 10.7154C21.4335 8.46034 21.7356 7.3328 21.5081 6.35703C21.3285 5.58657 20.9244 4.88668 20.347 4.34587C19.6157 3.66095 18.4881 3.35883 16.2331 2.75458C13.978 2.15033 12.8504 1.84821 11.8747 2.07573C11.1042 2.25537 10.4043 2.65945 9.86351 3.23687C9.27709 3.86298 8.97128 4.77957 8.51621 6.44561C8.43979 6.7254 8.35915 7.02633 8.27227 7.35057L8.27222 7.35077L7.75458 9.28263C7.15033 11.5377 6.84821 12.6652 7.07573 13.641C7.25537 14.4115 7.65945 15.1114 8.23687 15.6522C8.96815 16.3371 10.0957 16.6392 12.3508 17.2435L12.3508 17.2435C14.3834 17.7881 15.4999 18.0873 16.415 17.9744C16.5152 17.9621 16.6129 17.9448 16.7092 17.9223C17.4796 17.7427 18.1795 17.3386 18.7203 16.7612C19.4052 16.0299 19.7074 14.9024 20.3116 12.6473Z"
                                                        stroke="#1D2977" stroke-width="1.5" />
                                                    <path
                                                        d="M16.415 17.9741C16.2065 18.6126 15.8399 19.1902 15.347 19.6519C14.6157 20.3368 13.4881 20.6389 11.2331 21.2432C8.97798 21.8474 7.85044 22.1495 6.87466 21.922C6.10421 21.7424 5.40432 21.3383 4.86351 20.7609C4.17859 20.0296 3.87647 18.9021 3.27222 16.647L2.75458 14.7151C2.15033 12.46 1.84821 11.3325 2.07573 10.3567C2.25537 9.58627 2.65945 8.88638 3.23687 8.34557C3.96815 7.66065 5.09569 7.35853 7.35077 6.75428C7.77741 6.63996 8.16368 6.53646 8.51621 6.44531"
                                                        stroke="#1D2977" stroke-width="1.5" />
                                                    <path d="M11.7769 10L16.6065 11.2941" stroke="#1D2977"
                                                        stroke-width="1.5" stroke-linecap="round" />
                                                    <path d="M11 12.8977L13.8978 13.6742" stroke="#1D2977"
                                                        stroke-width="1.5" stroke-linecap="round" />
                                                </svg>
                                                <?php echo __("سفارش ها", "lamkadeh") ?>
                                            </a>
                                            <a href="<?php echo esc_url(wc_get_account_endpoint_url('orders')); ?>"
                                                class="button-my-account-item">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M20 12H4M4 12L10 6M4 12L10 18" stroke="#1D2977"
                                                        stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                            </a>
                                        </section>
                                        <?php
                                        $downloads_endpoint = get_option('woocommerce_myaccount_downloads_endpoint', 'downloads');
                                        if (!empty($downloads_endpoint)): ?>
                                            <section class="content-my-account-item">
                                                <a href="<?php echo esc_url(wc_get_account_endpoint_url('downloads')); ?>"
                                                    class="nav-my-account-item">
                                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M12 7L12 14M12 14L15 11M12 14L9 11" stroke="#1D2977"
                                                            stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                        <path d="M16 17H12H8" stroke="#1D2977" stroke-width="1.5"
                                                            stroke-linecap="round" />
                                                        <path
                                                            d="M2 12C2 7.28595 2 4.92893 3.46447 3.46447C4.92893 2 7.28595 2 12 2C16.714 2 19.0711 2 20.5355 3.46447C22 4.92893 22 7.28595 22 12C22 16.714 22 19.0711 20.5355 20.5355C19.0711 22 16.714 22 12 22C7.28595 22 4.92893 22 3.46447 20.5355C2 19.0711 2 16.714 2 12Z"
                                                            stroke="#1D2977" stroke-width="1.5" />
                                                    </svg>
                                                    <?php echo __("دانلود ها", "lamkadeh") ?>
                                                </a>
                                                <a href="<?php echo esc_url(wc_get_account_endpoint_url('orders')); ?>"
                                                    class="button-my-account-item">
                                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M20 12H4M4 12L10 6M4 12L10 18" stroke="#1D2977"
                                                            stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                </a>
                                            </section>
                                        <?php endif; ?>
                                        <section class="content-my-account-item">
                                            <a href="<?php echo esc_url(wc_get_account_endpoint_url('edit-address')); ?>"
                                                class="nav-my-account-item">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M17.3864 2.92637C16.0864 2.75159 14.3782 2.75 12 2.75C9.62177 2.75 7.91356 2.75159 6.61358 2.92637C5.33517 3.09825 4.56445 3.42514 3.9948 3.9948C3.42514 4.56445 3.09825 5.33517 2.92637 6.61358C2.75159 7.91356 2.75 9.62177 2.75 12C2.75 14.3782 2.75159 16.0864 2.92637 17.3864C3.09825 18.6648 3.42514 19.4355 3.9948 20.0052C4.46242 20.4728 5.06554 20.7769 5.97376 20.9659L20.9659 5.97376C20.7769 5.06554 20.4728 4.46242 20.0052 3.9948C19.4355 3.42514 18.6648 3.09825 17.3864 2.92637ZM21.1873 7.87364L15.0611 13.9998L20.4683 19.4071C20.763 18.9078 20.9551 18.2678 21.0736 17.3864C21.2484 16.0864 21.25 14.3782 21.25 12C21.25 10.3215 21.2492 8.97669 21.1873 7.87364ZM19.4078 20.4679L14.0004 15.0605L7.87364 21.1873C8.97669 21.2492 10.3215 21.25 12 21.25C14.3782 21.25 16.0864 21.2484 17.3864 21.0736C18.2682 20.9551 18.9085 20.7628 19.4078 20.4679ZM17.5863 1.43975C19.031 1.63399 20.1711 2.03933 21.0659 2.93414C21.9607 3.82895 22.366 4.96897 22.5603 6.41371C22.75 7.82519 22.75 9.63423 22.75 11.9426V12.0574C22.75 14.3658 22.75 16.1748 22.5603 17.5863C22.366 19.031 21.9607 20.1711 21.0659 21.0659C20.1711 21.9607 19.031 22.366 17.5863 22.5603C16.1748 22.75 14.3658 22.75 12.0574 22.75H11.9426C9.63423 22.75 7.82519 22.75 6.41371 22.5603C4.96897 22.366 3.82895 21.9607 2.93414 21.0659C2.03933 20.1711 1.63399 19.031 1.43975 17.5863C1.24998 16.1748 1.24999 14.3658 1.25 12.0574V11.9426C1.24999 9.63423 1.24998 7.82519 1.43975 6.41371C1.63399 4.96897 2.03933 3.82895 2.93414 2.93414C3.82895 2.03933 4.96897 1.63399 6.41371 1.43975C7.82519 1.24998 9.63423 1.24999 11.9426 1.25H12.0574C14.3658 1.24999 16.1748 1.24998 17.5863 1.43975ZM4.75 8.75722C4.75 6.49419 6.70446 4.7499 9 4.7499C11.2955 4.7499 13.25 6.49419 13.25 8.75722C13.25 10.7835 12.0042 13.175 9.93476 14.0593C9.34021 14.3134 8.65979 14.3134 8.06524 14.0593C5.99581 13.175 4.75 10.7835 4.75 8.75722ZM9 6.2499C7.42955 6.2499 6.25 7.42231 6.25 8.75722C6.25 10.3007 7.23835 12.0747 8.65469 12.68C8.87274 12.7732 9.12726 12.7732 9.34531 12.68C10.7617 12.0747 11.75 10.3007 11.75 8.75722C11.75 7.42231 10.5705 6.2499 9 6.2499Z"
                                                        fill="#1D2977" />
                                                    <path
                                                        d="M10 9C10 9.55229 9.55229 10 9 10C8.44772 10 8 9.55229 8 9C8 8.44772 8.44772 8 9 8C9.55229 8 10 8.44772 10 9Z"
                                                        fill="#1D2977" />
                                                </svg>
                                                <?php echo __("آدرس ها", "lamkadeh") ?>
                                            </a>
                                            <a href="<?php echo esc_url(wc_get_account_endpoint_url('edit-address')); ?>"
                                                class="button-my-account-item">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M20 12H4M4 12L10 6M4 12L10 18" stroke="#1D2977"
                                                        stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                            </a>
                                        </section>
                                        <section class="content-my-account-item">
                                            <a href="<?php echo esc_url(wc_get_account_endpoint_url('news')); ?>"
                                                class="nav-my-account-item">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M11.9426 1.25C9.63423 1.24999 7.82519 1.24998 6.41371 1.43975C4.96897 1.63399 3.82895 2.03933 2.93414 2.93414C2.03933 3.82895 1.63399 4.96897 1.43975 6.41371C1.24998 7.82519 1.24999 9.63423 1.25 11.9426V12.0574C1.24999 14.3658 1.24998 16.1748 1.43975 17.5863C1.63399 19.031 2.03933 20.1711 2.93414 21.0659C3.82895 21.9607 4.96897 22.366 6.41371 22.5603C7.82519 22.75 9.63423 22.75 11.9426 22.75H12.0574C14.3658 22.75 16.1748 22.75 17.5863 22.5603C19.031 22.366 20.1711 21.9607 21.0659 21.0659C21.9607 20.1711 22.366 19.031 22.5603 17.5863C22.75 16.1748 22.75 14.3658 22.75 12.0574V10.5C22.75 10.0858 22.4142 9.75 22 9.75C21.5858 9.75 21.25 10.0858 21.25 10.5V12C21.25 14.3782 21.2484 16.0864 21.0736 17.3864C20.9018 18.6648 20.5749 19.4355 20.0052 20.0052C19.4355 20.5749 18.6648 20.9018 17.3864 21.0736C16.0864 21.2484 14.3782 21.25 12 21.25C9.62178 21.25 7.91356 21.2484 6.61358 21.0736C5.33517 20.9018 4.56445 20.5749 3.9948 20.0052C3.42514 19.4355 3.09825 18.6648 2.92637 17.3864C2.75159 16.0864 2.75 14.3782 2.75 12C2.75 9.62178 2.75159 7.91356 2.92637 6.61358C3.09825 5.33517 3.42514 4.56445 3.9948 3.9948C4.56445 3.42514 5.33517 3.09825 6.61358 2.92637C7.91356 2.75159 9.62178 2.75 12 2.75H13.5C13.9142 2.75 14.25 2.41421 14.25 2C14.25 1.58579 13.9142 1.25 13.5 1.25H11.9426Z"
                                                        fill="#1D2977" />
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M19 1.25C16.9289 1.25 15.25 2.92893 15.25 5C15.25 7.07107 16.9289 8.75 19 8.75C21.0711 8.75 22.75 7.07107 22.75 5C22.75 2.92893 21.0711 1.25 19 1.25ZM16.75 5C16.75 3.75736 17.7574 2.75 19 2.75C20.2426 2.75 21.25 3.75736 21.25 5C21.25 6.24264 20.2426 7.25 19 7.25C17.7574 7.25 16.75 6.24264 16.75 5Z"
                                                        fill="#1D2977" />
                                                    <path
                                                        d="M6.25 14C6.25 13.5858 6.58579 13.25 7 13.25H16C16.4142 13.25 16.75 13.5858 16.75 14C16.75 14.4142 16.4142 14.75 16 14.75H7C6.58579 14.75 6.25 14.4142 6.25 14Z"
                                                        fill="#1D2977" />
                                                    <path
                                                        d="M7 16.75C6.58579 16.75 6.25 17.0858 6.25 17.5C6.25 17.9142 6.58579 18.25 7 18.25H13C13.4142 18.25 13.75 17.9142 13.75 17.5C13.75 17.0858 13.4142 16.75 13 16.75H7Z"
                                                        fill="#1D2977" />
                                                </svg>
                                                <?php echo __("اخبار و اطلاعیه ها", "lamkadeh") ?>
                                            </a>
                                            <a href="<?php echo esc_url(wc_get_account_endpoint_url('news')); ?>"
                                                class="button-my-account-item">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M20 12H4M4 12L10 6M4 12L10 18" stroke="#1D2977"
                                                        stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                            </a>
                                        </section>
                                        <section class="content-my-account-item">
                                            <a href="<?php echo esc_url(wc_get_account_endpoint_url('tickets')); ?>"
                                                class="nav-my-account-item">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M8.98899 5.30778C10.169 2.90545 12.6404 1.25 15.5 1.25C19.5041 1.25 22.75 4.49594 22.75 8.5C22.75 9.57209 22.5168 10.5918 22.0977 11.5093C21.9883 11.7488 21.967 11.975 22.0156 12.1568L22.143 12.6328C22.5507 14.1566 21.1566 15.5507 19.6328 15.143L19.1568 15.0156C19.0215 14.9794 18.8616 14.982 18.6899 15.0307C18.1798 19.3775 14.4838 22.75 10 22.75C8.65003 22.75 7.36949 22.4438 6.2259 21.8963C5.99951 21.7879 5.7766 21.7659 5.59324 21.815L4.3672 22.143C2.84337 22.5507 1.44927 21.1566 1.857 19.6328L2.18504 18.4068C2.2341 18.2234 2.21211 18.0005 2.10373 17.7741C1.55623 16.6305 1.25 15.35 1.25 14C1.25 9.50945 4.63273 5.80897 8.98899 5.30778ZM10.735 5.28043C15.0598 5.64011 18.4914 9.14511 18.736 13.5016C18.9986 13.4766 19.2714 13.4935 19.5445 13.5666L20.0205 13.694C20.4293 13.8034 20.8034 13.4293 20.694 13.0205L20.5666 12.5445C20.4095 11.9571 20.5119 11.3708 20.7333 10.8861C21.0649 10.1602 21.25 9.35275 21.25 8.5C21.25 5.32436 18.6756 2.75 15.5 2.75C13.5181 2.75 11.7692 3.75284 10.735 5.28043ZM10 6.75C5.99594 6.75 2.75 9.99594 2.75 14C2.75 15.121 3.00392 16.1807 3.45667 17.1264C3.69207 17.6181 3.79079 18.2087 3.63407 18.7945L3.30602 20.0205C3.19664 20.4293 3.57066 20.8034 3.97949 20.694L5.20553 20.3659C5.79126 20.2092 6.38191 20.3079 6.87362 20.5433C7.81932 20.9961 8.87896 21.25 10 21.25C14.0041 21.25 17.25 18.0041 17.25 14C17.25 9.99594 14.0041 6.75 10 6.75Z"
                                                        fill="#1D2977" />
                                                    <path
                                                        d="M7.5 14C7.5 14.5523 7.05228 15 6.5 15C5.94772 15 5.5 14.5523 5.5 14C5.5 13.4477 5.94772 13 6.5 13C7.05228 13 7.5 13.4477 7.5 14Z"
                                                        fill="#1D2977" />
                                                    <path
                                                        d="M11 14C11 14.5523 10.5523 15 10 15C9.44772 15 9 14.5523 9 14C9 13.4477 9.44772 13 10 13C10.5523 13 11 13.4477 11 14Z"
                                                        fill="#1D2977" />
                                                    <path
                                                        d="M14.5 14C14.5 14.5523 14.0523 15 13.5 15C12.9477 15 12.5 14.5523 12.5 14C12.5 13.4477 12.9477 13 13.5 13C14.0523 13 14.5 13.4477 14.5 14Z"
                                                        fill="#1D2977" />
                                                </svg>
                                                <?php echo __("تیکت ها", "lamkadeh") ?>
                                            </a>
                                            <a href="<?php echo esc_url(wc_get_account_endpoint_url('tickets')); ?>"
                                                class="button-my-account-item">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M20 12H4M4 12L10 6M4 12L10 18" stroke="#1D2977"
                                                        stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                            </a>
                                        </section>
                                        <section class="content-my-account-item">
                                            <a href="<?php echo esc_url(wc_get_account_endpoint_url('edit-account')); ?>"
                                                class="nav-my-account-item">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <circle cx="12" cy="6" r="4" stroke="#1D2977" stroke-width="1.5" />
                                                    <path
                                                        d="M20 17.5C20 19.9853 20 22 12 22C4 22 4 19.9853 4 17.5C4 15.0147 7.58172 13 12 13C16.4183 13 20 15.0147 20 17.5Z"
                                                        stroke="#1D2977" stroke-width="1.5" />
                                                </svg>
                                                <?php echo __("حساب کاربری", "lamkadeh") ?>
                                            </a>
                                            <a href="<?php echo esc_url(wc_get_account_endpoint_url('edit-account')); ?>"
                                                class="button-my-account-item">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M20 12H4M4 12L10 6M4 12L10 18" stroke="#1D2977"
                                                        stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                            </a>
                                        </section>
                                        <section class="content-my-account-item">
                                            <a href="<?php echo esc_url(wc_get_account_endpoint_url('customer-logout')); ?>"
                                                class="nav-my-account-item">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M6 3C4.34315 3 3 4.34315 3 6V18C3 19.6569 4.34315 21 6 21H17C17.5523 21 18 20.5523 18 20C18 19.4477 17.5523 19 17 19H6C5.44772 19 5 18.5523 5 18V6C5 5.44772 5.44772 5 6 5H17C17.5523 5 18 4.55228 18 4C18 3.44772 17.5523 3 17 3H6ZM15.7071 7.29289C15.3166 6.90237 14.6834 6.90237 14.2929 7.29289C13.9024 7.68342 13.9024 8.31658 14.2929 8.70711L16.5858 11H8C7.44772 11 7 11.4477 7 12C7 12.5523 7.44772 13 8 13H16.5858L14.2929 15.2929C13.9024 15.6834 13.9024 16.3166 14.2929 16.7071C14.6834 17.0976 15.3166 17.0976 15.7071 16.7071L19.7071 12.7071C20.0976 12.3166 20.0976 11.6834 19.7071 11.2929L15.7071 7.29289Z"
                                                        fill="#1D2977" />
                                                </svg>
                                                <?php echo __("خروج از حساب کاربری", "lamkadeh") ?>
                                            </a>
                                            <a href="<?php echo esc_url(wc_get_account_endpoint_url('customer-logout')); ?>"
                                                class="button-my-account-item">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M20 12H4M4 12L10 6M4 12L10 18" stroke="#1D2977"
                                                        stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                            </a>
                                        </section>
                                    </section>
                                </section>
                            </section>
                            <section class="overly-signup-top"></section>
                            <div>
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M7.99993 0.833333C6.25102 0.833333 4.83326 2.2511 4.83326 4C4.83326 5.7489 6.25102 7.16667 7.99993 7.16667C9.74883 7.16667 11.1666 5.7489 11.1666 4C11.1666 2.2511 9.74883 0.833333 7.99993 0.833333ZM5.83326 4C5.83326 2.80338 6.80331 1.83333 7.99993 1.83333C9.19654 1.83333 10.1666 2.80338 10.1666 4C10.1666 5.19662 9.19654 6.16667 7.99993 6.16667C6.80331 6.16667 5.83326 5.19662 5.83326 4Z"
                                        fill="#1D2977" />
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M7.99993 8.16667C6.45756 8.16667 5.03654 8.51725 3.98356 9.10956C2.94625 9.69305 2.16659 10.5774 2.16659 11.6667L2.16655 11.7346C2.1658 12.5092 2.16485 13.4813 3.01753 14.1757C3.43718 14.5174 4.02424 14.7604 4.8174 14.921C5.61277 15.082 6.64941 15.1667 7.99993 15.1667C9.35044 15.1667 10.3871 15.082 11.1825 14.921C11.9756 14.7604 12.5627 14.5174 12.9823 14.1757C13.835 13.4813 13.8341 12.5092 13.8333 11.7346L13.8333 11.6667C13.8333 10.5774 13.0536 9.69305 12.0163 9.10956C10.9633 8.51725 9.54229 8.16667 7.99993 8.16667ZM3.16659 11.6667C3.16659 11.0991 3.58085 10.4834 4.47382 9.98113C5.35112 9.48765 6.59678 9.16667 7.99993 9.16667C9.40308 9.16667 10.6487 9.48765 11.526 9.98113C12.419 10.4834 12.8333 11.0991 12.8333 11.6667C12.8333 12.5385 12.8064 13.0293 12.3509 13.4003C12.1038 13.6014 11.6909 13.7978 10.9841 13.9408C10.2794 14.0835 9.31608 14.1667 7.99993 14.1667C6.68378 14.1667 5.72042 14.0835 5.01579 13.9408C4.30894 13.7978 3.89601 13.6014 3.64899 13.4003C3.19347 13.0293 3.16659 12.5385 3.16659 11.6667Z"
                                        fill="#1D2977" />
                                </svg>
                            </div>
                        <?php
                        endif;
                        ?>
                    </div>
                    <div class="help-top">
                        <?php
                        $site_text_support_header = get_option("site_text_support_header");
                        $site_link_support_header = get_option("site_link_support_header");
                        ?>
                        <a
                            href="<?php echo esc_url($site_link_support_header) ?>"><?php echo esc_html($site_text_support_header) ?></a>
                        <div>
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M8.00016 4.16667C8.27631 4.16667 8.50016 4.39052 8.50016 4.66667V8.66667C8.50016 8.94281 8.27631 9.16667 8.00016 9.16667C7.72402 9.16667 7.50016 8.94281 7.50016 8.66667V4.66667C7.50016 4.39052 7.72402 4.16667 8.00016 4.16667Z"
                                    fill="#1D2977" />
                                <path
                                    d="M8.00016 11.3333C8.36835 11.3333 8.66683 11.0349 8.66683 10.6667C8.66683 10.2985 8.36835 10 8.00016 10C7.63197 10 7.3335 10.2985 7.3335 10.6667C7.3335 11.0349 7.63197 11.3333 8.00016 11.3333Z"
                                    fill="#1D2977" />
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M0.833496 8C0.833496 4.04196 4.04212 0.833333 8.00016 0.833333C11.9582 0.833333 15.1668 4.04196 15.1668 8C15.1668 11.958 11.9582 15.1667 8.00016 15.1667C4.04212 15.1667 0.833496 11.958 0.833496 8ZM8.00016 1.83333C4.59441 1.83333 1.8335 4.59424 1.8335 8C1.8335 11.4058 4.59441 14.1667 8.00016 14.1667C11.4059 14.1667 14.1668 11.4058 14.1668 8C14.1668 4.59424 11.4059 1.83333 8.00016 1.83333Z"
                                    fill="#1D2977" />
                            </svg>
                        </div>
                    </div>
                </section>
            </section>
        </div>
        <?php
        if (lamkadeh_not_in_elementor()) :
        ?>
            <div class="header-bottom">
                <div class="header-bottom-right">
                    <?php
                    $logo_url    = get_option('site_logo_theme');
                    $logo_url    = is_string($logo_url) ? $logo_url : '';
                    $logo_width  = get_option('site_logo_width');
                    $logo_width  = is_numeric($logo_width) && $logo_width > 0 ? $logo_width : 'auto';
                    $logo_height = get_option('site_logo_height');
                    $logo_height = is_numeric($logo_height) && $logo_height > 0 ? $logo_height : 'auto';
                    $site_name   = get_bloginfo('name');
                    ?>

                    <a href="<?php echo esc_url(home_url('/')); ?>" class="header-logo">

                        <?php if (!empty($logo_url)) : ?>
                            <img
                                src="<?php echo esc_url($logo_url); ?>"
                                <?php if ($logo_width) : ?> width="<?php echo esc_attr($logo_width); ?>" <?php endif; ?>
                                <?php if ($logo_height) : ?> height="<?php echo esc_attr($logo_height); ?>" <?php endif; ?>
                                class="logo-header"
                                alt="<?php echo esc_attr($site_name); ?>"
                                loading="lazy"
                                fetchpriority="high">
                        <?php endif; ?>

                        <div class="circle-header-bootom-right-back-logo"></div>

                    </a>
                    <div>
                        <?php
                        $site_text_one = get_option("site_text_one");
                        $site_text_two = get_option("site_text_two");
                        ?>
                        <p><?php echo esc_html($site_text_one); ?></p>
                        <p><?php echo esc_html($site_text_two); ?></p>
                    </div>
                </div>
                <div class="header-bottom-left">
                    <div class="header-bottom-left-main">
                        <nav class="navbar">
                            <?php if (has_nav_menu('primary_menu')): ?>
                                <?php
                                wp_nav_menu([
                                    'theme_location' => 'primary_menu',
                                    'container' => false,
                                    'items_wrap' => '<ul>%3$s</ul>',
                                    'walker' => new Lamkadeh_Walker_Nav_Menu()
                                ]);
                                ?>
                            <?php endif; ?>
                        </nav>
                        <div class="header-bottom-left-info">
                            <div class="header-bottom-left-counseling">
                                <?php
                                $site_contact_quick_text = get_option("site_contact_quick_text");
                                $site_contact_quick_tel = get_option("site_contact_quick_tel");
                                ?>
                                <a href="tel:<?php echo esc_html($site_contact_quick_tel); ?>"
                                    class="header-bottom-left-counseling-text">
                                    <span><?php echo esc_html($site_contact_quick_text); ?></span>
                                    <span><?php echo esc_html($site_contact_quick_tel); ?></span>
                                </a>
                                <div class="header-bottom-left-counseling-icon">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M4.7177 3.09212C5.94388 1.80118 7.9721 2.04305 8.98569 3.47663L10.2467 5.26011C11.0574 6.40678 10.9889 8.00095 10.0214 9.01963L9.7765 9.27741C9.77582 9.27919 9.7751 9.28112 9.77436 9.28321C9.76142 9.31957 9.7287 9.43535 9.7609 9.65511C9.82765 10.1106 10.1793 11.0363 11.607 12.5394C13.0391 14.0472 13.9078 14.4025 14.3103 14.4679C14.484 14.4961 14.5748 14.4716 14.6038 14.4614L15.0124 14.0312C15.8862 13.1113 17.2485 12.93 18.347 13.5623L20.2575 14.662C21.8904 15.6019 22.2705 17.901 20.9655 19.2749L19.545 20.7705C19.1016 21.2373 18.497 21.6357 17.75 21.7095C15.9261 21.8895 11.701 21.655 7.27161 16.9917C3.13844 12.6403 2.35326 8.85535 2.25401 7.00613L2.92011 6.97038L2.25401 7.00613C2.20497 6.09246 2.61224 5.30877 3.1481 4.74462L4.7177 3.09212ZM7.7609 4.3426C7.24855 3.61795 6.32812 3.57471 5.80528 4.12516L4.23568 5.77765C3.90429 6.12654 3.73042 6.52644 3.75185 6.92574C3.83289 8.43555 4.48307 11.8778 8.35919 15.9587C12.4234 20.2375 16.1676 20.3584 17.6026 20.2167C17.8864 20.1887 18.1783 20.0313 18.4574 19.7375L19.8779 18.2419C20.4907 17.5968 20.3301 16.4345 19.5092 15.962L17.5987 14.8623C17.086 14.5672 16.4854 14.6584 16.1 15.0642L15.6446 15.5437L15.1174 15.043C15.6445 15.5437 15.6438 15.5445 15.6432 15.5452L15.6417 15.5467L15.6388 15.5497L15.6324 15.5562L15.6181 15.5703C15.6078 15.5803 15.5959 15.5913 15.5825 15.6031C15.5556 15.6266 15.5223 15.6535 15.4824 15.6818C15.4023 15.7387 15.2955 15.8012 15.1606 15.8544C14.8846 15.9632 14.5201 16.0216 14.0699 15.9485C13.1923 15.806 12.0422 15.1757 10.5194 13.5724C8.99202 11.9644 8.40746 10.7647 8.27675 9.87257C8.21022 9.4185 8.26346 9.0549 8.36117 8.78033C8.40921 8.64531 8.46595 8.53764 8.51826 8.45588C8.54435 8.41511 8.56922 8.38097 8.5912 8.3532C8.60219 8.33931 8.61247 8.32701 8.62182 8.31625L8.63514 8.30126L8.64125 8.29463L8.64415 8.29152L8.64556 8.29002C8.64625 8.28929 8.64694 8.28857 9.17861 8.79355L8.64695 8.28856L8.93377 7.98659C9.3793 7.51753 9.44403 6.72315 9.02189 6.12608L7.7609 4.3426Z" />
                                        <path
                                            d="M13.2595 1.88008C13.3257 1.47119 13.7122 1.19381 14.1211 1.26001C14.1464 1.26485 14.2279 1.28007 14.2705 1.28958C14.3559 1.30858 14.4749 1.33784 14.6233 1.38106C14.9201 1.46751 15.3347 1.60991 15.8323 1.83805C16.8286 2.2948 18.1544 3.09381 19.5302 4.46961C20.906 5.84541 21.705 7.17122 22.1617 8.1675C22.3899 8.66511 22.5323 9.07972 22.6187 9.3765C22.6619 9.5249 22.6912 9.64393 22.7102 9.72926C22.7197 9.77193 22.7267 9.80619 22.7315 9.8315L22.7373 9.86269C22.8034 10.2716 22.5286 10.6741 22.1197 10.7403C21.712 10.8063 21.3279 10.5303 21.2601 10.1233C21.258 10.1124 21.2522 10.083 21.2461 10.0553C21.2337 9.99995 21.2124 9.91212 21.1786 9.79597C21.1109 9.56363 20.9934 9.2183 20.7982 8.79262C20.4084 7.94232 19.7074 6.76813 18.4695 5.53027C17.2317 4.29241 16.0575 3.59141 15.2072 3.20158C14.7815 3.00642 14.4362 2.88889 14.2038 2.82122C14.0877 2.78739 13.9417 2.75387 13.8863 2.74154C13.4793 2.67372 13.1935 2.2878 13.2595 1.88008Z" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M13.4861 5.32955C13.5999 4.93128 14.015 4.70066 14.4133 4.81445L14.2072 5.53559C14.4133 4.81445 14.4136 4.81455 14.414 4.81465L14.4147 4.81486L14.4162 4.81531L14.4196 4.81628L14.4273 4.81859L14.4471 4.82476C14.4622 4.82958 14.481 4.83586 14.5035 4.84383C14.5484 4.85976 14.6077 4.88243 14.6805 4.91363C14.8262 4.97607 15.0253 5.07249 15.2698 5.2172C15.7593 5.50688 16.4275 5.98806 17.2124 6.77303C17.9974 7.558 18.4786 8.22619 18.7683 8.71565C18.913 8.96016 19.0094 9.15923 19.0718 9.30491C19.103 9.37772 19.1257 9.43708 19.1416 9.48199C19.1496 9.50444 19.1559 9.52327 19.1607 9.53835L19.1669 9.55814L19.1692 9.56589L19.1702 9.56922L19.1706 9.57075L19.1708 9.57148C19.1709 9.57184 19.171 9.57219 18.4499 9.77823L19.171 9.57219C19.2848 9.97047 19.0542 10.3856 18.6559 10.4994C18.261 10.6122 17.8496 10.3864 17.7317 9.99438L17.728 9.9836C17.7227 9.96858 17.7116 9.939 17.6931 9.89579C17.6561 9.80946 17.589 9.66823 17.4774 9.47963C17.2544 9.10289 16.8517 8.53364 16.1518 7.83369C15.4518 7.13374 14.8826 6.73103 14.5058 6.50806C14.3172 6.39645 14.176 6.32935 14.0897 6.29235C14.0465 6.27383 14.0169 6.2628 14.0019 6.25747L13.9911 6.25377C13.599 6.13589 13.3733 5.72445 13.4861 5.32955Z" />
                                    </svg>
                                </div>
                                <div class="header-bottom-left-counseling-badge-phone">
                                    <svg width="150" height="24" viewBox="0 0 150 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0 1.77778C0 0.795939 0.795938 0 1.77778 0H142C146.418 0 150 3.58172 150 8V16C150 20.4183 146.418 24 142 24H22.2222C9.94922 24 0 14.0508 0 1.77778Z" />
                                    </svg>
                                </div>
                            </div>
                            <div class="underline-header-bottom-left"></div>
                            <div class="header-bootom-left-cart-search">
                                <div class="header-bottom-left-search">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M11 2.75C6.44365 2.75 2.75 6.44365 2.75 11C2.75 15.5563 6.44365 19.25 11 19.25C15.5563 19.25 19.25 15.5563 19.25 11C19.25 6.44365 15.5563 2.75 11 2.75ZM1.25 11C1.25 5.61522 5.61522 1.25 11 1.25C16.3848 1.25 20.75 5.61522 20.75 11C20.75 16.3848 16.3848 20.75 11 20.75C5.61522 20.75 1.25 16.3848 1.25 11ZM20.1579 19.7511C19.9264 19.7335 19.7335 19.9264 19.7511 20.1579C19.7514 20.1592 19.7553 20.1848 19.7746 20.2573C19.7974 20.3424 19.8312 20.4554 19.8828 20.6277C19.9301 20.7857 19.9609 20.8881 19.9862 20.9641C20.0121 21.0419 20.021 21.0568 20.0171 21.0496C20.1225 21.2465 20.3745 21.31 20.5607 21.1867C20.5538 21.1912 20.5688 21.1824 20.6284 21.1261C20.6868 21.0712 20.7624 20.9957 20.8791 20.8791C20.9957 20.7624 21.0712 20.6868 21.1261 20.6284C21.1727 20.579 21.1868 20.5602 21.1877 20.5592C21.3093 20.3736 21.2463 20.1236 21.0511 20.018C21.0499 20.0175 21.0287 20.0077 20.9641 19.9862C20.8881 19.9609 20.7857 19.9301 20.6277 19.8828C20.4554 19.8312 20.3424 19.7974 20.2573 19.7746C20.1848 19.7553 20.1591 19.7514 20.1579 19.7511ZM18.2564 20.2833C18.1612 19.1267 19.1267 18.1612 20.2833 18.2564C20.4832 18.2728 20.7251 18.3456 20.9862 18.4242C21.0101 18.4314 21.0341 18.4387 21.0583 18.4459C21.0801 18.4524 21.1018 18.4589 21.1234 18.4654C21.3632 18.5369 21.5881 18.604 21.7576 18.6948C22.7335 19.2173 23.0485 20.4659 22.4373 21.3889C22.3312 21.5492 22.165 21.715 21.9878 21.8917C21.9719 21.9076 21.9558 21.9236 21.9397 21.9397C21.9236 21.9558 21.9076 21.9719 21.8917 21.9878C21.7149 22.165 21.5492 22.3312 21.3889 22.4373C20.4659 23.0485 19.2173 22.7335 18.6948 21.7576C18.604 21.5881 18.5369 21.3632 18.4654 21.1234C18.4589 21.1018 18.4524 21.0801 18.4459 21.0583C18.4387 21.0341 18.4314 21.0101 18.4242 20.9862C18.3457 20.7252 18.2728 20.4833 18.2564 20.2833Z"
                                            fill="#020308" fill-opacity="0.64" />
                                    </svg>
                                    <div class="header-bottom-left-search-popup">
                                        <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M10 1.75C5.44365 1.75 1.75 5.44365 1.75 10C1.75 14.5563 5.44365 18.25 10 18.25C14.5563 18.25 18.25 14.5563 18.25 10C18.25 5.44365 14.5563 1.75 10 1.75ZM0.25 10C0.25 4.61522 4.61522 0.25 10 0.25C15.3848 0.25 19.75 4.61522 19.75 10C19.75 15.3848 15.3848 19.75 10 19.75C4.61522 19.75 0.25 15.3848 0.25 10ZM19.1579 18.7511C18.9264 18.7335 18.7335 18.9264 18.7511 19.1579C18.7514 19.1592 18.7553 19.1848 18.7746 19.2573C18.7974 19.3424 18.8312 19.4554 18.8828 19.6277C18.9301 19.7857 18.9609 19.8881 18.9862 19.9641C19.0121 20.0419 19.021 20.0568 19.0171 20.0496C19.1225 20.2465 19.3745 20.31 19.5607 20.1867C19.5538 20.1912 19.5688 20.1824 19.6284 20.1261C19.6868 20.0712 19.7624 19.9957 19.8791 19.8791C19.9957 19.7624 20.0712 19.6868 20.1261 19.6284C20.1727 19.579 20.1868 19.5602 20.1877 19.5592C20.3093 19.3736 20.2463 19.1236 20.0511 19.018C20.0499 19.0175 20.0287 19.0077 19.9641 18.9862C19.8881 18.9609 19.7857 18.9301 19.6277 18.8828C19.4554 18.8312 19.3424 18.7974 19.2573 18.7746C19.1848 18.7553 19.1591 18.7514 19.1579 18.7511ZM17.2564 19.2833C17.1612 18.1267 18.1267 17.1612 19.2833 17.2564C19.4833 17.2728 19.7251 17.3457 19.9862 17.4242C20.0101 17.4314 20.0341 17.4387 20.0583 17.4459C20.0801 17.4524 20.1018 17.4589 20.1234 17.4654C20.3632 17.5369 20.5881 17.604 20.7576 17.6948C21.7335 18.2173 22.0485 19.4659 21.4373 20.3889C21.3312 20.5492 21.165 20.715 20.9878 20.8917C20.9719 20.9076 20.9558 20.9236 20.9397 20.9397C20.9236 20.9558 20.9076 20.9719 20.8917 20.9878C20.7149 21.165 20.5492 21.3312 20.3889 21.4373C19.4659 22.0485 18.2173 21.7335 17.6948 20.7576C17.604 20.5881 17.5369 20.3632 17.4654 20.1234C17.4589 20.1018 17.4524 20.0801 17.4459 20.0583C17.4387 20.0341 17.4314 20.0101 17.4242 19.9862C17.3457 19.7252 17.2728 19.4833 17.2564 19.2833Z"
                                                fill="#040607" />
                                        </svg>
                                        <form role="search" method="get" action="<?php echo esc_url(home_url('/')); ?>">
                                            <input type="hidden" name="post_type" value="product" />
                                            <input type="text" autocomplete="off" value="<?php echo get_search_query(); ?>"
                                                name="s"
                                                placeholder="<?php
                                                                echo esc_attr(
                                                                    __("جست و جو در ", "lamkadeh") . get_bloginfo("name")
                                                                );
                                                                ?>" />
                                        </form>
                                    </div>
                                    <div class="overly-header-bottom-left-search-popup"></div>
                                </div>

                                <div class="header-bottom-left-cart">
                                    <a href="<?php echo esc_url(wc_get_cart_url()) ?>" class="header-bottom-left-cart-icon">
                                        <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_1_2640)">
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M9.00017 2.0625C8.06819 2.0625 7.31267 2.81802 7.31267 3.75V3.94086C7.62579 3.93749 7.96382 3.9375 8.3291 3.9375L9.67124 3.9375C10.0365 3.9375 10.3745 3.93749 10.6877 3.94086V3.75C10.6877 2.81802 9.93215 2.0625 9.00017 2.0625ZM11.8127 3.9802V3.75C11.8127 2.1967 10.5535 0.9375 9.00017 0.9375C7.44687 0.9375 6.18767 2.1967 6.18767 3.75V3.9802C6.08642 3.98759 5.98872 3.99626 5.8944 4.00642C5.23563 4.07742 4.68473 4.22616 4.19551 4.56148C4.02725 4.67681 3.8692 4.80637 3.72312 4.94875C3.29837 5.36271 3.04448 5.87374 2.84566 6.50579C2.65263 7.11944 2.49662 7.8995 2.30059 8.87969L2.28628 8.95123C2.0038 10.3636 1.78121 11.4765 1.71728 12.363C1.65195 13.2687 1.74324 14.0306 2.17226 14.691C2.31541 14.9113 2.48249 15.1151 2.67045 15.2987C3.2338 15.8488 3.96306 16.0878 4.86401 16.2014C5.74577 16.3125 6.88075 16.3125 8.32107 16.3125H9.67927C11.1196 16.3125 12.2546 16.3125 13.1363 16.2014C14.0373 16.0878 14.7665 15.8488 15.3299 15.2987C15.5179 15.1151 15.6849 14.9113 15.8281 14.691C16.2571 14.0306 16.3484 13.2687 16.2831 12.363C16.2191 11.4765 15.9965 10.3636 15.7141 8.95129L15.6998 8.87972C15.5037 7.89951 15.3477 7.11944 15.1547 6.50579C14.9559 5.87374 14.702 5.36271 14.2772 4.94875C14.1311 4.80637 13.9731 4.6768 13.8048 4.56148C13.3156 4.22616 12.7647 4.07742 12.1059 4.00642C12.0116 3.99626 11.9139 3.98759 11.8127 3.9802ZM6.01496 5.12494C5.45493 5.1853 5.10895 5.29929 4.83153 5.48943C4.71641 5.56834 4.60827 5.65699 4.50832 5.75441C4.26746 5.98914 4.08784 6.30605 3.91882 6.84337C3.74609 7.39246 3.60122 8.11294 3.39738 9.13216C3.10522 10.5929 2.89759 11.6365 2.83936 12.4439C2.78192 13.2403 2.87891 13.7137 3.11563 14.078C3.21357 14.2288 3.32789 14.3682 3.45649 14.4938C3.76732 14.7974 4.21247 14.9853 5.00471 15.0852C5.80788 15.1864 6.87185 15.1875 8.36157 15.1875H9.63877C11.1285 15.1875 12.1925 15.1864 12.9956 15.0852C13.7879 14.9853 14.233 14.7974 14.5439 14.4938C14.6725 14.3682 14.7868 14.2288 14.8847 14.078C15.1214 13.7137 15.2184 13.2403 15.161 12.4439C15.1027 11.6365 14.8951 10.5929 14.603 9.13216C14.3991 8.11294 14.2542 7.39246 14.0815 6.84337C13.9125 6.30605 13.7329 5.98914 13.492 5.75441C13.3921 5.65699 13.2839 5.56834 13.1688 5.48943C12.8914 5.29929 12.5454 5.1853 11.9854 5.12494C11.4131 5.06326 10.6782 5.0625 9.63877 5.0625H8.36157C7.32216 5.0625 6.58726 5.06326 6.01496 5.12494ZM6.69089 10.7197C6.9838 10.6161 7.30517 10.7696 7.40869 11.0625C7.64062 11.7187 8.26645 12.1875 9.00032 12.1875C9.73418 12.1875 10.36 11.7187 10.5919 11.0625C10.6955 10.7696 11.0168 10.6161 11.3097 10.7197C11.6026 10.8232 11.7562 11.1445 11.6526 11.4375C11.2668 12.5291 10.2258 13.3125 9.00032 13.3125C7.77486 13.3125 6.73383 12.5291 6.348 11.4375C6.24447 11.1445 6.39799 10.8232 6.69089 10.7197Z"
                                                    fill="#F7F8FD" />
                                            </g>
                                            <defs>
                                                <clipPath id="clip0_1_2640">
                                                    <rect width="18" height="18" fill="white" />
                                                </clipPath>
                                            </defs>
                                        </svg>
                                    </a>
                                    <a href="<?php echo esc_url(wc_get_cart_url()) ?>" class="header-bottom-left-cart-data">
                                        <span>سبد خرید شــــــما</span>
                                        <span>0 تــومان</span>
                                    </a>
                                    <div class="header-bottom-left-cart-popup">
                                        <div class="header-cart-popup">
                                            <span>Shopping cart</span>
                                            <div class="header-cart-title">
                                                <h6>سبد خریــــــد</h6>
                                                <div class="header-cart-shape">
                                                    <svg width="34" height="21" viewBox="0 0 34 21" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <circle cx="17" cy="17" r="17" fill="#F7F8FD" fill-opacity="0.64" />
                                                    </svg>
                                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M9.99997 2.29175C8.96444 2.29175 8.12497 3.13121 8.12497 4.16675V4.37881C8.47289 4.37508 8.84847 4.37508 9.25434 4.37508H10.7456C11.1515 4.37508 11.5271 4.37508 11.875 4.37881V4.16675C11.875 3.13121 11.0355 2.29175 9.99997 2.29175ZM13.125 4.42253V4.16675C13.125 2.44086 11.7259 1.04175 9.99997 1.04175C8.27408 1.04175 6.87497 2.44086 6.87497 4.16675V4.42253C6.76247 4.43074 6.65391 4.44037 6.54912 4.45166C5.81715 4.53055 5.20504 4.69582 4.66146 5.06839C4.4745 5.19653 4.2989 5.34049 4.13658 5.49869C3.66464 5.95864 3.38253 6.52646 3.16163 7.22874C2.94715 7.91057 2.77381 8.7773 2.556 9.8664L2.5401 9.94589C2.22623 11.5152 1.9789 12.7518 1.90787 13.7367C1.83529 14.7431 1.93671 15.5897 2.41341 16.3234C2.57246 16.5682 2.7581 16.7946 2.96695 16.9986C3.59289 17.6099 4.40319 17.8754 5.40423 18.0016C6.38397 18.1251 7.64506 18.1251 9.24542 18.1251H10.7545C12.3549 18.1251 13.616 18.1251 14.5957 18.0016C15.5968 17.8754 16.4071 17.6099 17.033 16.9986C17.2418 16.7946 17.4275 16.5682 17.5865 16.3234C18.0632 15.5897 18.1647 14.7431 18.0921 13.7367C18.021 12.7518 17.7737 11.5152 17.4599 9.94596L17.444 9.86644C17.2261 8.77732 17.0528 7.91057 16.8383 7.22874C16.6174 6.52646 16.3353 5.95864 15.8634 5.49869C15.701 5.34049 15.5254 5.19653 15.3385 5.06839C14.7949 4.69582 14.1828 4.53055 13.4508 4.45166C13.346 4.44037 13.2375 4.43074 13.125 4.42253ZM6.68307 5.69446C6.06081 5.76153 5.67639 5.88818 5.36815 6.09945C5.24023 6.18713 5.12008 6.28563 5.00902 6.39386C4.74141 6.65469 4.54182 7.0068 4.35402 7.60382C4.16211 8.21392 4.00114 9.01446 3.77465 10.1469C3.45003 11.77 3.21933 12.9295 3.15463 13.8266C3.0908 14.7116 3.19857 15.2375 3.46159 15.6423C3.57042 15.8098 3.69743 15.9648 3.84033 16.1043C4.1857 16.4416 4.6803 16.6504 5.56057 16.7614C6.45298 16.8739 7.63517 16.8751 9.29041 16.8751H10.7095C12.3648 16.8751 13.547 16.8739 14.4394 16.7614C15.3196 16.6504 15.8142 16.4416 16.1596 16.1043C16.3025 15.9648 16.4295 15.8098 16.5384 15.6423C16.8014 15.2375 16.9091 14.7116 16.8453 13.8266C16.7806 12.9295 16.5499 11.77 16.2253 10.1469C15.9988 9.01446 15.8378 8.21392 15.6459 7.60382C15.4581 7.0068 15.2585 6.65469 14.9909 6.39386C14.8799 6.28563 14.7597 6.18713 14.6318 6.09945C14.3236 5.88818 13.9391 5.76153 13.3169 5.69446C12.681 5.62593 11.8644 5.62508 10.7095 5.62508L9.29041 5.62508C8.13551 5.62508 7.31896 5.62593 6.68307 5.69446ZM7.43411 11.9108C7.75956 11.7958 8.11663 11.9664 8.23166 12.2918C8.48936 13.0209 9.18472 13.5417 10.0001 13.5417C10.8155 13.5417 11.5109 13.0209 11.7686 12.2918C11.8836 11.9664 12.2407 11.7958 12.5662 11.9108C12.8916 12.0258 13.0622 12.3829 12.9472 12.7084C12.5185 13.9213 11.3618 14.7917 10.0001 14.7917C8.63851 14.7917 7.48181 13.9213 7.05311 12.7084C6.93808 12.3829 7.10866 12.0258 7.43411 11.9108Z"
                                                            fill="#1D2977" />
                                                    </svg>
                                                    <svg width="64" height="64" viewBox="0 0 64 64" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <circle cx="32" cy="32" r="32" transform="matrix(-1 0 0 1 64 0)"
                                                            fill="#FFD701" />
                                                    </svg>
                                                </div>
                                            </div>
                                            <div class="shape-cart-popup"></div>
                                        </div>
                                        <div class="cart-mini-products">
                                            <div class="cart-mini-detail-product">
                                                <div class="cart-mini-detail-image-product">
                                                    <div></div>
                                                    <img src="<?php echo get_template_directory_uri() ?>/assets/images/products/chair.png"
                                                        alt="" />
                                                </div>
                                                <a href="#" class="cart-mini-product-details">
                                                    <h5>صندلی دکوری با پارچه ضدلک</h5>
                                                    <div class="cart-mini-detail-product-underline"></div>
                                                    <div class="cart-mini-detail-product-meta">
                                                        <div class="cart-mini-detail-quantity">
                                                            <button class="plus">
                                                                <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                    <path d="M6 10V6M6 6V2M6 6H10M6 6H2" stroke="#1D2977"
                                                                        stroke-width="1.5" stroke-linecap="round"
                                                                        stroke-linejoin="round" />
                                                                </svg>
                                                            </button>
                                                            <input type="text" value="1" min="1" max="100" />
                                                            <button class="mines">
                                                                <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                    <path d="M10 6H2" stroke="#1D2977" stroke-opacity="0.5"
                                                                        stroke-width="1.5" stroke-linecap="round"
                                                                        stroke-linejoin="round" />
                                                                </svg>
                                                            </button>
                                                        </div>
                                                        <div class="cart-mini-detail-amount">
                                                            <div class="price-sales-off">
                                                                <div class="badge">%۳۲</div>
                                                                ۵۶,۰۰۰,۰۰۰ <span></span>
                                                            </div>
                                                            <div class="price-regular">
                                                                <span>تــــو مان</span>
                                                                <span>۱۵۲,۳۰۰,۰۰۰</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                            <div class="cart-mini-detail-product">
                                                <div class="cart-mini-detail-image-product">
                                                    <div></div>
                                                    <img src="<?php echo get_template_directory_uri() ?>/assets/images/products/chair.png"
                                                        alt="" />
                                                </div>
                                                <a href="#" class="cart-mini-product-details">
                                                    <h5>صندلی دکوری با پارچه ضدلک</h5>
                                                    <div class="cart-mini-detail-product-underline"></div>
                                                    <div class="cart-mini-detail-product-meta">
                                                        <div class="cart-mini-detail-quantity">
                                                            <button class="plus">
                                                                <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                    <path d="M6 10V6M6 6V2M6 6H10M6 6H2" stroke="#1D2977"
                                                                        stroke-width="1.5" stroke-linecap="round"
                                                                        stroke-linejoin="round" />
                                                                </svg>
                                                            </button>
                                                            <input type="text" value="1" min="1" max="100" />
                                                            <button class="mines">
                                                                <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                    <path d="M10 6H2" stroke="#1D2977" stroke-opacity="0.5"
                                                                        stroke-width="1.5" stroke-linecap="round"
                                                                        stroke-linejoin="round" />
                                                                </svg>
                                                            </button>
                                                        </div>
                                                        <div class="cart-mini-detail-amount">
                                                            <div class="price-sales-off">
                                                                <div class="badge">%۳۲</div>
                                                                ۵۶,۰۰۰,۰۰۰ <span></span>
                                                            </div>
                                                            <div class="price-regular">
                                                                <span>تــــو مان</span>
                                                                <span>۱۵۲,۳۰۰,۰۰۰</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                        <div class="underline-header-bottom-left-cart-popup"></div>
                                        <div class="total-header-bottom-left-cart-popup">
                                            <div class="total-price-header-bottom-left-cart-popup">
                                                <div></div>
                                                <span class="price-header-bottom-left-cart-popup">۱۵۲,۳۰۰,۰۰۰</span>
                                                <span>تــــــو مــان</span>
                                            </div>
                                            <span class="total-price">جمع سفارش</span>
                                        </div>
                                        <a href="<?php echo esc_url(wc_get_cart_url()) ?>"
                                            class="peyment-header-bottom-left-cart-popup">
                                            <div class="peyment-header-bottom-left-cart-popup-text">
                                                <span>ادامه</span>
                                            </div>
                                            <div class="peyment-header-bottom-left-cart-popup-icon">
                                                <svg width="40" height="40" viewBox="0 0 40 40" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M23.6215 13.6066C23.4648 13.7633 23.2503 13.8623 23.0028 13.8623L13.8623 13.8623L13.8623 23.0029C13.8623 23.4813 13.4663 23.8773 12.9878 23.8773C12.5093 23.8773 12.1134 23.4813 12.1134 23.0029L12.1134 12.9879C12.1134 12.5094 12.5093 12.1134 12.9878 12.1134L23.0028 12.1134C23.4813 12.1134 23.8773 12.5094 23.8773 12.9879C23.8855 13.2271 23.7783 13.4498 23.6215 13.6066Z"
                                                        fill="white" />
                                                    <path
                                                        d="M27.6308 27.6309C27.2926 27.9692 26.7316 27.9692 26.3934 27.6309L12.5093 13.7469C12.1711 13.4087 12.1711 12.8477 12.5093 12.5095C12.8476 12.1712 13.4085 12.1712 13.7468 12.5095L27.6308 26.3935C27.9691 26.7317 27.9691 27.2927 27.6308 27.6309Z"
                                                        fill="white" />
                                                </svg>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="overly-header-bottom-left-cart-popup"></div>
                                    <div class="header-bottom-left-cart-badge-counter">
                                        <span>2</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="header-responsive">
                <div class="navbar-toggle">
                    <svg class="" width="18" height="12" viewBox="0 0 18 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M5 1H17" stroke="#F7F8FD" stroke-width="1.2" stroke-linecap="round" />
                        <path d="M1 6H17" stroke="#F7F8FD" stroke-width="1.2" stroke-linecap="round" />
                        <path d="M11 11H17" stroke="#F7F8FD" stroke-width="1.2" stroke-linecap="round" />
                    </svg>
                    <div class="navbar-toggle-result">
                        <div class="navbar-toggle-search">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M9.16675 2.29167C5.36979 2.29167 2.29175 5.36971 2.29175 9.16667C2.29175 12.9636 5.36979 16.0417 9.16675 16.0417C12.9637 16.0417 16.0417 12.9636 16.0417 9.16667C16.0417 5.36971 12.9637 2.29167 9.16675 2.29167ZM1.04175 9.16667C1.04175 4.67936 4.67943 1.04167 9.16675 1.04167C13.6541 1.04167 17.2917 4.67936 17.2917 9.16667C17.2917 13.654 13.6541 17.2917 9.16675 17.2917C4.67943 17.2917 1.04175 13.654 1.04175 9.16667ZM16.7983 16.4593C16.6054 16.4446 16.4447 16.6053 16.4594 16.7982C16.4596 16.7993 16.4628 16.8207 16.4789 16.8811C16.4979 16.952 16.526 17.0462 16.5691 17.1898C16.6085 17.3214 16.6341 17.4067 16.6552 17.4701C16.6768 17.5349 16.6842 17.5474 16.681 17.5413C16.7689 17.7054 16.9788 17.7583 17.134 17.6556C17.1283 17.6594 17.1407 17.652 17.1905 17.6051C17.2391 17.5593 17.3021 17.4964 17.3993 17.3992C17.4965 17.302 17.5594 17.239 17.6052 17.1904C17.644 17.1491 17.6558 17.1335 17.6565 17.1327C17.7579 16.978 17.7053 16.7697 17.5427 16.6816C17.5417 16.6812 17.524 16.6731 17.4702 16.6552C17.4068 16.6341 17.3215 16.6084 17.1898 16.569C17.0463 16.526 16.9521 16.4978 16.8812 16.4789C16.8207 16.4627 16.7994 16.4595 16.7983 16.4593ZM15.2137 16.9028C15.1344 15.9389 15.939 15.1343 16.9028 15.2137C17.0695 15.2274 17.271 15.288 17.4886 15.3535C17.5085 15.3595 17.5285 15.3656 17.5486 15.3716C17.5668 15.377 17.5849 15.3824 17.6029 15.3878C17.8027 15.4474 17.9902 15.5033 18.1314 15.579C18.9447 16.0144 19.2072 17.055 18.6979 17.8241C18.6094 17.9577 18.4709 18.0958 18.3233 18.2431C18.31 18.2563 18.2966 18.2697 18.2832 18.2831C18.2698 18.2965 18.2564 18.3099 18.2431 18.3232C18.0959 18.4708 17.9577 18.6093 17.8241 18.6978C17.055 19.2071 16.0145 18.9446 15.579 18.1314C15.5034 17.9901 15.4475 17.8027 15.3879 17.6028C15.3825 17.5848 15.3771 17.5667 15.3717 17.5486C15.3656 17.5284 15.3596 17.5084 15.3536 17.4885C15.2881 17.271 15.2274 17.0694 15.2137 16.9028Z"
                                    fill="#020308" fill-opacity="0.64" />
                            </svg>
                            <form role="search" method="get" action="<?php echo esc_url(home_url('/')); ?>">
                                <input type="hidden" name="post_type" value="product" />
                                <input type="text" value="<?php echo get_search_query(); ?>" name="s"
                                    placeholder="<?php
                                                    echo esc_attr(
                                                        __("جست و جو در ", "lamkadeh") . get_bloginfo("name")
                                                    );
                                                    ?>" />
                            </form>
                        </div>
                        <nav class="navbar-sidebar-responsive">
                            <?php lamkadeh_responsive_navbar_menu('primary_menu'); ?>
                            <div class="navbar-sidebar-responsive-contact-us">
                                <div class="navbar-sidebar-responsive-contact-us-right">
                                    <?php
                                    $site_contact_quick_text = get_option("site_contact_quick_text");
                                    $site_contact_quick_tel = get_option("site_contact_quick_tel");
                                    ?>
                                    <span><?php echo esc_html($site_contact_quick_text); ?></span>
                                    <a
                                        href="tel:<?php echo esc_attr($site_contact_quick_tel); ?>"><?php echo esc_html($site_contact_quick_tel); ?></a>
                                </div>
                                <div class="navbar-sidebar-responsive-contact-us-left">
                                    <svg width="28" height="28" viewBox="0 0 28 28" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M5.50398 3.60744C6.93453 2.10135 9.30078 2.38352 10.4833 4.05603L11.9545 6.13677C12.9003 7.47454 12.8204 9.33441 11.6916 10.5229L11.4059 10.8236C11.4051 10.8257 11.4043 10.8279 11.4034 10.8304C11.3883 10.8728 11.3502 11.0079 11.3877 11.2643C11.4656 11.7957 11.8759 12.8757 13.5414 14.6292C15.2123 16.3883 16.2257 16.8029 16.6954 16.8792C16.898 16.9121 17.0039 16.8835 17.0377 16.8716L17.5145 16.3697C18.5339 15.2964 20.1233 15.085 21.4048 15.8227L23.6338 17.1056C25.5388 18.2021 25.9822 20.8845 24.4598 22.4874L22.8025 24.2322C22.2852 24.7768 21.5799 25.2417 20.7083 25.3277C18.5805 25.5377 13.6512 25.2641 8.48354 19.8236C3.66151 14.7469 2.74547 10.3312 2.62967 8.17379L3.40679 8.13207L2.62967 8.17378C2.57246 7.10784 3.04762 6.19353 3.67278 5.53535L5.50398 3.60744ZM9.05439 5.06633C8.45664 4.2209 7.3828 4.17046 6.77283 4.81265L4.94163 6.74056C4.55501 7.1476 4.35215 7.61414 4.37716 8.07999C4.4717 9.84144 5.23025 13.8574 9.75239 18.6184C14.4939 23.6104 18.8622 23.7514 20.5364 23.5861C20.8675 23.5535 21.2081 23.3698 21.5336 23.027L23.1909 21.2822C23.9058 20.5295 23.7184 19.1735 22.7608 18.6223L20.5318 17.3393C19.9337 16.9951 19.233 17.1015 18.7833 17.5749L18.252 18.1343L17.6369 17.5501C18.252 18.1343 18.2512 18.1352 18.2504 18.136L18.2487 18.1377L18.2452 18.1413L18.2378 18.1488L18.2211 18.1653C18.2091 18.177 18.1952 18.1898 18.1795 18.2035C18.1482 18.231 18.1094 18.2624 18.0627 18.2955C17.9693 18.3617 17.8448 18.4346 17.6874 18.4967C17.3654 18.6237 16.9402 18.6919 16.4148 18.6065C15.3911 18.4403 14.0493 17.7049 12.2726 15.8344C10.4907 13.9584 9.8087 12.5588 9.65621 11.518C9.57859 10.9882 9.64071 10.564 9.75469 10.2437C9.81075 10.0862 9.87694 9.96055 9.93797 9.86516C9.96841 9.8176 9.99742 9.77777 10.0231 9.74536C10.0359 9.72916 10.0479 9.71481 10.0588 9.70226L10.0743 9.68477L10.0815 9.67703L10.0848 9.67341L10.0865 9.67166C10.0873 9.67081 10.0881 9.66996 10.7084 10.2591L10.0881 9.66995L10.4227 9.31766C10.9425 8.77042 11.018 7.84363 10.5255 7.14706L9.05439 5.06633Z"
                                            fill="#1D2977" />
                                        <path
                                            d="M15.4696 2.19342C15.5468 1.71638 15.9978 1.39278 16.4748 1.47001C16.5043 1.47566 16.5993 1.49342 16.6491 1.50451C16.7487 1.52668 16.8875 1.56081 17.0607 1.61124C17.4069 1.71209 17.8906 1.87823 18.4712 2.14439C19.6335 2.67727 21.1803 3.60944 22.7854 5.21454C24.3905 6.81964 25.3226 8.36642 25.8555 9.52875C26.1217 10.1093 26.2878 10.593 26.3887 10.9392C26.4391 11.1124 26.4732 11.2512 26.4954 11.3508C26.5065 11.4006 26.5146 11.4405 26.5202 11.4701L26.527 11.5065C26.6042 11.9835 26.2835 12.4531 25.8065 12.5303C25.3308 12.6074 24.8827 12.2853 24.8036 11.8105C24.8011 11.7978 24.7944 11.7635 24.7873 11.7312C24.7729 11.6666 24.748 11.5641 24.7085 11.4286C24.6295 11.1576 24.4924 10.7547 24.2647 10.2581C23.8099 9.26604 22.9921 7.89615 21.5479 6.45198C20.1038 5.00781 18.7339 4.18998 17.7419 3.73518C17.2452 3.50749 16.8423 3.37037 16.5713 3.29142C16.4358 3.25195 16.2654 3.21285 16.2008 3.19846C15.726 3.11934 15.3926 2.6691 15.4696 2.19342Z"
                                            fill="#1D2977" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M15.7338 6.21785C15.8666 5.7532 16.3509 5.48414 16.8156 5.6169L16.5752 6.45823C16.8156 5.6169 16.816 5.61702 16.8164 5.61714L16.8172 5.61738L16.819 5.6179L16.8229 5.61903L16.832 5.62173L16.855 5.62892C16.8726 5.63455 16.8946 5.64188 16.9208 5.65117C16.9732 5.66976 17.0424 5.69621 17.1274 5.73261C17.2973 5.80545 17.5296 5.91794 17.8149 6.08677C18.3859 6.42473 19.1654 6.98611 20.0812 7.90191C20.997 8.81771 21.5584 9.59726 21.8964 10.1683C22.0652 10.4536 22.1777 10.6858 22.2505 10.8558C22.2869 10.9407 22.3134 11.01 22.332 11.0624C22.3413 11.0886 22.3486 11.1105 22.3542 11.1281L22.3614 11.1512L22.3641 11.1602L22.3653 11.1641L22.3658 11.1659L22.366 11.1668C22.3661 11.1672 22.3663 11.1676 21.5249 11.408L22.3663 11.1676C22.499 11.6323 22.23 12.1166 21.7653 12.2493C21.3046 12.3809 20.8246 12.1176 20.687 11.6602L20.6827 11.6476C20.6765 11.63 20.6636 11.5955 20.642 11.5451C20.5989 11.4444 20.5206 11.2796 20.3904 11.0596C20.1302 10.6201 19.6604 9.95596 18.8438 9.13935C18.0272 8.32273 17.3631 7.85291 16.9235 7.59278C16.7035 7.46256 16.5388 7.38428 16.438 7.34111C16.3876 7.31951 16.3531 7.30664 16.3356 7.30042L16.323 7.29611C15.8656 7.15858 15.6022 6.67856 15.7338 6.21785Z"
                                            fill="#1D2977" />
                                    </svg>

                                </div>
                            </div>
                        </nav>
                    </div>
                    <div class="close-navbar-toggle">
                        <svg width="39" height="39" viewBox="0 0 34 34" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_1_2097)">
                                <path
                                    d="M19.6224 15.3796C19.9152 15.0867 19.9152 14.6118 19.6224 14.3189C19.3295 14.026 18.8546 14.026 18.5617 14.3189L16.9707 15.9099L15.3797 14.3189C15.0868 14.026 14.6119 14.026 14.319 14.3189C14.0261 14.6118 14.0261 15.0867 14.319 15.3796L15.91 16.9706L14.3191 18.5616C14.0262 18.8544 14.0262 19.3293 14.3191 19.6222C14.6119 19.9151 15.0868 19.9151 15.3797 19.6222L16.9707 18.0312L18.5617 19.6222C18.8546 19.9151 19.3294 19.9151 19.6223 19.6222C19.9152 19.3293 19.9152 18.8545 19.6223 18.5616L18.0313 16.9706L19.6224 15.3796Z"
                                    fill="#F7F8FD" />
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M24.5721 9.36917C20.374 5.17103 13.5674 5.17103 9.36931 9.36917C5.17117 13.5673 5.17117 20.3738 9.36931 24.572C13.5674 28.7701 20.374 28.7701 24.5721 24.572C28.7702 20.3738 28.7702 13.5673 24.5721 9.36917ZM10.43 10.4298C14.0423 6.81748 19.8991 6.81748 23.5114 10.4298C27.1238 14.0422 27.1238 19.899 23.5114 23.5113C19.8991 27.1237 14.0423 27.1237 10.43 23.5113C6.81762 19.899 6.81762 14.0422 10.43 10.4298Z"
                                    fill="#F7F8FD" />
                            </g>
                            <defs>
                                <clipPath id="clip0_1_2097">
                                    <rect width="24" height="24" fill="white" transform="translate(16.9707) rotate(45)" />
                                </clipPath>
                            </defs>
                        </svg>
                    </div>
                    <div class="navbar-toggle-overly"></div>
                </div>
                <div class="logo-responsive">
                    <a href="<?php echo esc_url(home_url('/')); ?>" class="header-logo">
                        <?php
                        $logo = get_option('site_logo_theme');
                        $logo_width = intval(get_option('site_logo_width')) / 2;
                        $logo_height = intval(get_option('site_logo_height')) / 2;

                        if ($logo) {
                            echo '<img src="' . esc_url($logo) . '" ' .
                                'width="' . esc_attr(($logo_width > 0) ? $logo_width : 'auto') . '" ' .
                                'height="' . esc_attr(($logo_height > 0) ? $logo_height : 'auto') . '" ' .
                                'class="logo-header" alt="' . esc_attr(get_bloginfo('name')) . '">';
                        } else {
                            echo '<span class="site-title">' . esc_html(get_bloginfo('name')) . '</span>';
                        }
                        ?>
                    </a>
                    <div class="logo-responsive-name">
                        <?php
                        $site_text_one = get_option("site_text_one");
                        $site_text_two = get_option("site_text_two");
                        ?>
                        <span><?php echo esc_html($site_text_one); ?></span>
                        <span><?php echo esc_html($site_text_two); ?></span>
                    </div>
                </div>
                <a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="cart-mini-responsive">
                    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" clip-rule="evenodd"
                            d="M8.99993 2.0625C8.06795 2.0625 7.31243 2.81802 7.31243 3.75V3.94086C7.62555 3.93749 7.96358 3.9375 8.32886 3.9375L9.671 3.9375C10.0363 3.9375 10.3743 3.93749 10.6874 3.94086V3.75C10.6874 2.81802 9.93191 2.0625 8.99993 2.0625ZM11.8124 3.9802V3.75C11.8124 2.1967 10.5532 0.9375 8.99993 0.9375C7.44663 0.9375 6.18743 2.1967 6.18743 3.75V3.9802C6.08618 3.98759 5.98847 3.99626 5.89416 4.00642C5.23539 4.07742 4.68448 4.22616 4.19526 4.56148C4.027 4.67681 3.86896 4.80637 3.72287 4.94875C3.29813 5.36271 3.04423 5.87374 2.84541 6.50579C2.65238 7.11944 2.49638 7.8995 2.30035 8.87969L2.28604 8.95123C2.00356 10.3636 1.78096 11.4765 1.71703 12.363C1.65171 13.2687 1.74299 14.0306 2.17202 14.691C2.31517 14.9113 2.48224 15.1151 2.67021 15.2987C3.23356 15.8488 3.96282 16.0878 4.86376 16.2014C5.74553 16.3125 6.88051 16.3125 8.32083 16.3125H9.67902C11.1193 16.3125 12.2543 16.3125 13.1361 16.2014C14.037 16.0878 14.7663 15.8488 15.3296 15.2987C15.5176 15.1151 15.6847 14.9113 15.8278 14.691C16.2569 14.0306 16.3481 13.2687 16.2828 12.363C16.2189 11.4765 15.9963 10.3636 15.7138 8.95129L15.6995 8.87972C15.5035 7.89951 15.3475 7.11944 15.1544 6.50579C14.9556 5.87374 14.7017 5.36271 14.277 4.94875C14.1309 4.80637 13.9729 4.6768 13.8046 4.56148C13.3154 4.22616 12.7645 4.07742 12.1057 4.00642C12.0114 3.99626 11.9137 3.98759 11.8124 3.9802ZM6.01471 5.12494C5.45468 5.1853 5.1087 5.29929 4.83129 5.48943C4.71616 5.56834 4.60803 5.65699 4.50807 5.75441C4.26722 5.98914 4.08759 6.30605 3.91857 6.84337C3.74585 7.39246 3.60098 8.11294 3.39713 9.13216C3.10498 10.5929 2.89735 11.6365 2.83912 12.4439C2.78168 13.2403 2.87867 13.7137 3.11538 14.078C3.21332 14.2288 3.32764 14.3682 3.45625 14.4938C3.76708 14.7974 4.21223 14.9853 5.00447 15.0852C5.80764 15.1864 6.87161 15.1875 8.36132 15.1875H9.63853C11.1282 15.1875 12.1922 15.1864 12.9954 15.0852C13.7876 14.9853 14.2328 14.7974 14.5436 14.4938C14.6722 14.3682 14.7865 14.2288 14.8845 14.078C15.1212 13.7137 15.2182 13.2403 15.1607 12.4439C15.1025 11.6365 14.8949 10.5929 14.6027 9.13216C14.3989 8.11294 14.254 7.39246 14.0813 6.84337C13.9123 6.30605 13.7326 5.98914 13.4918 5.75441C13.3918 5.65699 13.2837 5.56834 13.1686 5.48943C12.8912 5.29929 12.5452 5.1853 11.9851 5.12494C11.4128 5.06326 10.6779 5.0625 9.63853 5.0625H8.36132C7.32191 5.0625 6.58701 5.06326 6.01471 5.12494ZM6.69065 10.7197C6.98355 10.6161 7.30492 10.7696 7.40845 11.0625C7.64037 11.7187 8.2662 12.1875 9.00007 12.1875C9.73394 12.1875 10.3598 11.7187 10.5917 11.0625C10.6952 10.7696 11.0166 10.6161 11.3095 10.7197C11.6024 10.8232 11.7559 11.1445 11.6524 11.4375C11.2666 12.5291 10.2255 13.3125 9.00007 13.3125C7.77461 13.3125 6.73358 12.5291 6.34775 11.4375C6.24423 11.1445 6.39775 10.8232 6.69065 10.7197Z"
                            fill="#020308" fill-opacity="0.64" />
                    </svg>
                    <div class="cart-mini-responsive-counter">
                        <span>0</span>
                    </div>
                </a>
            </div>
        <?php endif; ?>
    </header>