<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit;

class Main_Category extends Widget_Base
{
    public function get_name()
    {
        return 'Main_Category';
    }

    public function get_title()
    {
        return __('دسته‌بندی لمکده', 'lamkadeh');
    }

    public function get_icon()
    {
        return 'eicon-product-categories';
    }

    public function get_categories()
    {
        return ['lamkadeh'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'category_widget_settings',
            [
                'label' => __('تنظیمات دسته بندی‌ها', 'lamkadeh'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'categories_title',
            [
                'label' => __('عنوان دسته بندی ها', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('دسته بندی محصولات', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'categories_title_en',
            [
                'label' => __('عنوان انگلیسی دسته بندی ها', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Categories', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'categories_description',
            [
                'label' => __('توضیحات دسته بندی', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => __('توضیحات کوتاه درباره دسته بندی ها', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'categories_link_text',
            [
                'label' => __('متن لینک مشاهده دسته بندی ها', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('مشاهده همه', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'categories_link_url',
            [
                'label' => __('لینک مشاهده همه دسته بندی ها', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::URL,
                'show_external' => true,
                'default' => ['url' => '', 'is_external' => true, 'nofollow' => true],
            ]
        );

        $this->add_control(
            'use_wc_categories',
            [
                'label' => __('استفاده از دسته بندی ووکامرس', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('بله', 'lamkadeh'),
                'label_off' => __('خیر', 'lamkadeh'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $repeater_manual = new \Elementor\Repeater();
        $repeater_manual->add_control(
            'category_title',
            [
                'label' => __('عنوان دسته بندی', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('عنوان دسته بندی', 'lamkadeh'),
            ]
        );
        $repeater_manual->add_control(
            'category_description',
            [
                'label' => __('توضیحات دسته بندی', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => __('توضیحات کوتاه دسته بندی', 'lamkadeh'),
            ]
        );
        $repeater_manual->add_control(
            'category_image',
            [
                'label' => __('تصویر دسته بندی', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $repeater_manual->add_control(
            'category_link',
            [
                'label' => __('لینک دسته بندی', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://example.com/category/', 'lamkadeh'),
                'show_external' => true,
            ]
        );

        $repeater_wc = new \Elementor\Repeater();
        $repeater_wc->add_control(
            'wc_category',
            [
                'label' => __('انتخاب دسته بندی ووکامرس', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => $this->get_product_categories(),
                'multiple' => false,
            ]
        );

        $this->add_control(
            'categories_manual',
            [
                'label' => __('دسته بندی دستی', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater_manual->get_controls(),
                'default' => [
                    ['category_title' => __('دسته بندی 1', 'lamkadeh')],
                    ['category_title' => __('دسته بندی 2', 'lamkadeh')],
                ],
                'condition' => ['use_wc_categories!' => 'yes'],
                'title_field' => '{{{ category_title }}}',
                'max' => 5,
            ]
        );

        $this->add_control(
            'categories_wc',
            [
                'label' => __('دسته بندی ووکامرس', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater_wc->get_controls(),
                'condition' => ['use_wc_categories' => 'yes'],
                'title_field' => '{{{ wc_category }}}',
                'max' => 5,
            ]
        );

        $this->add_control(
            'category_duration',
            [
                'label' => __('زمان نمایش دسته‌بندی ها (میلی‌ثانیه)', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 5000,
                'min' => 1000,
                'step' => 500,
                'description' => __('زمان نمایش این دسته‌بندی قبل از رفتن به دسته‌بندی بعدی', 'lamkadeh'),
            ]
        );

        $this->end_controls_section();
    }

    private function get_product_categories()
    {
        $terms = get_terms('product_cat', ['hide_empty' => false]);
        $categories = [];
        foreach ($terms as $term) {
            $categories[$term->term_id] = $term->name;
        }
        return $categories;
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $categories = [];

        if ($settings['use_wc_categories'] === 'yes') {
            $categories = $settings['categories_wc'] ?? [];
        } else {
            $categories = $settings['categories_manual'] ?? [];
        }
        $categories = array_slice($categories, 0, 5);
        ?>
        <section class="categories-main-lamkadeh container">
            <div class="header-categories-main">
                <div class="title-header-categories-main">
                    <span><?php echo esc_html($settings['categories_title_en']) ?></span>
                    <div class="text-header-categories-main">
                        <span><?php echo esc_html($settings['categories_title']) ?></span>
                        <svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_1_3057)">
                                <circle cx="32" cy="32" r="32" transform="matrix(-1 0 0 1 64 0)" fill="#FFD701" />
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M37.2878 12.1459C37.3151 12.1459 37.3428 12.1459 37.3708 12.1459L37.4047 12.1459C37.7268 12.1459 37.9341 12.1459 38.1368 12.1648C38.9635 12.2421 39.7499 12.5541 40.4039 13.0626H46.1252C46.1431 13.0626 46.1608 13.0626 46.1782 13.0626C46.5528 13.0625 46.808 13.0624 47.0322 13.092C48.5747 13.295 49.7885 14.5089 49.9916 16.0514C49.9993 16.1095 50.0049 16.1697 50.0091 16.2336C50.2635 16.3495 50.499 16.4994 50.7156 16.6942C50.8057 16.7753 50.8916 16.8611 50.9727 16.9513C51.4569 17.4897 51.6638 18.1451 51.7608 18.9164C51.8544 19.6606 51.8544 20.6013 51.8543 21.7681V23.8851C51.8544 25.5697 51.8544 26.904 51.714 27.9483C51.5695 29.023 51.265 29.8929 50.579 30.5789C49.893 31.2649 49.0232 31.5694 47.9485 31.7139C46.9042 31.8542 45.5698 31.8542 43.8852 31.8542H40.1151C38.4305 31.8542 37.0962 31.8542 36.0519 31.7139C34.9772 31.5694 34.1073 31.2649 33.4213 30.5789C32.7353 29.8929 32.4309 29.023 32.2864 27.9483C32.146 26.904 32.146 25.5697 32.146 23.8851L32.146 17.3707C32.146 17.3426 32.146 17.315 32.146 17.2877C32.1459 16.5581 32.1458 16.0938 32.2215 15.6928C32.5538 13.9314 33.9316 12.5537 35.6929 12.2214C36.0939 12.1457 36.5583 12.1458 37.2878 12.1459ZM48.5519 15.8838C48.3155 15.1277 47.659 14.5613 46.8527 14.4552C46.73 14.439 46.5727 14.4376 46.1252 14.4376H41.8272C42.4165 15.0234 42.6839 15.268 42.9872 15.4368C43.187 15.5479 43.399 15.6357 43.619 15.6984C43.9978 15.8064 44.4132 15.8126 45.5096 15.8126L45.8988 15.8126C46.9642 15.8125 47.841 15.8125 48.5519 15.8838ZM37.3708 13.5209C36.5305 13.5209 36.2057 13.5239 35.9478 13.5725C34.7427 13.7999 33.8 14.7426 33.5727 15.9477C33.524 16.2055 33.521 16.5304 33.521 17.3707V23.8334C33.521 25.5813 33.5225 26.8231 33.6491 27.7651C33.7731 28.6874 34.0056 29.2187 34.3936 29.6066C34.7815 29.9946 35.3129 30.2271 36.2351 30.3511C37.1771 30.4778 38.4189 30.4792 40.1668 30.4792H43.8335C45.5814 30.4792 46.8232 30.4778 47.7652 30.3511C48.6875 30.2271 49.2188 29.9946 49.6068 29.6066C49.9947 29.2187 50.2272 28.6874 50.3512 27.7651C50.4779 26.8231 50.4793 25.5813 50.4793 23.8334V21.8148C50.4793 20.5903 50.4781 19.7363 50.3965 19.0879C50.3172 18.4566 50.1714 18.1166 49.9503 17.8708C49.9017 17.8167 49.8502 17.7652 49.7961 17.7166C49.5503 17.4955 49.2103 17.3497 48.579 17.2704C47.9306 17.1888 47.0766 17.1876 45.8521 17.1876H45.5096C45.4755 17.1876 45.4418 17.1876 45.4085 17.1876C44.4479 17.1878 43.8284 17.1879 43.242 17.0208C42.9206 16.9291 42.6108 16.8008 42.3187 16.6383C41.7859 16.3419 41.348 15.9037 40.6688 15.2243C40.6453 15.2008 40.6215 15.177 40.5974 15.1529L40.093 14.6485C39.8333 14.3888 39.734 14.2904 39.6327 14.2065C39.1714 13.824 38.6054 13.5896 38.0088 13.5338C37.8778 13.5216 37.738 13.5209 37.3708 13.5209ZM42.2293 20.1667C42.2293 19.787 42.5371 19.4792 42.9168 19.4792H47.5002C47.8799 19.4792 48.1877 19.787 48.1877 20.1667C48.1877 20.5464 47.8799 20.8542 47.5002 20.8542H42.9168C42.5371 20.8542 42.2293 20.5464 42.2293 20.1667Z"
                                    fill="#1D2977" />
                                <circle cx="22" cy="60" r="17" fill="#F7F8FD" fill-opacity="0.64" />
                            </g>
                            <defs>
                                <clipPath id="clip0_1_3057">
                                    <rect width="64" height="64" rx="32" fill="white" />
                                </clipPath>
                            </defs>
                        </svg>
                    </div>
                    <div class="shape-header-categories-main"></div>
                </div>
                <div class="line-header-categories-main"></div>
                <p class="description-header-categories-main">
                    <?php echo wp_kses($settings['categories_description'], [
                        'a' => ['href' => [], 'title' => [], 'target' => []],
                        'br' => [],
                        'strong' => [],
                        'em' => [],
                        'b' => [],
                        'i' => [],
                        'span' => ['class' => []],
                    ]); ?>
                </p>
                <div class="line-header-categories-main-two"></div>
                <a href="<?php echo esc_url($settings['categories_link_url']['url']) ?>"
                    class="show-more-header-categories-main">
                    <div>
                        <span><?php echo esc_html($settings['categories_link_text']) ?></span>
                    </div>
                    <div>
                        <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M23.6216 13.6066C23.4648 13.7633 23.2504 13.8623 23.0029 13.8623L13.8623 13.8623L13.8623 23.0029C13.8623 23.4813 13.4664 23.8773 12.9879 23.8773C12.5094 23.8773 12.1134 23.4813 12.1134 23.0029L12.1134 12.9879C12.1134 12.5094 12.5094 12.1134 12.9879 12.1134L23.0029 12.1134C23.4813 12.1134 23.8773 12.5094 23.8773 12.9879C23.8856 13.2271 23.7783 13.4498 23.6216 13.6066Z"
                                fill="white" />
                            <path
                                d="M27.6308 27.6308C27.2926 27.969 26.7316 27.969 26.3934 27.6308L12.5093 13.7468C12.1711 13.4085 12.1711 12.8476 12.5093 12.5093C12.8476 12.1711 13.4085 12.1711 13.7468 12.5093L27.6308 26.3934C27.9691 26.7316 27.9691 27.2926 27.6308 27.6308Z"
                                fill="white" />
                        </svg>
                    </div>
                </a>
            </div>
            <div class="body-categories-main">
                <?php foreach ($categories as $cat):
                    echo '<div class="body-categories-main-item">';
                    if ($settings['use_wc_categories'] === 'yes' && !empty($cat['wc_category'])):
                        $term = get_term($cat['wc_category'], 'product_cat');
                        $cat_link = get_term_link((int) $term['category_id'], 'product_cat');
                        ?>
                        <div class="rectangle-categories-main-item"></div>
                        <span class="counter-categories-main-item"></span>
                        <div class="line-categories-main-item"></div>
                        <a href="<?php echo esc_url($cat_link) ?>"
                            class="name-categories-main-item"><?php echo esc_html($term->name) ?></a>
                        <div class="content-categories-main-item">
                            <div class="top-content-categories-main-item">
                                <div class="title-category-main">
                                    <div class="shape-category-main"></div>
                                    <a href="<?php echo esc_url($cat_link) ?>" class="subtitle-category-main"><?php echo esc_html($term->name) ?></a>
                                    <div class="counter-product-category-main">
                                        <span><?php echo intval($term->count) ?>                 <?php echo __("محصول موجود است.", "lamkadeh") ?></span>
                                    </div>
                                </div>
                                <a href="<?php echo esc_url($cat_link) ?>" class="button-show-categories">
                                    <svg width="40" height="41" viewBox="0 0 40 41" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M23.6216 14.1066C23.4648 14.2633 23.2504 14.3623 23.0029 14.3623L13.8623 14.3623L13.8623 23.5029C13.8623 23.9813 13.4664 24.3773 12.9879 24.3773C12.5094 24.3773 12.1134 23.9813 12.1134 23.5029L12.1134 13.4879C12.1134 13.0094 12.5094 12.6134 12.9879 12.6134L23.0029 12.6134C23.4813 12.6134 23.8773 13.0094 23.8773 13.4879C23.8856 13.7271 23.7783 13.9498 23.6216 14.1066Z"
                                            fill="#1D2977" />
                                        <path
                                            d="M27.6308 28.1308C27.2926 28.469 26.7316 28.469 26.3934 28.1308L12.5093 14.2468C12.1711 13.9085 12.1711 13.3476 12.5093 13.0093C12.8476 12.6711 13.4085 12.6711 13.7468 13.0093L27.6308 26.8934C27.9691 27.2316 27.9691 27.7926 27.6308 28.1308Z"
                                            fill="#1D2977" />
                                    </svg>
                                </a>
                            </div>
                            <div class="bottom-content-categories-main-item">
                                <?php
                                $thumbnail_id = get_term_meta($term->term_id, 'thumbnail_id', true);
                                if ($thumbnail_id) {
                                    $image_url = wp_get_attachment_url($thumbnail_id);
                                    if ($image_url) {
                                        echo '<img src="' . esc_url($image_url) . '" alt="' . esc_attr($term->name) . '">';
                                    }
                                }
                                ?>
                                <div class="circle-one-bottom-content-categories-main-item"></div>
                                <div class="circle-two-bottom-content-categories-main-item"></div>
                                <div class="circle-three-bottom-content-categories-main-item">
                                    <svg width="51" height="49" viewBox="0 0 51 49" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M11.5909 22.1965C10.3106 22.1965 9.27273 21.2027 9.27273 19.9768C9.27273 18.7509 10.3106 17.7571 11.5909 17.7571C12.8712 17.7571 13.9091 18.7509 13.9091 19.9768C13.9091 21.2027 12.8712 22.1965 11.5909 22.1965Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M30.1364 22.1965C28.8561 22.1965 27.8182 21.2027 27.8182 19.9768C27.8182 18.7509 28.8561 17.7571 30.1364 17.7571C31.4167 17.7571 32.4545 18.7509 32.4545 19.9768C32.4545 21.2027 31.4167 22.1965 30.1364 22.1965Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M39.4091 22.1965C38.1288 22.1965 37.0909 21.2027 37.0909 19.9768C37.0909 18.7509 38.1288 17.7571 39.4091 17.7571C40.6894 17.7571 41.7273 18.7509 41.7273 19.9768C41.7273 21.2027 40.6894 22.1965 39.4091 22.1965Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M2.31818 13.3178C1.03789 13.3178 4.55814e-07 12.3241 4.00514e-07 11.0982C3.45215e-07 9.87229 1.03789 8.87851 2.31818 8.87851C3.59848 8.87851 4.63636 9.87229 4.63636 11.0982C4.63636 12.3241 3.59848 13.3178 2.31818 13.3178Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M11.5909 13.3178C10.3106 13.3178 9.27273 12.3241 9.27273 11.0982C9.27273 9.87229 10.3106 8.87851 11.5909 8.87851C12.8712 8.87851 13.9091 9.87229 13.9091 11.0982C13.9091 12.3241 12.8712 13.3178 11.5909 13.3178Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M20.8636 13.3178C19.5833 13.3178 18.5455 12.3241 18.5455 11.0982C18.5455 9.87229 19.5833 8.87851 20.8636 8.87851C22.1439 8.87851 23.1818 9.87229 23.1818 11.0982C23.1818 12.3241 22.1439 13.3178 20.8636 13.3178Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M39.4091 13.3178C38.1288 13.3178 37.0909 12.3241 37.0909 11.0982C37.0909 9.87229 38.1288 8.87851 39.4091 8.87851C40.6894 8.87851 41.7273 9.87228 41.7273 11.0982C41.7273 12.3241 40.6894 13.3178 39.4091 13.3178Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M48.6818 13.3178C47.4015 13.3178 46.3636 12.3241 46.3636 11.0982C46.3636 9.87228 47.4015 8.87851 48.6818 8.87851C49.9621 8.87851 51 9.87228 51 11.0982C51 12.3241 49.9621 13.3178 48.6818 13.3178Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M2.31818 4.4392C1.03789 4.4392 5.52996e-08 3.44542 0 2.21954C-5.52996e-08 0.993654 1.03789 -0.000120052 2.31818 -0.000120107C3.59848 -0.000120161 4.63636 0.993654 4.63636 2.21954C4.63636 3.44542 3.59848 4.4392 2.31818 4.4392Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M20.8636 4.43919C19.5833 4.43919 18.5455 3.44542 18.5455 2.21954C18.5455 0.993653 19.5833 -0.000120838 20.8636 -0.000120892C22.1439 -0.000120946 23.1818 0.993653 23.1818 2.21954C23.1818 3.44542 22.1439 4.43919 20.8636 4.43919Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M30.1364 4.43919C28.8561 4.43919 27.8182 3.44542 27.8182 2.21954C27.8182 0.993653 28.8561 -0.000121231 30.1364 -0.000121285C31.4167 -0.000121339 32.4545 0.993653 32.4545 2.21954C32.4545 3.44542 31.4167 4.43919 30.1364 4.43919Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M39.4091 4.43919C38.1288 4.43919 37.0909 3.44542 37.0909 2.21954C37.0909 0.993653 38.1288 -0.000121623 39.4091 -0.000121678C40.6894 -0.000121732 41.7273 0.993652 41.7273 2.21954C41.7273 3.44542 40.6894 4.43919 39.4091 4.43919Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M48.6818 4.43919C47.4015 4.43919 46.3636 3.44542 46.3636 2.21954C46.3636 0.993652 47.4015 -0.000122016 48.6818 -0.00012207C49.9621 -0.000122125 51 0.993652 51 2.21954C51 3.44542 49.9621 4.43919 48.6818 4.43919Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M30.1364 13.3178C28.8561 13.3178 27.8182 12.3241 27.8182 11.0982C27.8182 9.87229 28.8561 8.87851 30.1364 8.87851C31.4167 8.87851 32.4545 9.87229 32.4545 11.0982C32.4545 12.3241 31.4167 13.3178 30.1364 13.3178Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M11.5909 4.43919C10.3106 4.43919 9.27273 3.44542 9.27273 2.21954C9.27273 0.993654 10.3106 -0.000120445 11.5909 -0.000120499C12.8712 -0.000120554 13.9091 0.993653 13.9091 2.21954C13.9091 3.44542 12.8712 4.43919 11.5909 4.43919Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M20.8636 22.1965C19.5833 22.1965 18.5455 21.2027 18.5455 19.9768C18.5455 18.7509 19.5833 17.7571 20.8636 17.7571C22.1439 17.7571 23.1818 18.7509 23.1818 19.9768C23.1818 21.2027 22.1439 22.1965 20.8636 22.1965Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M48.6818 22.1965C47.4015 22.1965 46.3636 21.2027 46.3636 19.9768C46.3636 18.7509 47.4015 17.7571 48.6818 17.7571C49.9621 17.7571 51 18.7509 51 19.9768C51 21.2027 49.9621 22.1965 48.6818 22.1965Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M2.31818 22.1965C1.03789 22.1965 8.56329e-07 21.2027 8.0103e-07 19.9768C7.4573e-07 18.7509 1.03789 17.7571 2.31818 17.7571C3.59848 17.7571 4.63636 18.7509 4.63636 19.9768C4.63636 21.2027 3.59848 22.1965 2.31818 22.1965Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M11.5909 48.9999C10.3106 48.9999 9.27273 48.0061 9.27273 46.7802C9.27273 45.5543 10.3106 44.5606 11.5909 44.5606C12.8712 44.5606 13.9091 45.5543 13.9091 46.7802C13.9091 48.0061 12.8712 48.9999 11.5909 48.9999Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M30.1364 48.9999C28.8561 48.9999 27.8182 48.0061 27.8182 46.7802C27.8182 45.5543 28.8561 44.5606 30.1364 44.5606C31.4167 44.5606 32.4545 45.5543 32.4545 46.7802C32.4545 48.0061 31.4167 48.9999 30.1364 48.9999Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M39.4091 48.9999C38.1288 48.9999 37.0909 48.0061 37.0909 46.7802C37.0909 45.5543 38.1288 44.5606 39.4091 44.5606C40.6894 44.5606 41.7273 45.5543 41.7273 46.7802C41.7273 48.0061 40.6894 48.9999 39.4091 48.9999Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M2.31818 40.1213C1.03789 40.1213 4.55814e-07 39.1275 4.00514e-07 37.9016C3.45215e-07 36.6757 1.03789 35.6819 2.31818 35.6819C3.59848 35.6819 4.63636 36.6757 4.63636 37.9016C4.63636 39.1275 3.59848 40.1213 2.31818 40.1213Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M11.5909 40.1213C10.3106 40.1213 9.27273 39.1275 9.27273 37.9016C9.27273 36.6757 10.3106 35.6819 11.5909 35.6819C12.8712 35.6819 13.9091 36.6757 13.9091 37.9016C13.9091 39.1275 12.8712 40.1213 11.5909 40.1213Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M20.8636 40.1213C19.5833 40.1213 18.5455 39.1275 18.5455 37.9016C18.5455 36.6757 19.5833 35.6819 20.8636 35.6819C22.1439 35.6819 23.1818 36.6757 23.1818 37.9016C23.1818 39.1275 22.1439 40.1213 20.8636 40.1213Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M39.4091 40.1212C38.1288 40.1212 37.0909 39.1275 37.0909 37.9016C37.0909 36.6757 38.1288 35.6819 39.4091 35.6819C40.6894 35.6819 41.7273 36.6757 41.7273 37.9016C41.7273 39.1275 40.6894 40.1212 39.4091 40.1212Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M48.6818 40.1212C47.4015 40.1212 46.3636 39.1275 46.3636 37.9016C46.3636 36.6757 47.4015 35.6819 48.6818 35.6819C49.9621 35.6819 51 36.6757 51 37.9016C51 39.1275 49.9621 40.1212 48.6818 40.1212Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M2.31818 31.2426C1.03789 31.2426 5.52996e-08 30.2488 0 29.023C-5.52996e-08 27.7971 1.03789 26.8033 2.31818 26.8033C3.59848 26.8033 4.63636 27.7971 4.63636 29.023C4.63636 30.2488 3.59848 31.2426 2.31818 31.2426Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M20.8636 31.2426C19.5833 31.2426 18.5455 30.2488 18.5455 29.023C18.5455 27.7971 19.5833 26.8033 20.8636 26.8033C22.1439 26.8033 23.1818 27.7971 23.1818 29.023C23.1818 30.2488 22.1439 31.2426 20.8636 31.2426Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M30.1364 31.2426C28.8561 31.2426 27.8182 30.2488 27.8182 29.023C27.8182 27.7971 28.8561 26.8033 30.1364 26.8033C31.4167 26.8033 32.4545 27.7971 32.4545 29.023C32.4545 30.2488 31.4167 31.2426 30.1364 31.2426Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M39.4091 31.2426C38.1288 31.2426 37.0909 30.2488 37.0909 29.023C37.0909 27.7971 38.1288 26.8033 39.4091 26.8033C40.6894 26.8033 41.7273 27.7971 41.7273 29.023C41.7273 30.2488 40.6894 31.2426 39.4091 31.2426Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M48.6818 31.2426C47.4015 31.2426 46.3636 30.2488 46.3636 29.023C46.3636 27.7971 47.4015 26.8033 48.6818 26.8033C49.9621 26.8033 51 27.7971 51 29.023C51 30.2488 49.9621 31.2426 48.6818 31.2426Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M30.1364 40.1212C28.8561 40.1212 27.8182 39.1275 27.8182 37.9016C27.8182 36.6757 28.8561 35.6819 30.1364 35.6819C31.4167 35.6819 32.4545 36.6757 32.4545 37.9016C32.4545 39.1275 31.4167 40.1212 30.1364 40.1212Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M11.5909 31.2426C10.3106 31.2426 9.27273 30.2488 9.27273 29.023C9.27273 27.7971 10.3106 26.8033 11.5909 26.8033C12.8712 26.8033 13.9091 27.7971 13.9091 29.023C13.9091 30.2488 12.8712 31.2426 11.5909 31.2426Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M20.8636 48.9999C19.5833 48.9999 18.5455 48.0061 18.5455 46.7802C18.5455 45.5543 19.5833 44.5606 20.8636 44.5606C22.1439 44.5606 23.1818 45.5543 23.1818 46.7802C23.1818 48.0061 22.1439 48.9999 20.8636 48.9999Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M48.6818 48.9999C47.4015 48.9999 46.3636 48.0061 46.3636 46.7802C46.3636 45.5543 47.4015 44.5606 48.6818 44.5606C49.9621 44.5606 51 45.5543 51 46.7802C51 48.0061 49.9621 48.9999 48.6818 48.9999Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M2.31818 48.9999C1.03789 48.9999 8.56329e-07 48.0061 8.0103e-07 46.7802C7.4573e-07 45.5543 1.03789 44.5606 2.31818 44.5606C3.59848 44.5606 4.63636 45.5543 4.63636 46.7802C4.63636 48.0061 3.59848 48.9999 2.31818 48.9999Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                        <?php
                    else: ?>
                        <div class="rectangle-categories-main-item"></div>
                        <span class="counter-categories-main-item"></span>
                        <div class="line-categories-main-item"></div>
                        <span class="name-categories-main-item"><?php echo esc_html($cat['category_title']) ?></span>
                        <div class="content-categories-main-item">
                            <div class="top-content-categories-main-item">
                                <div class="title-category-main">
                                    <div class="shape-category-main"></div>
                                    <a href="<?php echo esc_url($cat['category_link']['url']); ?>" class="subtitle-category-main"><?php echo esc_html($cat['category_title']) ?></a>
                                    <div class="counter-product-category-main">
                                        <span>
                                            <?php echo wp_kses($cat['category_description'], [
                                                'a' => ['href' => [], 'title' => [], 'target' => []],
                                                'br' => [],
                                                'strong' => [],
                                                'em' => [],
                                                'b' => [],
                                                'i' => [],
                                            ]); ?>
                                        </span>
                                    </div>
                                </div>
                                <a href="<?php echo esc_url($cat['category_link']['url']); ?>" <?php echo $cat['category_link']['is_external'] ? 'target="_blank"' : ''; ?> class="button-show-categories">
                                    <svg width="40" height="41" viewBox="0 0 40 41" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M23.6216 14.1066C23.4648 14.2633 23.2504 14.3623 23.0029 14.3623L13.8623 14.3623L13.8623 23.5029C13.8623 23.9813 13.4664 24.3773 12.9879 24.3773C12.5094 24.3773 12.1134 23.9813 12.1134 23.5029L12.1134 13.4879C12.1134 13.0094 12.5094 12.6134 12.9879 12.6134L23.0029 12.6134C23.4813 12.6134 23.8773 13.0094 23.8773 13.4879C23.8856 13.7271 23.7783 13.9498 23.6216 14.1066Z"
                                            fill="#1D2977" />
                                        <path
                                            d="M27.6308 28.1308C27.2926 28.469 26.7316 28.469 26.3934 28.1308L12.5093 14.2468C12.1711 13.9085 12.1711 13.3476 12.5093 13.0093C12.8476 12.6711 13.4085 12.6711 13.7468 13.0093L27.6308 26.8934C27.9691 27.2316 27.9691 27.7926 27.6308 28.1308Z"
                                            fill="#1D2977" />
                                    </svg>
                                </a>
                            </div>
                            <div class="bottom-content-categories-main-item">
                                <?php
                                if (!empty($cat['category_image']['url'])) {
                                    echo '<img src="' . esc_url($cat['category_image']['url']) . '" alt="' . esc_html($cat['category_title']) . '">';
                                }
                                ?>
                                <div class="circle-one-bottom-content-categories-main-item"></div>
                                <div class="circle-two-bottom-content-categories-main-item"></div>
                                <div class="circle-three-bottom-content-categories-main-item">
                                    <svg width="51" height="49" viewBox="0 0 51 49" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M11.5909 22.1965C10.3106 22.1965 9.27273 21.2027 9.27273 19.9768C9.27273 18.7509 10.3106 17.7571 11.5909 17.7571C12.8712 17.7571 13.9091 18.7509 13.9091 19.9768C13.9091 21.2027 12.8712 22.1965 11.5909 22.1965Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M30.1364 22.1965C28.8561 22.1965 27.8182 21.2027 27.8182 19.9768C27.8182 18.7509 28.8561 17.7571 30.1364 17.7571C31.4167 17.7571 32.4545 18.7509 32.4545 19.9768C32.4545 21.2027 31.4167 22.1965 30.1364 22.1965Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M39.4091 22.1965C38.1288 22.1965 37.0909 21.2027 37.0909 19.9768C37.0909 18.7509 38.1288 17.7571 39.4091 17.7571C40.6894 17.7571 41.7273 18.7509 41.7273 19.9768C41.7273 21.2027 40.6894 22.1965 39.4091 22.1965Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M2.31818 13.3178C1.03789 13.3178 4.55814e-07 12.3241 4.00514e-07 11.0982C3.45215e-07 9.87229 1.03789 8.87851 2.31818 8.87851C3.59848 8.87851 4.63636 9.87229 4.63636 11.0982C4.63636 12.3241 3.59848 13.3178 2.31818 13.3178Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M11.5909 13.3178C10.3106 13.3178 9.27273 12.3241 9.27273 11.0982C9.27273 9.87229 10.3106 8.87851 11.5909 8.87851C12.8712 8.87851 13.9091 9.87229 13.9091 11.0982C13.9091 12.3241 12.8712 13.3178 11.5909 13.3178Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M20.8636 13.3178C19.5833 13.3178 18.5455 12.3241 18.5455 11.0982C18.5455 9.87229 19.5833 8.87851 20.8636 8.87851C22.1439 8.87851 23.1818 9.87229 23.1818 11.0982C23.1818 12.3241 22.1439 13.3178 20.8636 13.3178Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M39.4091 13.3178C38.1288 13.3178 37.0909 12.3241 37.0909 11.0982C37.0909 9.87229 38.1288 8.87851 39.4091 8.87851C40.6894 8.87851 41.7273 9.87228 41.7273 11.0982C41.7273 12.3241 40.6894 13.3178 39.4091 13.3178Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M48.6818 13.3178C47.4015 13.3178 46.3636 12.3241 46.3636 11.0982C46.3636 9.87228 47.4015 8.87851 48.6818 8.87851C49.9621 8.87851 51 9.87228 51 11.0982C51 12.3241 49.9621 13.3178 48.6818 13.3178Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M2.31818 4.4392C1.03789 4.4392 5.52996e-08 3.44542 0 2.21954C-5.52996e-08 0.993654 1.03789 -0.000120052 2.31818 -0.000120107C3.59848 -0.000120161 4.63636 0.993654 4.63636 2.21954C4.63636 3.44542 3.59848 4.4392 2.31818 4.4392Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M20.8636 4.43919C19.5833 4.43919 18.5455 3.44542 18.5455 2.21954C18.5455 0.993653 19.5833 -0.000120838 20.8636 -0.000120892C22.1439 -0.000120946 23.1818 0.993653 23.1818 2.21954C23.1818 3.44542 22.1439 4.43919 20.8636 4.43919Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M30.1364 4.43919C28.8561 4.43919 27.8182 3.44542 27.8182 2.21954C27.8182 0.993653 28.8561 -0.000121231 30.1364 -0.000121285C31.4167 -0.000121339 32.4545 0.993653 32.4545 2.21954C32.4545 3.44542 31.4167 4.43919 30.1364 4.43919Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M39.4091 4.43919C38.1288 4.43919 37.0909 3.44542 37.0909 2.21954C37.0909 0.993653 38.1288 -0.000121623 39.4091 -0.000121678C40.6894 -0.000121732 41.7273 0.993652 41.7273 2.21954C41.7273 3.44542 40.6894 4.43919 39.4091 4.43919Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M48.6818 4.43919C47.4015 4.43919 46.3636 3.44542 46.3636 2.21954C46.3636 0.993652 47.4015 -0.000122016 48.6818 -0.00012207C49.9621 -0.000122125 51 0.993652 51 2.21954C51 3.44542 49.9621 4.43919 48.6818 4.43919Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M30.1364 13.3178C28.8561 13.3178 27.8182 12.3241 27.8182 11.0982C27.8182 9.87229 28.8561 8.87851 30.1364 8.87851C31.4167 8.87851 32.4545 9.87229 32.4545 11.0982C32.4545 12.3241 31.4167 13.3178 30.1364 13.3178Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M11.5909 4.43919C10.3106 4.43919 9.27273 3.44542 9.27273 2.21954C9.27273 0.993654 10.3106 -0.000120445 11.5909 -0.000120499C12.8712 -0.000120554 13.9091 0.993653 13.9091 2.21954C13.9091 3.44542 12.8712 4.43919 11.5909 4.43919Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M20.8636 22.1965C19.5833 22.1965 18.5455 21.2027 18.5455 19.9768C18.5455 18.7509 19.5833 17.7571 20.8636 17.7571C22.1439 17.7571 23.1818 18.7509 23.1818 19.9768C23.1818 21.2027 22.1439 22.1965 20.8636 22.1965Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M48.6818 22.1965C47.4015 22.1965 46.3636 21.2027 46.3636 19.9768C46.3636 18.7509 47.4015 17.7571 48.6818 17.7571C49.9621 17.7571 51 18.7509 51 19.9768C51 21.2027 49.9621 22.1965 48.6818 22.1965Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M2.31818 22.1965C1.03789 22.1965 8.56329e-07 21.2027 8.0103e-07 19.9768C7.4573e-07 18.7509 1.03789 17.7571 2.31818 17.7571C3.59848 17.7571 4.63636 18.7509 4.63636 19.9768C4.63636 21.2027 3.59848 22.1965 2.31818 22.1965Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M11.5909 48.9999C10.3106 48.9999 9.27273 48.0061 9.27273 46.7802C9.27273 45.5543 10.3106 44.5606 11.5909 44.5606C12.8712 44.5606 13.9091 45.5543 13.9091 46.7802C13.9091 48.0061 12.8712 48.9999 11.5909 48.9999Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M30.1364 48.9999C28.8561 48.9999 27.8182 48.0061 27.8182 46.7802C27.8182 45.5543 28.8561 44.5606 30.1364 44.5606C31.4167 44.5606 32.4545 45.5543 32.4545 46.7802C32.4545 48.0061 31.4167 48.9999 30.1364 48.9999Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M39.4091 48.9999C38.1288 48.9999 37.0909 48.0061 37.0909 46.7802C37.0909 45.5543 38.1288 44.5606 39.4091 44.5606C40.6894 44.5606 41.7273 45.5543 41.7273 46.7802C41.7273 48.0061 40.6894 48.9999 39.4091 48.9999Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M2.31818 40.1213C1.03789 40.1213 4.55814e-07 39.1275 4.00514e-07 37.9016C3.45215e-07 36.6757 1.03789 35.6819 2.31818 35.6819C3.59848 35.6819 4.63636 36.6757 4.63636 37.9016C4.63636 39.1275 3.59848 40.1213 2.31818 40.1213Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M11.5909 40.1213C10.3106 40.1213 9.27273 39.1275 9.27273 37.9016C9.27273 36.6757 10.3106 35.6819 11.5909 35.6819C12.8712 35.6819 13.9091 36.6757 13.9091 37.9016C13.9091 39.1275 12.8712 40.1213 11.5909 40.1213Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M20.8636 40.1213C19.5833 40.1213 18.5455 39.1275 18.5455 37.9016C18.5455 36.6757 19.5833 35.6819 20.8636 35.6819C22.1439 35.6819 23.1818 36.6757 23.1818 37.9016C23.1818 39.1275 22.1439 40.1213 20.8636 40.1213Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M39.4091 40.1212C38.1288 40.1212 37.0909 39.1275 37.0909 37.9016C37.0909 36.6757 38.1288 35.6819 39.4091 35.6819C40.6894 35.6819 41.7273 36.6757 41.7273 37.9016C41.7273 39.1275 40.6894 40.1212 39.4091 40.1212Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M48.6818 40.1212C47.4015 40.1212 46.3636 39.1275 46.3636 37.9016C46.3636 36.6757 47.4015 35.6819 48.6818 35.6819C49.9621 35.6819 51 36.6757 51 37.9016C51 39.1275 49.9621 40.1212 48.6818 40.1212Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M2.31818 31.2426C1.03789 31.2426 5.52996e-08 30.2488 0 29.023C-5.52996e-08 27.7971 1.03789 26.8033 2.31818 26.8033C3.59848 26.8033 4.63636 27.7971 4.63636 29.023C4.63636 30.2488 3.59848 31.2426 2.31818 31.2426Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M20.8636 31.2426C19.5833 31.2426 18.5455 30.2488 18.5455 29.023C18.5455 27.7971 19.5833 26.8033 20.8636 26.8033C22.1439 26.8033 23.1818 27.7971 23.1818 29.023C23.1818 30.2488 22.1439 31.2426 20.8636 31.2426Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M30.1364 31.2426C28.8561 31.2426 27.8182 30.2488 27.8182 29.023C27.8182 27.7971 28.8561 26.8033 30.1364 26.8033C31.4167 26.8033 32.4545 27.7971 32.4545 29.023C32.4545 30.2488 31.4167 31.2426 30.1364 31.2426Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M39.4091 31.2426C38.1288 31.2426 37.0909 30.2488 37.0909 29.023C37.0909 27.7971 38.1288 26.8033 39.4091 26.8033C40.6894 26.8033 41.7273 27.7971 41.7273 29.023C41.7273 30.2488 40.6894 31.2426 39.4091 31.2426Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M48.6818 31.2426C47.4015 31.2426 46.3636 30.2488 46.3636 29.023C46.3636 27.7971 47.4015 26.8033 48.6818 26.8033C49.9621 26.8033 51 27.7971 51 29.023C51 30.2488 49.9621 31.2426 48.6818 31.2426Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M30.1364 40.1212C28.8561 40.1212 27.8182 39.1275 27.8182 37.9016C27.8182 36.6757 28.8561 35.6819 30.1364 35.6819C31.4167 35.6819 32.4545 36.6757 32.4545 37.9016C32.4545 39.1275 31.4167 40.1212 30.1364 40.1212Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M11.5909 31.2426C10.3106 31.2426 9.27273 30.2488 9.27273 29.023C9.27273 27.7971 10.3106 26.8033 11.5909 26.8033C12.8712 26.8033 13.9091 27.7971 13.9091 29.023C13.9091 30.2488 12.8712 31.2426 11.5909 31.2426Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M20.8636 48.9999C19.5833 48.9999 18.5455 48.0061 18.5455 46.7802C18.5455 45.5543 19.5833 44.5606 20.8636 44.5606C22.1439 44.5606 23.1818 45.5543 23.1818 46.7802C23.1818 48.0061 22.1439 48.9999 20.8636 48.9999Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M48.6818 48.9999C47.4015 48.9999 46.3636 48.0061 46.3636 46.7802C46.3636 45.5543 47.4015 44.5606 48.6818 44.5606C49.9621 44.5606 51 45.5543 51 46.7802C51 48.0061 49.9621 48.9999 48.6818 48.9999Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                        <path
                                            d="M2.31818 48.9999C1.03789 48.9999 8.56329e-07 48.0061 8.0103e-07 46.7802C7.4573e-07 45.5543 1.03789 44.5606 2.31818 44.5606C3.59848 44.5606 4.63636 45.5543 4.63636 46.7802C4.63636 48.0061 3.59848 48.9999 2.31818 48.9999Z"
                                            fill="#F7F8FD" fill-opacity="0.4" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                        <?php
                    endif;
                    echo '</div>';
                endforeach; ?>
            </div>

            <a href="<?php echo esc_url($settings['categories_link_url']['url']) ?>"
                class="bottom-show-more-header-categories-main">
                <div>
                    <span><?php echo esc_html($settings['categories_link_text']) ?></span>
                </div>
                <div>
                    <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M23.6216 13.6066C23.4648 13.7633 23.2504 13.8623 23.0029 13.8623L13.8623 13.8623L13.8623 23.0029C13.8623 23.4813 13.4664 23.8773 12.9879 23.8773C12.5094 23.8773 12.1134 23.4813 12.1134 23.0029L12.1134 12.9879C12.1134 12.5094 12.5094 12.1134 12.9879 12.1134L23.0029 12.1134C23.4813 12.1134 23.8773 12.5094 23.8773 12.9879C23.8856 13.2271 23.7783 13.4498 23.6216 13.6066Z"
                            fill="white" />
                        <path
                            d="M27.6308 27.6308C27.2926 27.969 26.7316 27.969 26.3934 27.6308L12.5093 13.7468C12.1711 13.4085 12.1711 12.8476 12.5093 12.5093C12.8476 12.1711 13.4085 12.1711 13.7468 12.5093L27.6308 26.3934C27.9691 26.7316 27.9691 27.2926 27.6308 27.6308Z"
                            fill="white" />
                    </svg>
                </div>
            </a>
        </section>

        <script>
            document.addEventListener("DOMContentLoaded", () => {
                const items = document.querySelectorAll(".body-categories-main-item");
                let currentIndex = 0;
                let interval;

                function setActive(index) {
                    items.forEach(item => item.classList.remove("active"));
                    items[index].classList.add("active");
                }

                function startRotation() {
                    interval = setInterval(() => {
                        currentIndex = (currentIndex + 1) % items.length;
                        setActive(currentIndex);
                    }, <?php echo esc_attr($settings['category_duration']) ?>);
                }

                function stopRotation() {
                    clearInterval(interval);
                }

                items.forEach((item, index) => {
                    const span = item.querySelector(".counter-categories-main-item");
                    if (span) {
                        span.textContent = (index + 1).toString().padStart(2, "0");
                    }

                    item.addEventListener("mouseenter", () => {
                        stopRotation();
                        setActive(index);
                    });

                    item.addEventListener("mouseleave", () => {
                        currentIndex = index;
                        startRotation();
                    });
                });

                setActive(currentIndex);
                startRotation();
            });
        </script>
        <?php
    }
}
