<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

class Features_Product extends Widget_Base
{
    public function get_name()
    {
        return 'Features_Product';
    }

    public function get_title()
    {
        return __('ویژگی های محصول لمکده', 'lamkadeh');
    }

    public function get_icon()
    {
        return 'eicon-post-list';
    }

    public function get_categories()
    {
        return ['lamkadeh'];
    }

    protected function register_controls()
    {
        // بخش اصلی
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        // کنترل آپلود SVG
        $repeater->add_control(
            'feature_icon_svg',
            [
                'label' => __('آیکون SVG', 'lamkadeh'),
                'type' => Controls_Manager::MEDIA,
                'media_types' => ['svg'],
                'default' => [
                    'url' => '',
                ],
                'description' => __('فایل SVG را آپلود کنید', 'lamkadeh'),
            ]
        );

        // کنترل عنوان اول
        $repeater->add_control(
            'first_title',
            [
                'label' => __('عنوان اول', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => __('۷ روز هفته, ۲۴ ساعته', 'lamkadeh'),
                'placeholder' => __('عنوان اول را وارد کنید', 'lamkadeh'),
                'label_block' => true,
            ]
        );

        // کنترل عنوان دوم
        $repeater->add_control(
            'second_title',
            [
                'label' => __('عنوان دوم', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => __('همیشه پاسخگوی شماییم', 'lamkadeh'),
                'placeholder' => __('عنوان دوم را وارد کنید', 'lamkadeh'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'features_list',
            [
                'label' => __('لیست ویژگی‌ها', 'lamkadeh'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'first_title' => __('۷ روز هفته, ۲۴ ساعته', 'lamkadeh'),
                        'second_title' => __('همیشه پاسخگوی شماییم', 'lamkadeh'),
                    ],
                    [
                        'first_title' => __('۷ روز هفته, ۲۴ ساعته', 'lamkadeh'),
                        'second_title' => __('همیشه پاسخگوی شماییم', 'lamkadeh'),
                    ],
                    [
                        'first_title' => __('۷ روز هفته, ۲۴ ساعته', 'lamkadeh'),
                        'second_title' => __('همیشه پاسخگوی شماییم', 'lamkadeh'),
                    ],
                    [
                        'first_title' => __('۷ روز هفته, ۲۴ ساعته', 'lamkadeh'),
                        'second_title' => __('همیشه پاسخگوی شماییم', 'lamkadeh'),
                    ],
                ],
                'title_field' => '{{{ first_title }}}',
            ]
        );

        $this->end_controls_section();

        // استایل‌ها
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        // استایل آیتم‌ها
        $this->add_control(
            'item_style',
            [
                'label' => __('آیتم‌ها', 'lamkadeh'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'item_background',
            [
                'label' => __('پس‌زمینه آیتم', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lamkadeh-single-product-banner-content-item' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'item_padding',
            [
                'label' => __('فاصله داخلی', 'lamkadeh'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .lamkadeh-single-product-banner-content-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // استایل عناوین
        $this->add_control(
            'title_style',
            [
                'label' => __('عناوین', 'lamkadeh'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('رنگ متن', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lamkadeh-single-product-banner-content-item-left span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('تایپوگرافی', 'lamkadeh'),
                'selector' => '{{WRAPPER}} .lamkadeh-single-product-banner-content-item-left span',
            ]
        );

        // استایل آیکون
        $this->add_control(
            'icon_style',
            [
                'label' => __('آیکون', 'lamkadeh'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'icon_size',
            [
                'label' => __('اندازه آیکون', 'lamkadeh'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .lamkadeh-single-product-banner-content-item-right svg' => 'width: {{SIZE}}{{UNIT}}; height: auto;',
                    '{{WRAPPER}} .lamkadeh-single-product-banner-content-item-right img' => 'width: {{SIZE}}{{UNIT}}; height: auto;',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        
        echo '<div class="lamkadeh-single-product-banner">';
        ?>
        <div class="lamkadeh-single-product-banner-right"></div>
        <div class="lamkadeh-single-product-banner-content container">
            <div class="lamkadeh-single-product-banner-content-wrapper">
                <?php foreach ($settings['features_list'] as $item): 
                    $icon_url = $item['feature_icon_svg']['url'];
                ?>
                <div class="lamkadeh-single-product-banner-content-item">
                    <div class="lamkadeh-single-product-banner-content-item-right">
                        <?php if ($icon_url): ?>
                            <?php 
                            // بررسی نوع فایل
                            $file_extension = pathinfo($icon_url, PATHINFO_EXTENSION);
                            if (strtolower($file_extension) === 'svg') {
                                // برای فایل SVG، محتوای فایل را می‌خوانیم و نمایش می‌دهیم
                                $svg_content = $this->get_svg_content($icon_url);
                                if ($svg_content) {
                                    echo $svg_content;
                                } else {
                                    echo '<img src="' . esc_url($icon_url) . '" alt="' . esc_attr($item['first_title']) . '" />';
                                }
                            } else {
                                echo '<img src="' . esc_url($icon_url) . '" alt="' . esc_attr($item['first_title']) . '" />';
                            }
                            ?>
                        <?php endif; ?>
                    </div>
                    <div class="lamkadeh-single-product-banner-content-item-left">
                        <span><?php echo esc_html($item['first_title']); ?></span>
                        <span><?php echo esc_html($item['second_title']); ?></span>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="lamkadeh-single-product-banner-left"></div>
        <?php
        echo '</div>';
    }

    /**
     * خواندن محتوای فایل SVG
     */
    private function get_svg_content($svg_url)
    {
        $svg_path = $this->url_to_path($svg_url);
        
        if ($svg_path && file_exists($svg_path)) {
            $svg_content = file_get_contents($svg_path);
            // حذف تگ <?xml اگر وجود دارد
            $svg_content = preg_replace('/<\?xml.*?\?>/', '', $svg_content);
            return $svg_content;
        }
        
        return false;
    }

    /**
     * تبدیل URL به مسیر فایل
     */
    private function url_to_path($url)
    {
        $upload_dir = wp_upload_dir();
        $base_url = $upload_dir['baseurl'];
        $base_path = $upload_dir['basedir'];
        
        if (strpos($url, $base_url) === 0) {
            return str_replace($base_url, $base_path, $url);
        }
        
        return false;
    }
}