<?php

namespace Elementor;

if (! defined('ABSPATH')) exit;

class Banner extends Widget_Base
{
    public function get_name()
    {
        return 'Banner';
    }

    public function get_title()
    {
        return __('بنر لمکده', 'lamkadeh');
    }

    public function get_icon()
    {
        return 'eicon-banner';
    }

    public function get_categories()
    {
        return ['lamkadeh'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'lamkadeh'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'banner_title',
            [
                'label' => __('عنوان بنر', 'lamkadeh'),
                'type'  => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __("عنوان دلخواه خود را وارد کنید", "lamkadeh")
            ]
        );

        $this->add_control(
            'banner_text',
            [
                'label' => __('متن لینک بنر', 'lamkadeh'),
                'type'  => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __("بیشتر", "lamkadeh")
            ]
        );

        $this->add_control(
            'banner_link',
            [
                'label' => __('لینک بنر', 'lamkadeh'),
                'type'  => \Elementor\Controls_Manager::URL,
                'placeholder' => __("لینک دلخواه خود را وارد کنید", "lamkadeh")
            ]
        );

        $this->add_control(
            'banner_image',
            [
                'label' => __('انتخاب تصویر', 'lamkadeh'),
                'type'  => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'banner_overly',
            [
                'label' => __('overly فعال باشد یا خیر؟', 'lamkadeh'),
                'type'  => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes'
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل', 'lamkadeh'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'banner_border_radius',
            [
                'label' => __('گردی گوشه‌ها', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'banner_border',
                'label' => __('حاشیه', 'lamkadeh'),
                'selector' => '{{WRAPPER}} .banner',
            ]
        );

        $this->add_responsive_control(
            'banner_width',
            [
                'label' => __('عرض بنر', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'vw'],
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 2000,
                    ],
                    '%' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .banner' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'banner_height',
            [
                'label' => __('ارتفاع بنر', 'lamkadeh'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'vh'],
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 1200,
                    ],
                    'vh' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .banner' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <section class="banner" style="background-image: url(<?php echo esc_url($settings["banner_image"]["url"]) ?>);">
            <div>
                <p><?php echo $settings["banner_title"] ?></p>
                <a href="#">
                    بیشتر
                    <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M10.9851 13.28L6.63842 8.9333C6.12508 8.41997 6.12508 7.57997 6.63842 7.06664L10.9851 2.71997" stroke="#1D2977" stroke-width="1.04835" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                </a>
            </div>
            <div class="overly-banner"></div>
        </section>
<?php
    }
}
