<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit;

class Banner_Instagram extends Widget_Base
{
    public function get_name()
    {
        return 'Banner_Instagram';
    }

    public function get_title()
    {
        return __('بنر اینستاگرام لمکده', 'lamkadeh');
    }

    public function get_icon()
    {
        return 'eicon-banner';
    }

    public function get_categories()
    {
        return ['lamkadeh'];
    }

    public function get_keywords()
    {
        return ['instagram', 'banner', 'social', 'اینستاگرام', 'بنر', 'لمکده'];
    }

    protected function register_controls()
    {
        // بخش تنظیمات محتوا
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title_en',
            [
                'label' => __('عنوان انگلیسی', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => 'FOLLOW US IN INSTAGRAM',
                'placeholder' => __('عنوان انگلیسی را وارد کنید', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('عنوان اصلی', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => __('جایی برای <strong>سلــــــــــــــیقه‌های خاص</strong>!', 'lamkadeh'),
                'placeholder' => __('عنوان اصلی را وارد کنید', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => __('توضیحات', 'lamkadeh'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('ایــــــده‌های دکوراسیون و چیدمان خاص تو اینســــــــــــــــتاگرام ما منتظرته.', 'lamkadeh'),
                'placeholder' => __('توضیحات را وارد کنید', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => __('متن دکمه', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => __('اینستاگرام لمکـــــــــده', 'lamkadeh'),
                'placeholder' => __('متن دکمه را وارد کنید', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'instagram_url',
            [
                'label' => __('لینک اینستاگرام', 'lamkadeh'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://instagram.com/yourusername', 'lamkadeh'),
                'default' => [
                    'url' => 'https://instagram.com',
                ],
            ]
        );

        $this->add_control(
            'instagram_icon',
            [
                'label' => __('آیکون اینستاگرام', 'lamkadeh'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => get_template_directory_uri() . '/assets/images/theme/instagram.png',
                ],
            ]
        );

        $this->end_controls_section();

        // بخش تنظیمات استایل
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'background_color',
            [
                'label' => __('رنگ پس‌زمینه', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-instagram' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_en_color',
            [
                'label' => __('رنگ عنوان انگلیسی', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title-banner-instagram p:first-child' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('رنگ عنوان اصلی', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title-banner-instagram p:last-child' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => __('رنگ توضیحات', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .text-banner-instagram p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_background',
            [
                'label' => __('پس‌زمینه دکمه', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-instagram-link' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => __('رنگ متن دکمه', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-instagram-link span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_hover_background',
            [
                'label' => __('پس‌زمینه دکمه هاور', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-instagram-link:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'gradient_overlay',
            [
                'label' => __('رنگ گرادیانت', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-instagram' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        // بخش تنظیمات تایپوگرافی
        $this->start_controls_section(
            'typography_section',
            [
                'label' => __('تایپوگرافی', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_en_typography',
                'label' => __('تایپوگرافی عنوان انگلیسی', 'lamkadeh'),
                'selector' => '{{WRAPPER}} .title-banner-instagram p:first-child',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('تایپوگرافی عنوان اصلی', 'lamkadeh'),
                'selector' => '{{WRAPPER}} .title-banner-instagram p:last-child',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'label' => __('تایپوگرافی توضیحات', 'lamkadeh'),
                'selector' => '{{WRAPPER}} .text-banner-instagram p',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'label' => __('تایپوگرافی دکمه', 'lamkadeh'),
                'selector' => '{{WRAPPER}} .banner-instagram-link span',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $instagram_icon_url = $settings['instagram_icon']['url'] ?: get_template_directory_uri() . '/assets/images/theme/instagram.png';
?>
        <section class="banner-instagram container">
            <svg width="82" height="79" viewBox="0 0 82 79" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M63.3636 35.7863C65.4222 35.7863 67.0909 34.1841 67.0909 32.2077C67.0909 30.2313 65.4222 28.6291 63.3636 28.6291C61.3051 28.6291 59.6364 30.2313 59.6364 32.2077C59.6364 34.1841 61.3051 35.7863 63.3636 35.7863Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M33.5455 35.7863C35.604 35.7863 37.2727 34.1841 37.2727 32.2077C37.2727 30.2313 35.604 28.6291 33.5455 28.6291C31.4869 28.6291 29.8182 30.2313 29.8182 32.2077C29.8182 34.1841 31.4869 35.7863 33.5455 35.7863Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M18.6364 35.7863C20.6949 35.7863 22.3636 34.1841 22.3636 32.2077C22.3636 30.2313 20.6949 28.6291 18.6364 28.6291C16.5779 28.6291 14.9091 30.2313 14.9091 32.2077C14.9091 34.1841 16.5779 35.7863 18.6364 35.7863Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M78.2727 21.4718C80.3312 21.4718 82 19.8696 82 17.8932C82 15.9167 80.3312 14.3145 78.2727 14.3145C76.2142 14.3145 74.5455 15.9167 74.5455 17.8932C74.5455 19.8696 76.2142 21.4718 78.2727 21.4718Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M63.3636 21.4718C65.4222 21.4718 67.0909 19.8696 67.0909 17.8932C67.0909 15.9167 65.4222 14.3145 63.3636 14.3145C61.3051 14.3145 59.6364 15.9167 59.6364 17.8932C59.6364 19.8696 61.3051 21.4718 63.3636 21.4718Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M48.4545 21.4718C50.5131 21.4718 52.1818 19.8696 52.1818 17.8932C52.1818 15.9167 50.5131 14.3145 48.4545 14.3145C46.396 14.3145 44.7273 15.9167 44.7273 17.8932C44.7273 19.8696 46.396 21.4718 48.4545 21.4718Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M18.6364 21.4718C20.6949 21.4718 22.3636 19.8696 22.3636 17.8932C22.3636 15.9167 20.6949 14.3145 18.6364 14.3145C16.5779 14.3145 14.9091 15.9167 14.9091 17.8932C14.9091 19.8696 16.5779 21.4718 18.6364 21.4718Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M3.72727 21.4718C5.78579 21.4718 7.45455 19.8696 7.45455 17.8932C7.45455 15.9167 5.78579 14.3145 3.72727 14.3145C1.66875 14.3145 0 15.9167 0 17.8932C0 19.8696 1.66875 21.4718 3.72727 21.4718Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M78.2727 7.15727C80.3312 7.15727 82 5.55506 82 3.57863C82 1.60221 80.3312 3.25353e-06 78.2727 3.1661e-06C76.2142 3.07867e-06 74.5455 1.60221 74.5455 3.57863C74.5455 5.55506 76.2142 7.15727 78.2727 7.15727Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M48.4545 7.15727C50.5131 7.15727 52.1818 5.55506 52.1818 3.57863C52.1818 1.60221 50.5131 1.98709e-06 48.4545 1.89966e-06C46.396 1.81223e-06 44.7273 1.60221 44.7273 3.57863C44.7273 5.55506 46.396 7.15727 48.4545 7.15727Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M33.5455 7.15726C35.604 7.15726 37.2727 5.55506 37.2727 3.57863C37.2727 1.60221 35.604 1.35387e-06 33.5455 1.26644e-06C31.4869 1.17901e-06 29.8182 1.60221 29.8182 3.57863C29.8182 5.55506 31.4869 7.15726 33.5455 7.15726Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M18.6364 7.15726C20.6949 7.15726 22.3636 5.55506 22.3636 3.57863C22.3636 1.60221 20.6949 7.2065e-07 18.6364 6.3322e-07C16.5779 5.45791e-07 14.9091 1.60221 14.9091 3.57863C14.9091 5.55506 16.5779 7.15726 18.6364 7.15726Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M3.72727 7.15726C5.78579 7.15726 7.45455 5.55506 7.45455 3.57863C7.45455 1.60221 5.78579 8.74296e-08 3.72727 0C1.66875 -8.74295e-08 7.62939e-06 1.60221 7.62939e-06 3.57863C7.62939e-06 5.55506 1.66875 7.15726 3.72727 7.15726Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M33.5455 21.4718C35.604 21.4718 37.2727 19.8696 37.2727 17.8932C37.2727 15.9167 35.604 14.3145 33.5455 14.3145C31.4869 14.3145 29.8182 15.9167 29.8182 17.8932C29.8182 19.8696 31.4869 21.4718 33.5455 21.4718Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M63.3636 7.15727C65.4222 7.15727 67.0909 5.55506 67.0909 3.57863C67.0909 1.60221 65.4222 2.62031e-06 63.3636 2.53288e-06C61.3051 2.44545e-06 59.6364 1.60221 59.6364 3.57863C59.6364 5.55506 61.3051 7.15727 63.3636 7.15727Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M48.4545 35.7863C50.5131 35.7863 52.1818 34.1841 52.1818 32.2077C52.1818 30.2313 50.5131 28.6291 48.4545 28.6291C46.396 28.6291 44.7273 30.2313 44.7273 32.2077C44.7273 34.1841 46.396 35.7863 48.4545 35.7863Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M3.72727 35.7863C5.78579 35.7863 7.45455 34.1841 7.45455 32.2077C7.45455 30.2313 5.78579 28.6291 3.72727 28.6291C1.66875 28.6291 0 30.2313 0 32.2077C0 34.1841 1.66875 35.7863 3.72727 35.7863Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M78.2727 35.7863C80.3312 35.7863 82 34.1841 82 32.2077C82 30.2313 80.3312 28.6291 78.2727 28.6291C76.2142 28.6291 74.5455 30.2313 74.5455 32.2077C74.5455 34.1841 76.2142 35.7863 78.2727 35.7863Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M63.3636 79C65.4222 79 67.0909 77.3978 67.0909 75.4214C67.0909 73.4449 65.4222 71.8427 63.3636 71.8427C61.3051 71.8427 59.6364 73.4449 59.6364 75.4214C59.6364 77.3978 61.3051 79 63.3636 79Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M33.5455 79C35.604 79 37.2727 77.3978 37.2727 75.4214C37.2727 73.4449 35.604 71.8427 33.5455 71.8427C31.4869 71.8427 29.8182 73.4449 29.8182 75.4214C29.8182 77.3978 31.4869 79 33.5455 79Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M18.6364 79C20.6949 79 22.3636 77.3978 22.3636 75.4214C22.3636 73.4449 20.6949 71.8427 18.6364 71.8427C16.5779 71.8427 14.9091 73.4449 14.9091 75.4214C14.9091 77.3978 16.5779 79 18.6364 79Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M78.2727 64.6855C80.3312 64.6855 82 63.0833 82 61.1068C82 59.1304 80.3312 57.5282 78.2727 57.5282C76.2142 57.5282 74.5455 59.1304 74.5455 61.1068C74.5455 63.0833 76.2142 64.6855 78.2727 64.6855Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M63.3636 64.6855C65.4222 64.6855 67.0909 63.0833 67.0909 61.1068C67.0909 59.1304 65.4222 57.5282 63.3636 57.5282C61.3051 57.5282 59.6364 59.1304 59.6364 61.1068C59.6364 63.0833 61.3051 64.6855 63.3636 64.6855Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M48.4545 64.6855C50.5131 64.6855 52.1818 63.0833 52.1818 61.1068C52.1818 59.1304 50.5131 57.5282 48.4545 57.5282C46.396 57.5282 44.7273 59.1304 44.7273 61.1068C44.7273 63.0833 46.396 64.6855 48.4545 64.6855Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M18.6364 64.6855C20.6949 64.6855 22.3636 63.0833 22.3636 61.1068C22.3636 59.1304 20.6949 57.5282 18.6364 57.5282C16.5779 57.5282 14.9091 59.1304 14.9091 61.1068C14.9091 63.0833 16.5779 64.6855 18.6364 64.6855Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M3.72727 64.6855C5.78579 64.6855 7.45455 63.0833 7.45455 61.1068C7.45455 59.1304 5.78579 57.5282 3.72727 57.5282C1.66875 57.5282 0 59.1304 0 61.1068C0 63.0833 1.66875 64.6855 3.72727 64.6855Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M78.2727 50.3709C80.3312 50.3709 82 48.7687 82 46.7923C82 44.8159 80.3312 43.2137 78.2727 43.2137C76.2142 43.2137 74.5455 44.8159 74.5455 46.7923C74.5455 48.7687 76.2142 50.3709 78.2727 50.3709Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M48.4545 50.3709C50.5131 50.3709 52.1818 48.7687 52.1818 46.7923C52.1818 44.8159 50.5131 43.2137 48.4545 43.2137C46.396 43.2137 44.7273 44.8159 44.7273 46.7923C44.7273 48.7687 46.396 50.3709 48.4545 50.3709Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M33.5455 50.3709C35.604 50.3709 37.2727 48.7687 37.2727 46.7923C37.2727 44.8159 35.604 43.2137 33.5455 43.2137C31.4869 43.2137 29.8182 44.8159 29.8182 46.7923C29.8182 48.7687 31.4869 50.3709 33.5455 50.3709Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M18.6364 50.3709C20.6949 50.3709 22.3636 48.7687 22.3636 46.7923C22.3636 44.8159 20.6949 43.2137 18.6364 43.2137C16.5779 43.2137 14.9091 44.8159 14.9091 46.7923C14.9091 48.7687 16.5779 50.3709 18.6364 50.3709Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M3.72727 50.3709C5.78579 50.3709 7.45455 48.7687 7.45455 46.7923C7.45455 44.8159 5.78579 43.2137 3.72727 43.2137C1.66875 43.2137 7.62939e-06 44.8159 7.62939e-06 46.7923C7.62939e-06 48.7687 1.66875 50.3709 3.72727 50.3709Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M33.5455 64.6855C35.604 64.6855 37.2727 63.0833 37.2727 61.1068C37.2727 59.1304 35.604 57.5282 33.5455 57.5282C31.4869 57.5282 29.8182 59.1304 29.8182 61.1068C29.8182 63.0833 31.4869 64.6855 33.5455 64.6855Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M63.3636 50.3709C65.4222 50.3709 67.0909 48.7687 67.0909 46.7923C67.0909 44.8159 65.4222 43.2137 63.3636 43.2137C61.3051 43.2137 59.6364 44.8159 59.6364 46.7923C59.6364 48.7687 61.3051 50.3709 63.3636 50.3709Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M48.4545 79C50.5131 79 52.1818 77.3978 52.1818 75.4214C52.1818 73.4449 50.5131 71.8427 48.4545 71.8427C46.396 71.8427 44.7273 73.4449 44.7273 75.4214C44.7273 77.3978 46.396 79 48.4545 79Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M3.72727 79C5.78579 79 7.45455 77.3978 7.45455 75.4214C7.45455 73.4449 5.78579 71.8427 3.72727 71.8427C1.66875 71.8427 0 73.4449 0 75.4214C0 77.3978 1.66875 79 3.72727 79Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
                <path
                    d="M78.2727 79C80.3312 79 82 77.3978 82 75.4214C82 73.445 80.3312 71.8427 78.2727 71.8427C76.2142 71.8427 74.5455 73.445 74.5455 75.4214C74.5455 77.3978 76.2142 79 78.2727 79Z"
                    fill="#F7F8FD" fill-opacity="0.32" />
            </svg>
            <div class="wrapper-banner-instagram">
                <img src="<?php echo esc_url($instagram_icon_url); ?>" alt="" />
                <div class="wrapper-banner-instagram-title">
                    <span><?php echo esc_html($settings['title_en']); ?></span>
                    <span><?php echo wp_kses($settings['title'], ['strong' => []]); ?></span>
                </div>
                <div class="wrapper-banner-instagram-description">
                    <svg width="28" height="29" viewBox="0 0 28 29" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M10.9373 0.612061C12.1419 5.4171 11.7633 15.9539 0.612305 19.6606M26.6123 21.5249C22.1522 19.3457 11.7406 17.5123 5.7748 27.6121M3.7098 23.2644L22.2947 8.33445"
                            stroke="#F7F8FD" stroke-width="1.22384" stroke-linecap="round" />
                    </svg>
                    <p>
                        <?php echo esc_html($settings['description']); ?>
                    </p>
                </div>
                <a href="<?php echo esc_url($settings['instagram_url']['url']); ?>" class="wrapper-banner-instagram-button">
                    <span>
                        <?php echo esc_html($settings['button_text']); ?>
                    </span>
                    <svg width="34" height="34" viewBox="0 0 34 34" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M20.0747 11.4905C19.9404 11.6248 19.7565 11.7097 19.5444 11.7097L11.7096 11.7097L11.7096 19.5444C11.7096 19.9546 11.3702 20.294 10.9601 20.294C10.55 20.294 10.2106 19.9546 10.2106 19.5444L10.2106 10.9602C10.2106 10.55 10.55 10.2106 10.9601 10.2106L19.5444 10.2106C19.9545 10.2106 20.2939 10.55 20.2939 10.9602C20.301 11.1652 20.2091 11.3561 20.0747 11.4905Z"
                            fill="#F7F8FD" />
                        <path
                            d="M23.5114 23.5114C23.2215 23.8013 22.7406 23.8013 22.4507 23.5114L10.5501 11.6108C10.2602 11.3208 10.2602 10.84 10.5501 10.5501C10.84 10.2602 11.3209 10.2602 11.6108 10.5501L23.5114 22.4507C23.8013 22.7406 23.8013 23.2214 23.5114 23.5114Z"
                            fill="#F7F8FD" />
                    </svg>
                </a>
                <div class="wrapper-banner-instagram-cirlce"></div>
                <div class="rectangle-banner-instagram">
                    <div></div>
                    <svg class="svg-two" width="1400" height="204" viewBox="0 0 1400 204" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M1079 43C1079 56.2548 1089.75 67 1103 67H1376C1389.25 67 1400 77.7452 1400 91V180C1400 193.255 1389.25 204 1376 204H-420C-458.66 204 -490 172.66 -490 134V70C-490 31.3401 -458.66 2.81864e-07 -420 0H1055C1068.25 0 1079 10.7452 1079 24V43Z"
                            fill="url(#paint0_linear_1_3170)" />
                        <defs>
                            <linearGradient id="paint0_linear_1_3170" x1="208" y1="-100" x2="1415.5" y2="204"
                                gradientUnits="userSpaceOnUse">
                                <stop stop-color="#F58E06" />
                                <stop offset="0.669224" stop-color="#AE2CA3" />
                                <stop offset="1" stop-color="#515AD5" />
                            </linearGradient>
                        </defs>
                    </svg>
                    <svg class="svg-one" width="1400" height="204" viewBox="0 0 1400 204" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M1079 43C1079 56.2548 1089.75 67 1103 67H1376C1389.25 67 1400 77.7452 1400 91V180C1400 193.255 1389.25 204 1376 204H-420C-458.66 204 -490 172.66 -490 134V70C-490 31.3401 -458.66 2.81864e-07 -420 0H1055C1068.25 0 1079 10.7452 1079 24V43Z"
                            fill="url(#paint0_linear_1_3170)" />
                        <defs>
                            <linearGradient id="paint0_linear_1_3170" x1="208" y1="-100" x2="1415.5" y2="275"
                                gradientUnits="userSpaceOnUse">
                                <stop stop-color="#F58E06" />
                                <stop offset="0.669224" stop-color="#AE2CA3" />
                                <stop offset="1" stop-color="#515AD5" />
                            </linearGradient>
                        </defs>
                    </svg>
                </div>
            </div>
        </section>
<?php
    }
}
