<?php

namespace Elementor;

if (! defined('ABSPATH')) exit;

class AboutUs extends Widget_Base
{
    public function get_name()
    {
        return 'AboutUs';
    }

    public function get_title()
    {
        return __('درباره ما لمکده', 'lamkadeh');
    }

    public function get_icon()
    {
        return 'eicon-image-box';
    }

    public function get_categories()
    {
        return ['lamkadeh'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_slider',
            [
                'label' => __('تنظیمات درباره ما', 'lamkadeh'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'slider_title',
            [
                'label'       => __('عنوان درباره ما', 'lamkadeh'),
                'type'        => \Elementor\Controls_Manager::WYSIWYG,
                'default'     => __('عنوان نمونه', 'lamkadeh'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'slider_desc',
            [
                'label'       => __('توضیح درباره ما', 'lamkadeh'),
                'type'        => \Elementor\Controls_Manager::WYSIWYG,
                'default'     => __('اینجا توضیحات قرار می‌گیرد', 'lamkadeh'),
                'show_label'  => true,
            ]
        );

        $this->add_control(
            'slider_link_text',
            [
                'label'   => __('متن لینک درباره ما', 'lamkadeh'),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => __('بیشتر ببینید', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'slider_link_url',
            [
                'label'   => __('لینک درباره ما', 'lamkadeh'),
                'type'    => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        $this->add_control(
            'slider_banner',
            [
                'label'   => __('بنر درباره ما', 'lamkadeh'),
                'type'    => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'slider_theme_image',
            [
                'label'   => __('تصویر تم سکشن', 'lamkadeh'),
                'type'    => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'slider_theme_two_image',
            [
                'label'   => __('تصویر تم سکشن', 'lamkadeh'),
                'type'    => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'slider_banner_text',
            [
                'label'   => __('متن تصویر بنر درباره ما', 'lamkadeh'),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => __('متن بنر', 'lamkadeh'),
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <section id="slider-main-lamkadeh" class="slider-main-lamkadeh">

            <section class="slide-lamkadeh active">
                <div class="slider-main-right">
                    <div class="slider-main-right-content">
                        <div class="slider-main-right-content-top about-us">
                            <div class="title-main-content about-us-title">
                                <p>
                                    <?php echo wp_kses($settings['slider_title'], [
                                        'a' => ['href' => [], 'title' => [], 'target' => []],
                                        'br' => [],
                                        'strong' => [],
                                        'em' => [],
                                        'b' => [],
                                        'i' => [],
                                        'span' => ['class' => []],
                                    ]); ?>
                                </p>
                            </div>
                            <p>
                                <?php echo wp_kses($settings['slider_desc'], [
                                    'a' => ['href' => [], 'title' => [], 'target' => []],
                                    'br' => [],
                                    'strong' => [],
                                    'em' => [],
                                    'b' => [],
                                    'i' => [],
                                    'span' => ['class' => []],
                                ]); ?>
                            </p>
                            <div class="button-slider">
                                <div>
                                    <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M23.6216 13.6066C23.4648 13.7633 23.2504 13.8623 23.0029 13.8623L13.8623 13.8623L13.8623 23.0029C13.8623 23.4813 13.4664 23.8773 12.9879 23.8773C12.5094 23.8773 12.1134 23.4813 12.1134 23.0029L12.1134 12.9879C12.1134 12.5094 12.5094 12.1134 12.9879 12.1134L23.0029 12.1134C23.4813 12.1134 23.8773 12.5094 23.8773 12.9879C23.8856 13.2271 23.7783 13.4498 23.6216 13.6066Z"
                                            fill="white" />
                                        <path
                                            d="M27.6308 27.6309C27.2926 27.9691 26.7316 27.9691 26.3934 27.6309L12.5093 13.7468C12.1711 13.4086 12.1711 12.8476 12.5093 12.5094C12.8476 12.1712 13.4085 12.1712 13.7468 12.5094L27.6308 26.3934C27.9691 26.7317 27.9691 27.2926 27.6308 27.6309Z"
                                            fill="white" />
                                    </svg>
                                </div>
                                <a href="<?php echo esc_url($settings['slider_link_url']['url']) ?>"><?php echo esc_html($settings['slider_link_text']) ?></a>
                            </div>
                        </div>
                    </div>
                    <div class="slider-main-right-svg-one"> <svg width="128" height="84" viewBox="0 0 128 84" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M29.0909 56.6239C25.8776 56.6239 23.2727 54.0888 23.2727 50.9615C23.2727 47.8343 25.8776 45.2991 29.0909 45.2991C32.3042 45.2991 34.9091 47.8343 34.9091 50.9615C34.9091 54.0888 32.3042 56.6239 29.0909 56.6239Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M75.6364 56.6239C72.4231 56.6239 69.8182 54.0888 69.8182 50.9615C69.8182 47.8343 72.4231 45.2991 75.6364 45.2991C78.8497 45.2991 81.4545 47.8343 81.4545 50.9615C81.4546 54.0888 78.8497 56.6239 75.6364 56.6239Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M98.9091 56.6239C95.6958 56.6239 93.0909 54.0888 93.0909 50.9615C93.0909 47.8343 95.6958 45.2991 98.9091 45.2991C102.122 45.2991 104.727 47.8343 104.727 50.9615C104.727 54.0888 102.122 56.6239 98.9091 56.6239Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M5.81818 33.9744C2.60489 33.9744 1.144e-06 31.4392 1.00521e-06 28.312C8.66422e-07 25.1847 2.60489 22.6496 5.81818 22.6496C9.03148 22.6496 11.6364 25.1847 11.6364 28.312C11.6364 31.4392 9.03148 33.9744 5.81818 33.9744Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M29.0909 33.9744C25.8776 33.9744 23.2727 31.4392 23.2727 28.312C23.2727 25.1847 25.8776 22.6496 29.0909 22.6496C32.3042 22.6496 34.9091 25.1847 34.9091 28.312C34.9091 31.4392 32.3042 33.9744 29.0909 33.9744Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M52.3636 33.9744C49.1503 33.9744 46.5455 31.4392 46.5455 28.312C46.5455 25.1847 49.1503 22.6496 52.3636 22.6496C55.5769 22.6496 58.1818 25.1847 58.1818 28.312C58.1818 31.4392 55.5769 33.9744 52.3636 33.9744Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M98.9091 33.9744C95.6958 33.9744 93.0909 31.4392 93.0909 28.312C93.0909 25.1847 95.6958 22.6496 98.9091 22.6496C102.122 22.6496 104.727 25.1847 104.727 28.312C104.727 31.4392 102.122 33.9744 98.9091 33.9744Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M122.182 33.9744C118.969 33.9744 116.364 31.4392 116.364 28.312C116.364 25.1847 118.969 22.6496 122.182 22.6496C125.395 22.6496 128 25.1847 128 28.312C128 31.4392 125.395 33.9744 122.182 33.9744Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M5.81818 11.3248C2.60489 11.3248 1.38791e-07 8.78965 0 5.6624C-1.38791e-07 2.53514 2.60489 5.148e-06 5.81818 5.00966e-06C9.03147 4.87132e-06 11.6364 2.53514 11.6364 5.6624C11.6364 8.78965 9.03148 11.3248 5.81818 11.3248Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M52.3636 11.3248C49.1503 11.3248 46.5455 8.78965 46.5455 5.66239C46.5455 2.53514 49.1503 3.14413e-06 52.3636 3.00579e-06C55.5769 2.86746e-06 58.1818 2.53514 58.1818 5.66239C58.1818 8.78965 55.5769 11.3248 52.3636 11.3248Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M75.6364 11.3248C72.4231 11.3248 69.8182 8.78965 69.8182 5.66239C69.8182 2.53514 72.4231 2.1422e-06 75.6364 2.00386e-06C78.8497 1.86553e-06 81.4545 2.53514 81.4545 5.66239C81.4546 8.78965 78.8497 11.3248 75.6364 11.3248Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M98.9091 11.3248C95.6958 11.3248 93.0909 8.78965 93.0909 5.66239C93.0909 2.53514 95.6958 1.14027e-06 98.9091 1.00193e-06C102.122 8.63593e-07 104.727 2.53514 104.727 5.66239C104.727 8.78965 102.122 11.3248 98.9091 11.3248Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M122.182 11.3248C118.969 11.3248 116.364 8.78965 116.364 5.66239C116.364 2.53514 118.969 1.38338e-07 122.182 0C125.395 -1.38338e-07 128 2.53514 128 5.66239C128 8.78964 125.395 11.3248 122.182 11.3248Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M75.6364 33.9744C72.4231 33.9744 69.8182 31.4392 69.8182 28.312C69.8182 25.1847 72.4231 22.6496 75.6364 22.6496C78.8497 22.6496 81.4545 25.1847 81.4545 28.312C81.4546 31.4392 78.8497 33.9744 75.6364 33.9744Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M29.0909 11.3248C25.8776 11.3248 23.2727 8.78965 23.2727 5.6624C23.2727 2.53514 25.8776 4.14606e-06 29.0909 4.00773e-06C32.3042 3.86939e-06 34.9091 2.53514 34.9091 5.6624C34.9091 8.78965 32.3042 11.3248 29.0909 11.3248Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M52.3636 56.6239C49.1503 56.6239 46.5455 54.0888 46.5455 50.9615C46.5455 47.8343 49.1503 45.2991 52.3636 45.2991C55.5769 45.2991 58.1818 47.8343 58.1818 50.9615C58.1818 54.0888 55.5769 56.6239 52.3636 56.6239Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M122.182 56.6239C118.969 56.6239 116.364 54.0888 116.364 50.9615C116.364 47.8343 118.969 45.2991 122.182 45.2991C125.395 45.2991 128 47.8343 128 50.9615C128 54.0888 125.395 56.6239 122.182 56.6239Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M5.81818 56.6239C2.60489 56.6239 2.14922e-06 54.0888 2.01043e-06 50.9615C1.87164e-06 47.8343 2.60489 45.2991 5.81818 45.2991C9.03148 45.2991 11.6364 47.8343 11.6364 50.9615C11.6364 54.0888 9.03148 56.6239 5.81818 56.6239Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M29.0909 125C25.8776 125 23.2727 122.465 23.2727 119.338C23.2727 116.21 25.8776 113.675 29.0909 113.675C32.3042 113.675 34.9091 116.21 34.9091 119.338C34.9091 122.465 32.3042 125 29.0909 125Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M75.6364 125C72.4231 125 69.8182 122.465 69.8182 119.338C69.8182 116.21 72.4231 113.675 75.6364 113.675C78.8497 113.675 81.4545 116.21 81.4545 119.338C81.4546 122.465 78.8497 125 75.6364 125Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M98.9091 125C95.6958 125 93.0909 122.465 93.0909 119.338C93.0909 116.21 95.6958 113.675 98.9091 113.675C102.122 113.675 104.727 116.21 104.727 119.338C104.727 122.465 102.122 125 98.9091 125Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M5.81818 102.35C2.60489 102.35 1.144e-06 99.8153 1.00521e-06 96.688C8.66422e-07 93.5608 2.60489 91.0257 5.81818 91.0257C9.03148 91.0257 11.6364 93.5608 11.6364 96.688C11.6364 99.8153 9.03148 102.35 5.81818 102.35Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M29.0909 102.35C25.8776 102.35 23.2727 99.8153 23.2727 96.688C23.2727 93.5608 25.8776 91.0257 29.0909 91.0257C32.3042 91.0257 34.9091 93.5608 34.9091 96.688C34.9091 99.8153 32.3042 102.35 29.0909 102.35Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M52.3636 102.35C49.1503 102.35 46.5455 99.8153 46.5455 96.688C46.5455 93.5608 49.1503 91.0256 52.3636 91.0256C55.5769 91.0256 58.1818 93.5608 58.1818 96.688C58.1818 99.8153 55.5769 102.35 52.3636 102.35Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M98.9091 102.35C95.6958 102.35 93.0909 99.8153 93.0909 96.688C93.0909 93.5608 95.6958 91.0256 98.9091 91.0256C102.122 91.0256 104.727 93.5608 104.727 96.688C104.727 99.8153 102.122 102.35 98.9091 102.35Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M122.182 102.35C118.969 102.35 116.364 99.8153 116.364 96.688C116.364 93.5608 118.969 91.0256 122.182 91.0256C125.395 91.0256 128 93.5608 128 96.688C128 99.8153 125.395 102.35 122.182 102.35Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M5.81818 79.7009C2.60489 79.7009 1.38791e-07 77.1657 0 74.0385C-1.38791e-07 70.9112 2.60489 68.3761 5.81818 68.3761C9.03147 68.3761 11.6364 70.9112 11.6364 74.0385C11.6364 77.1657 9.03148 79.7009 5.81818 79.7009Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M52.3636 79.7009C49.1503 79.7009 46.5455 77.1657 46.5455 74.0385C46.5455 70.9112 49.1503 68.3761 52.3636 68.3761C55.5769 68.3761 58.1818 70.9112 58.1818 74.0385C58.1818 77.1657 55.5769 79.7009 52.3636 79.7009Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M75.6364 79.7009C72.4231 79.7009 69.8182 77.1657 69.8182 74.0385C69.8182 70.9112 72.4231 68.3761 75.6364 68.3761C78.8497 68.3761 81.4545 70.9112 81.4545 74.0385C81.4546 77.1657 78.8497 79.7009 75.6364 79.7009Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M98.9091 79.7009C95.6958 79.7009 93.0909 77.1657 93.0909 74.0385C93.0909 70.9112 95.6958 68.3761 98.9091 68.3761C102.122 68.3761 104.727 70.9112 104.727 74.0385C104.727 77.1657 102.122 79.7009 98.9091 79.7009Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M122.182 79.7009C118.969 79.7009 116.364 77.1657 116.364 74.0385C116.364 70.9112 118.969 68.3761 122.182 68.3761C125.395 68.3761 128 70.9112 128 74.0385C128 77.1657 125.395 79.7009 122.182 79.7009Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M75.6364 102.35C72.4231 102.35 69.8182 99.8153 69.8182 96.688C69.8182 93.5608 72.4231 91.0256 75.6364 91.0256C78.8497 91.0256 81.4545 93.5608 81.4545 96.688C81.4546 99.8153 78.8497 102.35 75.6364 102.35Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M29.0909 79.7009C25.8776 79.7009 23.2727 77.1657 23.2727 74.0385C23.2727 70.9112 25.8776 68.3761 29.0909 68.3761C32.3042 68.3761 34.9091 70.9112 34.9091 74.0385C34.9091 77.1657 32.3042 79.7009 29.0909 79.7009Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M52.3636 125C49.1503 125 46.5455 122.465 46.5455 119.338C46.5455 116.21 49.1503 113.675 52.3636 113.675C55.5769 113.675 58.1818 116.21 58.1818 119.338C58.1818 122.465 55.5769 125 52.3636 125Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M122.182 125C118.969 125 116.364 122.465 116.364 119.338C116.364 116.21 118.969 113.675 122.182 113.675C125.395 113.675 128 116.21 128 119.338C128 122.465 125.395 125 122.182 125Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M5.81818 125C2.60489 125 2.14922e-06 122.465 2.01043e-06 119.338C1.87164e-06 116.21 2.60489 113.675 5.81818 113.675C9.03148 113.675 11.6364 116.21 11.6364 119.338C11.6364 122.465 9.03148 125 5.81818 125Z"
                                fill="#1D2977" fill-opacity="0.12" />
                        </svg></div>
                    <div class="slider-main-right-svg-two"> <svg width="128" height="84" viewBox="0 0 128 84" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M29.0909 56.6239C25.8776 56.6239 23.2727 54.0888 23.2727 50.9615C23.2727 47.8343 25.8776 45.2991 29.0909 45.2991C32.3042 45.2991 34.9091 47.8343 34.9091 50.9615C34.9091 54.0888 32.3042 56.6239 29.0909 56.6239Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M75.6364 56.6239C72.4231 56.6239 69.8182 54.0888 69.8182 50.9615C69.8182 47.8343 72.4231 45.2991 75.6364 45.2991C78.8497 45.2991 81.4545 47.8343 81.4545 50.9615C81.4546 54.0888 78.8497 56.6239 75.6364 56.6239Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M98.9091 56.6239C95.6958 56.6239 93.0909 54.0888 93.0909 50.9615C93.0909 47.8343 95.6958 45.2991 98.9091 45.2991C102.122 45.2991 104.727 47.8343 104.727 50.9615C104.727 54.0888 102.122 56.6239 98.9091 56.6239Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M5.81818 33.9744C2.60489 33.9744 1.144e-06 31.4392 1.00521e-06 28.312C8.66422e-07 25.1847 2.60489 22.6496 5.81818 22.6496C9.03148 22.6496 11.6364 25.1847 11.6364 28.312C11.6364 31.4392 9.03148 33.9744 5.81818 33.9744Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M29.0909 33.9744C25.8776 33.9744 23.2727 31.4392 23.2727 28.312C23.2727 25.1847 25.8776 22.6496 29.0909 22.6496C32.3042 22.6496 34.9091 25.1847 34.9091 28.312C34.9091 31.4392 32.3042 33.9744 29.0909 33.9744Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M52.3636 33.9744C49.1503 33.9744 46.5455 31.4392 46.5455 28.312C46.5455 25.1847 49.1503 22.6496 52.3636 22.6496C55.5769 22.6496 58.1818 25.1847 58.1818 28.312C58.1818 31.4392 55.5769 33.9744 52.3636 33.9744Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M98.9091 33.9744C95.6958 33.9744 93.0909 31.4392 93.0909 28.312C93.0909 25.1847 95.6958 22.6496 98.9091 22.6496C102.122 22.6496 104.727 25.1847 104.727 28.312C104.727 31.4392 102.122 33.9744 98.9091 33.9744Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M122.182 33.9744C118.969 33.9744 116.364 31.4392 116.364 28.312C116.364 25.1847 118.969 22.6496 122.182 22.6496C125.395 22.6496 128 25.1847 128 28.312C128 31.4392 125.395 33.9744 122.182 33.9744Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M5.81818 11.3248C2.60489 11.3248 1.38791e-07 8.78965 0 5.6624C-1.38791e-07 2.53514 2.60489 5.148e-06 5.81818 5.00966e-06C9.03147 4.87132e-06 11.6364 2.53514 11.6364 5.6624C11.6364 8.78965 9.03148 11.3248 5.81818 11.3248Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M52.3636 11.3248C49.1503 11.3248 46.5455 8.78965 46.5455 5.66239C46.5455 2.53514 49.1503 3.14413e-06 52.3636 3.00579e-06C55.5769 2.86746e-06 58.1818 2.53514 58.1818 5.66239C58.1818 8.78965 55.5769 11.3248 52.3636 11.3248Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M75.6364 11.3248C72.4231 11.3248 69.8182 8.78965 69.8182 5.66239C69.8182 2.53514 72.4231 2.1422e-06 75.6364 2.00386e-06C78.8497 1.86553e-06 81.4545 2.53514 81.4545 5.66239C81.4546 8.78965 78.8497 11.3248 75.6364 11.3248Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M98.9091 11.3248C95.6958 11.3248 93.0909 8.78965 93.0909 5.66239C93.0909 2.53514 95.6958 1.14027e-06 98.9091 1.00193e-06C102.122 8.63593e-07 104.727 2.53514 104.727 5.66239C104.727 8.78965 102.122 11.3248 98.9091 11.3248Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M122.182 11.3248C118.969 11.3248 116.364 8.78965 116.364 5.66239C116.364 2.53514 118.969 1.38338e-07 122.182 0C125.395 -1.38338e-07 128 2.53514 128 5.66239C128 8.78964 125.395 11.3248 122.182 11.3248Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M75.6364 33.9744C72.4231 33.9744 69.8182 31.4392 69.8182 28.312C69.8182 25.1847 72.4231 22.6496 75.6364 22.6496C78.8497 22.6496 81.4545 25.1847 81.4545 28.312C81.4546 31.4392 78.8497 33.9744 75.6364 33.9744Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M29.0909 11.3248C25.8776 11.3248 23.2727 8.78965 23.2727 5.6624C23.2727 2.53514 25.8776 4.14606e-06 29.0909 4.00773e-06C32.3042 3.86939e-06 34.9091 2.53514 34.9091 5.6624C34.9091 8.78965 32.3042 11.3248 29.0909 11.3248Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M52.3636 56.6239C49.1503 56.6239 46.5455 54.0888 46.5455 50.9615C46.5455 47.8343 49.1503 45.2991 52.3636 45.2991C55.5769 45.2991 58.1818 47.8343 58.1818 50.9615C58.1818 54.0888 55.5769 56.6239 52.3636 56.6239Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M122.182 56.6239C118.969 56.6239 116.364 54.0888 116.364 50.9615C116.364 47.8343 118.969 45.2991 122.182 45.2991C125.395 45.2991 128 47.8343 128 50.9615C128 54.0888 125.395 56.6239 122.182 56.6239Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M5.81818 56.6239C2.60489 56.6239 2.14922e-06 54.0888 2.01043e-06 50.9615C1.87164e-06 47.8343 2.60489 45.2991 5.81818 45.2991C9.03148 45.2991 11.6364 47.8343 11.6364 50.9615C11.6364 54.0888 9.03148 56.6239 5.81818 56.6239Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M29.0909 125C25.8776 125 23.2727 122.465 23.2727 119.338C23.2727 116.21 25.8776 113.675 29.0909 113.675C32.3042 113.675 34.9091 116.21 34.9091 119.338C34.9091 122.465 32.3042 125 29.0909 125Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M75.6364 125C72.4231 125 69.8182 122.465 69.8182 119.338C69.8182 116.21 72.4231 113.675 75.6364 113.675C78.8497 113.675 81.4545 116.21 81.4545 119.338C81.4546 122.465 78.8497 125 75.6364 125Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M98.9091 125C95.6958 125 93.0909 122.465 93.0909 119.338C93.0909 116.21 95.6958 113.675 98.9091 113.675C102.122 113.675 104.727 116.21 104.727 119.338C104.727 122.465 102.122 125 98.9091 125Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M5.81818 102.35C2.60489 102.35 1.144e-06 99.8153 1.00521e-06 96.688C8.66422e-07 93.5608 2.60489 91.0257 5.81818 91.0257C9.03148 91.0257 11.6364 93.5608 11.6364 96.688C11.6364 99.8153 9.03148 102.35 5.81818 102.35Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M29.0909 102.35C25.8776 102.35 23.2727 99.8153 23.2727 96.688C23.2727 93.5608 25.8776 91.0257 29.0909 91.0257C32.3042 91.0257 34.9091 93.5608 34.9091 96.688C34.9091 99.8153 32.3042 102.35 29.0909 102.35Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M52.3636 102.35C49.1503 102.35 46.5455 99.8153 46.5455 96.688C46.5455 93.5608 49.1503 91.0256 52.3636 91.0256C55.5769 91.0256 58.1818 93.5608 58.1818 96.688C58.1818 99.8153 55.5769 102.35 52.3636 102.35Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M98.9091 102.35C95.6958 102.35 93.0909 99.8153 93.0909 96.688C93.0909 93.5608 95.6958 91.0256 98.9091 91.0256C102.122 91.0256 104.727 93.5608 104.727 96.688C104.727 99.8153 102.122 102.35 98.9091 102.35Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M122.182 102.35C118.969 102.35 116.364 99.8153 116.364 96.688C116.364 93.5608 118.969 91.0256 122.182 91.0256C125.395 91.0256 128 93.5608 128 96.688C128 99.8153 125.395 102.35 122.182 102.35Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M5.81818 79.7009C2.60489 79.7009 1.38791e-07 77.1657 0 74.0385C-1.38791e-07 70.9112 2.60489 68.3761 5.81818 68.3761C9.03147 68.3761 11.6364 70.9112 11.6364 74.0385C11.6364 77.1657 9.03148 79.7009 5.81818 79.7009Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M52.3636 79.7009C49.1503 79.7009 46.5455 77.1657 46.5455 74.0385C46.5455 70.9112 49.1503 68.3761 52.3636 68.3761C55.5769 68.3761 58.1818 70.9112 58.1818 74.0385C58.1818 77.1657 55.5769 79.7009 52.3636 79.7009Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M75.6364 79.7009C72.4231 79.7009 69.8182 77.1657 69.8182 74.0385C69.8182 70.9112 72.4231 68.3761 75.6364 68.3761C78.8497 68.3761 81.4545 70.9112 81.4545 74.0385C81.4546 77.1657 78.8497 79.7009 75.6364 79.7009Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M98.9091 79.7009C95.6958 79.7009 93.0909 77.1657 93.0909 74.0385C93.0909 70.9112 95.6958 68.3761 98.9091 68.3761C102.122 68.3761 104.727 70.9112 104.727 74.0385C104.727 77.1657 102.122 79.7009 98.9091 79.7009Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M122.182 79.7009C118.969 79.7009 116.364 77.1657 116.364 74.0385C116.364 70.9112 118.969 68.3761 122.182 68.3761C125.395 68.3761 128 70.9112 128 74.0385C128 77.1657 125.395 79.7009 122.182 79.7009Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M75.6364 102.35C72.4231 102.35 69.8182 99.8153 69.8182 96.688C69.8182 93.5608 72.4231 91.0256 75.6364 91.0256C78.8497 91.0256 81.4545 93.5608 81.4545 96.688C81.4546 99.8153 78.8497 102.35 75.6364 102.35Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M29.0909 79.7009C25.8776 79.7009 23.2727 77.1657 23.2727 74.0385C23.2727 70.9112 25.8776 68.3761 29.0909 68.3761C32.3042 68.3761 34.9091 70.9112 34.9091 74.0385C34.9091 77.1657 32.3042 79.7009 29.0909 79.7009Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M52.3636 125C49.1503 125 46.5455 122.465 46.5455 119.338C46.5455 116.21 49.1503 113.675 52.3636 113.675C55.5769 113.675 58.1818 116.21 58.1818 119.338C58.1818 122.465 55.5769 125 52.3636 125Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M122.182 125C118.969 125 116.364 122.465 116.364 119.338C116.364 116.21 118.969 113.675 122.182 113.675C125.395 113.675 128 116.21 128 119.338C128 122.465 125.395 125 122.182 125Z"
                                fill="#1D2977" fill-opacity="0.12" />
                            <path
                                d="M5.81818 125C2.60489 125 2.14922e-06 122.465 2.01043e-06 119.338C1.87164e-06 116.21 2.60489 113.675 5.81818 113.675C9.03148 113.675 11.6364 116.21 11.6364 119.338C11.6364 122.465 9.03148 125 5.81818 125Z"
                                fill="#1D2977" fill-opacity="0.12" />
                        </svg></div>
                </div>
                <div class="slider-main-image">
                    <div class="slider-main-content-image">
                        <?php
                        if (! empty($settings['slider_banner']['url'])) {
                            echo '<img src="' . esc_url($settings['slider_banner']['url']) . '" alt="' . esc_attr($settings['slider_title']) . '">';
                        }
                        ?>
                        <div class="slider-main-shape-back">
                            <span><?php echo $settings['slider_banner_text'] ?></span>
                            <?php
                            if (! empty($settings['slider_theme_image']['url'])) {
                                echo '<img src="' . esc_url($settings['slider_theme_image']['url']) . '" alt="' . esc_attr($settings['slider_title']) . '">';
                            }
                            ?>
                            <div class="slider-main-circle-big"></div>
                            <div class="slider-main-circle-small"></div>
                        </div>
                    </div>
                    <div class="slider-main-dashed-shape"></div>
                </div>
                <div class="slider-main-left">
                    <div class="lamp-slider-main">
                        <?php
                        if (! empty($settings['slider_theme_two_image']['url'])) {
                            echo '<img src="' . esc_url($settings['slider_theme_two_image']['url']) . '" alt="' . esc_attr($settings['slider_title']) . '">';
                        }
                        ?>
                    </div>
                    <div class="theme-icon-shape-one">
                        <svg width="199" height="196" viewBox="0 0 199 196" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M45.2273 88.8772C40.2316 88.8772 36.1818 84.9414 36.1818 80.0862C36.1818 75.2311 40.2316 71.2952 45.2273 71.2952C50.2229 71.2952 54.2727 75.2311 54.2727 80.0862C54.2727 84.9414 50.2229 88.8772 45.2273 88.8772Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M117.591 88.8772C112.595 88.8772 108.545 84.9414 108.545 80.0862C108.545 75.2311 112.595 71.2952 117.591 71.2952C122.587 71.2952 126.636 75.2311 126.636 80.0862C126.636 84.9414 122.587 88.8772 117.591 88.8772Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M153.773 88.8772C148.777 88.8772 144.727 84.9414 144.727 80.0862C144.727 75.2311 148.777 71.2952 153.773 71.2952C158.768 71.2952 162.818 75.2311 162.818 80.0862C162.818 84.9414 158.768 88.8772 153.773 88.8772Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M9.04546 53.7131C4.04979 53.7131 1.77857e-06 49.7773 1.56279e-06 44.9221C1.34701e-06 40.067 4.04979 36.1311 9.04545 36.1311C14.0411 36.1311 18.0909 40.0669 18.0909 44.9221C18.0909 49.7772 14.0411 53.7131 9.04546 53.7131Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M45.2273 53.7131C40.2316 53.7131 36.1818 49.7772 36.1818 44.9221C36.1818 40.0669 40.2316 36.1311 45.2273 36.1311C50.2229 36.1311 54.2727 40.0669 54.2727 44.9221C54.2727 49.7772 50.2229 53.7131 45.2273 53.7131Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M81.4091 53.7131C76.4134 53.7131 72.3636 49.7772 72.3636 44.9221C72.3636 40.0669 76.4134 36.1311 81.4091 36.1311C86.4048 36.1311 90.4545 40.0669 90.4545 44.9221C90.4545 49.7772 86.4048 53.7131 81.4091 53.7131Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M153.773 53.7131C148.777 53.7131 144.727 49.7772 144.727 44.9221C144.727 40.0669 148.777 36.1311 153.773 36.1311C158.768 36.1311 162.818 40.0669 162.818 44.9221C162.818 49.7772 158.768 53.7131 153.773 53.7131Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M189.955 53.7131C184.959 53.7131 180.909 49.7772 180.909 44.9221C180.909 40.0669 184.959 36.1311 189.955 36.1311C194.95 36.1311 199 40.0669 199 44.9221C199 49.7772 194.95 53.7131 189.955 53.7131Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M9.04545 18.549C4.04979 18.549 2.15777e-07 14.6131 0 9.75798C-2.15777e-07 4.90283 4.04979 0.966957 9.04545 0.966957C14.0411 0.966957 18.0909 4.90283 18.0909 9.75798C18.0909 14.6131 14.0411 18.549 9.04545 18.549Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M81.4091 18.549C76.4134 18.549 72.3636 14.6131 72.3636 9.75798C72.3636 4.90283 76.4134 0.966954 81.4091 0.966954C86.4048 0.966954 90.4545 4.90283 90.4545 9.75798C90.4545 14.6131 86.4048 18.549 81.4091 18.549Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M117.591 18.549C112.595 18.549 108.545 14.6131 108.545 9.75798C108.545 4.90283 112.595 0.966953 117.591 0.966953C122.587 0.966952 126.636 4.90283 126.636 9.75798C126.636 14.6131 122.587 18.549 117.591 18.549Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M153.773 18.549C148.777 18.549 144.727 14.6131 144.727 9.75798C144.727 4.90283 148.777 0.966951 153.773 0.966951C158.768 0.966951 162.818 4.90283 162.818 9.75798C162.818 14.6131 158.768 18.549 153.773 18.549Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M189.955 18.549C184.959 18.549 180.909 14.6131 180.909 9.75798C180.909 4.90282 184.959 0.96695 189.955 0.966949C194.95 0.966949 199 4.90282 199 9.75797C199 14.6131 194.95 18.549 189.955 18.549Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M117.591 53.7131C112.595 53.7131 108.545 49.7772 108.545 44.9221C108.545 40.0669 112.595 36.1311 117.591 36.1311C122.587 36.1311 126.636 40.0669 126.636 44.9221C126.636 49.7772 122.587 53.7131 117.591 53.7131Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M45.2273 18.549C40.2316 18.549 36.1818 14.6131 36.1818 9.75798C36.1818 4.90283 40.2316 0.966956 45.2273 0.966956C50.2229 0.966955 54.2727 4.90283 54.2727 9.75798C54.2727 14.6131 50.2229 18.549 45.2273 18.549Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M81.4091 88.8772C76.4134 88.8772 72.3636 84.9414 72.3636 80.0862C72.3636 75.2311 76.4134 71.2952 81.4091 71.2952C86.4048 71.2952 90.4545 75.2311 90.4545 80.0862C90.4545 84.9414 86.4048 88.8772 81.4091 88.8772Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M189.955 88.8772C184.959 88.8772 180.909 84.9414 180.909 80.0862C180.909 75.2311 184.959 71.2952 189.955 71.2952C194.95 71.2952 199 75.2311 199 80.0862C199 84.9414 194.95 88.8772 189.955 88.8772Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M9.04546 88.8772C4.04979 88.8772 3.34136e-06 84.9414 3.12559e-06 80.0862C2.90981e-06 75.2311 4.04979 71.2952 9.04546 71.2952C14.0411 71.2952 18.0909 75.2311 18.0909 80.0862C18.0909 84.9414 14.0411 88.8772 9.04546 88.8772Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M45.2273 195.033C40.2316 195.033 36.1818 191.097 36.1818 186.242C36.1818 181.387 40.2316 177.451 45.2273 177.451C50.2229 177.451 54.2727 181.387 54.2727 186.242C54.2727 191.097 50.2229 195.033 45.2273 195.033Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M117.591 195.033C112.595 195.033 108.545 191.097 108.545 186.242C108.545 181.387 112.595 177.451 117.591 177.451C122.587 177.451 126.636 181.387 126.636 186.242C126.636 191.097 122.587 195.033 117.591 195.033Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M153.773 195.033C148.777 195.033 144.727 191.097 144.727 186.242C144.727 181.387 148.777 177.451 153.773 177.451C158.768 177.451 162.818 181.387 162.818 186.242C162.818 191.097 158.768 195.033 153.773 195.033Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M9.04546 159.869C4.04979 159.869 1.77857e-06 155.933 1.56279e-06 151.078C1.34701e-06 146.223 4.04979 142.287 9.04545 142.287C14.0411 142.287 18.0909 146.223 18.0909 151.078C18.0909 155.933 14.0411 159.869 9.04546 159.869Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M45.2273 159.869C40.2316 159.869 36.1818 155.933 36.1818 151.078C36.1818 146.223 40.2316 142.287 45.2273 142.287C50.2229 142.287 54.2727 146.223 54.2727 151.078C54.2727 155.933 50.2229 159.869 45.2273 159.869Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M81.4091 159.869C76.4134 159.869 72.3636 155.933 72.3636 151.078C72.3636 146.223 76.4134 142.287 81.4091 142.287C86.4048 142.287 90.4545 146.223 90.4545 151.078C90.4545 155.933 86.4048 159.869 81.4091 159.869Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M153.773 159.869C148.777 159.869 144.727 155.933 144.727 151.078C144.727 146.223 148.777 142.287 153.773 142.287C158.768 142.287 162.818 146.223 162.818 151.078C162.818 155.933 158.768 159.869 153.773 159.869Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M189.955 159.869C184.959 159.869 180.909 155.933 180.909 151.078C180.909 146.223 184.959 142.287 189.955 142.287C194.95 142.287 199 146.223 199 151.078C199 155.933 194.95 159.869 189.955 159.869Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M9.04545 124.705C4.04979 124.705 2.15777e-07 120.769 0 115.914C-2.15777e-07 111.059 4.04979 107.123 9.04545 107.123C14.0411 107.123 18.0909 111.059 18.0909 115.914C18.0909 120.769 14.0411 124.705 9.04545 124.705Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M81.4091 124.705C76.4134 124.705 72.3636 120.769 72.3636 115.914C72.3636 111.059 76.4134 107.123 81.4091 107.123C86.4048 107.123 90.4545 111.059 90.4545 115.914C90.4545 120.769 86.4048 124.705 81.4091 124.705Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M117.591 124.705C112.595 124.705 108.545 120.769 108.545 115.914C108.545 111.059 112.595 107.123 117.591 107.123C122.587 107.123 126.636 111.059 126.636 115.914C126.636 120.769 122.587 124.705 117.591 124.705Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M153.773 124.705C148.777 124.705 144.727 120.769 144.727 115.914C144.727 111.059 148.777 107.123 153.773 107.123C158.768 107.123 162.818 111.059 162.818 115.914C162.818 120.769 158.768 124.705 153.773 124.705Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M189.955 124.705C184.959 124.705 180.909 120.769 180.909 115.914C180.909 111.059 184.959 107.123 189.955 107.123C194.95 107.123 199 111.059 199 115.914C199 120.769 194.95 124.705 189.955 124.705Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M117.591 159.869C112.595 159.869 108.545 155.933 108.545 151.078C108.545 146.223 112.595 142.287 117.591 142.287C122.587 142.287 126.636 146.223 126.636 151.078C126.636 155.933 122.587 159.869 117.591 159.869Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M45.2273 124.705C40.2316 124.705 36.1818 120.769 36.1818 115.914C36.1818 111.059 40.2316 107.123 45.2273 107.123C50.2229 107.123 54.2727 111.059 54.2727 115.914C54.2727 120.769 50.2229 124.705 45.2273 124.705Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M81.4091 195.033C76.4134 195.033 72.3636 191.097 72.3636 186.242C72.3636 181.387 76.4134 177.451 81.4091 177.451C86.4048 177.451 90.4545 181.387 90.4545 186.242C90.4545 191.097 86.4048 195.033 81.4091 195.033Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M189.955 195.033C184.959 195.033 180.909 191.097 180.909 186.242C180.909 181.387 184.959 177.451 189.955 177.451C194.95 177.451 199 181.387 199 186.242C199 191.097 194.95 195.033 189.955 195.033Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M9.04546 195.033C4.04979 195.033 3.34136e-06 191.097 3.12559e-06 186.242C2.90981e-06 181.387 4.04979 177.451 9.04546 177.451C14.0411 177.451 18.0909 181.387 18.0909 186.242C18.0909 191.097 14.0411 195.033 9.04546 195.033Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                        </svg>
                    </div>
                    <div class="theme-icon-shape-two">
                        <svg width="80" height="77" viewBox="0 0 80 77" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M5.81818 25.5812C3.40821 25.5812 1.45455 23.6748 1.45455 21.3231C1.45455 18.9714 3.40821 17.065 5.81818 17.065C8.22815 17.065 10.1818 18.9714 10.1818 21.3231C10.1818 23.6748 8.22815 25.5812 5.81818 25.5812Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M40.7273 25.5812C38.3173 25.5812 36.3636 23.6748 36.3636 21.3231C36.3636 18.9714 38.3173 17.065 40.7273 17.065C43.1372 17.065 45.0909 18.9714 45.0909 21.3231C45.0909 23.6748 43.1372 25.5812 40.7273 25.5812Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M58.1818 25.5812C55.7719 25.5812 53.8182 23.6748 53.8182 21.3231C53.8182 18.9714 55.7718 17.065 58.1818 17.065C60.5918 17.065 62.5455 18.9714 62.5455 21.3231C62.5455 23.6748 60.5918 25.5812 58.1818 25.5812Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M-11.6364 8.54872C-14.0463 8.54872 -16 6.6423 -16 4.2906C-16 1.93891 -14.0463 0.0324802 -11.6364 0.0324802C-9.22639 0.0324802 -7.27273 1.93891 -7.27273 4.2906C-7.27273 6.64229 -9.22639 8.54872 -11.6364 8.54872Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M5.81818 8.54872C3.40821 8.54872 1.45455 6.64229 1.45455 4.2906C1.45455 1.93891 3.40821 0.0324802 5.81818 0.0324802C8.22815 0.0324802 10.1818 1.93891 10.1818 4.2906C10.1818 6.64229 8.22815 8.54872 5.81818 8.54872Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M23.2727 8.54872C20.8628 8.54872 18.9091 6.64229 18.9091 4.2906C18.9091 1.93891 20.8628 0.0324802 23.2727 0.0324802C25.6827 0.0324802 27.6364 1.9389 27.6364 4.2906C27.6364 6.64229 25.6827 8.54872 23.2727 8.54872Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M58.1818 8.54872C55.7718 8.54872 53.8182 6.64229 53.8182 4.2906C53.8182 1.9389 55.7718 0.0324783 58.1818 0.0324783C60.5918 0.0324783 62.5455 1.9389 62.5455 4.2906C62.5455 6.64229 60.5918 8.54872 58.1818 8.54872Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M75.6364 8.54872C73.2264 8.54872 71.2727 6.64229 71.2727 4.2906C71.2727 1.9389 73.2264 0.0324764 75.6364 0.0324764C78.0463 0.0324764 80 1.9389 80 4.2906C80 6.64229 78.0463 8.54872 75.6364 8.54872Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M-11.6364 -8.48376C-14.0463 -8.48376 -16 -10.3902 -16 -12.7419C-16 -15.0936 -14.0463 -17 -11.6364 -17C-9.22639 -17 -7.27273 -15.0936 -7.27273 -12.7419C-7.27273 -10.3902 -9.22639 -8.48376 -11.6364 -8.48376Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M23.2727 -8.48376C20.8628 -8.48376 18.9091 -10.3902 18.9091 -12.7419C18.9091 -15.0936 20.8628 -17 23.2727 -17C25.6827 -17 27.6364 -15.0936 27.6364 -12.7419C27.6364 -10.3902 25.6827 -8.48376 23.2727 -8.48376Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M40.7273 -8.48376C38.3173 -8.48376 36.3636 -10.3902 36.3636 -12.7419C36.3636 -15.0936 38.3173 -17 40.7273 -17C43.1372 -17 45.0909 -15.0936 45.0909 -12.7419C45.0909 -10.3902 43.1372 -8.48376 40.7273 -8.48376Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M58.1818 -8.48376C55.7718 -8.48376 53.8182 -10.3902 53.8182 -12.7419C53.8182 -15.0936 55.7718 -17 58.1818 -17C60.5918 -17 62.5455 -15.0936 62.5455 -12.7419C62.5455 -10.3902 60.5918 -8.48376 58.1818 -8.48376Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M75.6364 -8.48376C73.2264 -8.48376 71.2727 -10.3902 71.2727 -12.7419C71.2727 -15.0936 73.2264 -17 75.6364 -17C78.0463 -17 80 -15.0936 80 -12.7419C80 -10.3902 78.0463 -8.48376 75.6364 -8.48376Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M40.7273 8.54872C38.3173 8.54872 36.3636 6.64229 36.3636 4.2906C36.3636 1.9389 38.3173 0.0324783 40.7273 0.0324783C43.1372 0.0324783 45.0909 1.9389 45.0909 4.2906C45.0909 6.64229 43.1372 8.54872 40.7273 8.54872Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M5.81818 -8.48376C3.40821 -8.48376 1.45455 -10.3902 1.45455 -12.7419C1.45455 -15.0936 3.40821 -17 5.81818 -17C8.22815 -17 10.1818 -15.0936 10.1818 -12.7419C10.1818 -10.3902 8.22815 -8.48376 5.81818 -8.48376Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M23.2727 25.5812C20.8628 25.5812 18.9091 23.6748 18.9091 21.3231C18.9091 18.9714 20.8628 17.065 23.2727 17.065C25.6827 17.065 27.6364 18.9714 27.6364 21.3231C27.6364 23.6748 25.6827 25.5812 23.2727 25.5812Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M75.6364 25.5812C73.2264 25.5812 71.2727 23.6748 71.2727 21.3231C71.2727 18.9714 73.2264 17.065 75.6364 17.065C78.0463 17.065 80 18.9714 80 21.3231C80 23.6748 78.0463 25.5812 75.6364 25.5812Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M-11.6364 25.5812C-14.0463 25.5812 -16 23.6748 -16 21.3231C-16 18.9714 -14.0463 17.065 -11.6364 17.065C-9.22639 17.065 -7.27273 18.9714 -7.27273 21.3231C-7.27273 23.6748 -9.22639 25.5812 -11.6364 25.5812Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M5.81818 77C3.40821 77 1.45455 75.0936 1.45455 72.7419C1.45455 70.3902 3.40821 68.4838 5.81818 68.4838C8.22815 68.4838 10.1818 70.3902 10.1818 72.7419C10.1818 75.0936 8.22815 77 5.81818 77Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M40.7273 77C38.3173 77 36.3636 75.0936 36.3636 72.7419C36.3636 70.3902 38.3173 68.4838 40.7273 68.4838C43.1372 68.4838 45.0909 70.3902 45.0909 72.7419C45.0909 75.0936 43.1372 77 40.7273 77Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M58.1818 77C55.7719 77 53.8182 75.0936 53.8182 72.7419C53.8182 70.3902 55.7718 68.4838 58.1818 68.4838C60.5918 68.4838 62.5455 70.3902 62.5455 72.7419C62.5455 75.0936 60.5918 77 58.1818 77Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M-11.6364 59.9675C-14.0463 59.9675 -16 58.0611 -16 55.7094C-16 53.3577 -14.0463 51.4513 -11.6364 51.4513C-9.22639 51.4513 -7.27273 53.3577 -7.27273 55.7094C-7.27273 58.0611 -9.22639 59.9675 -11.6364 59.9675Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M5.81818 59.9675C3.40821 59.9675 1.45455 58.0611 1.45455 55.7094C1.45455 53.3577 3.40821 51.4513 5.81818 51.4513C8.22815 51.4513 10.1818 53.3577 10.1818 55.7094C10.1818 58.0611 8.22815 59.9675 5.81818 59.9675Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M23.2727 59.9675C20.8628 59.9675 18.9091 58.0611 18.9091 55.7094C18.9091 53.3577 20.8628 51.4513 23.2727 51.4513C25.6827 51.4513 27.6364 53.3577 27.6364 55.7094C27.6364 58.0611 25.6827 59.9675 23.2727 59.9675Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M58.1818 59.9675C55.7718 59.9675 53.8182 58.0611 53.8182 55.7094C53.8182 53.3577 55.7718 51.4513 58.1818 51.4513C60.5918 51.4513 62.5455 53.3577 62.5455 55.7094C62.5455 58.0611 60.5918 59.9675 58.1818 59.9675Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M75.6364 59.9675C73.2264 59.9675 71.2727 58.0611 71.2727 55.7094C71.2727 53.3577 73.2264 51.4513 75.6364 51.4513C78.0463 51.4513 80 53.3577 80 55.7094C80 58.0611 78.0463 59.9675 75.6364 59.9675Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M-11.6364 42.935C-14.0463 42.935 -16 41.0286 -16 38.6769C-16 36.3252 -14.0463 34.4188 -11.6364 34.4188C-9.22639 34.4188 -7.27273 36.3252 -7.27273 38.6769C-7.27273 41.0286 -9.22639 42.935 -11.6364 42.935Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M23.2727 42.935C20.8628 42.935 18.9091 41.0286 18.9091 38.6769C18.9091 36.3252 20.8628 34.4188 23.2727 34.4188C25.6827 34.4188 27.6364 36.3252 27.6364 38.6769C27.6364 41.0286 25.6827 42.935 23.2727 42.935Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M40.7273 42.935C38.3173 42.935 36.3636 41.0286 36.3636 38.6769C36.3636 36.3252 38.3173 34.4188 40.7273 34.4188C43.1372 34.4188 45.0909 36.3252 45.0909 38.6769C45.0909 41.0286 43.1372 42.935 40.7273 42.935Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M58.1818 42.935C55.7718 42.935 53.8182 41.0286 53.8182 38.6769C53.8182 36.3252 55.7718 34.4188 58.1818 34.4188C60.5918 34.4188 62.5455 36.3252 62.5455 38.6769C62.5455 41.0286 60.5918 42.935 58.1818 42.935Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M75.6364 42.935C73.2264 42.935 71.2727 41.0286 71.2727 38.6769C71.2727 36.3252 73.2264 34.4188 75.6364 34.4188C78.0463 34.4188 80 36.3252 80 38.6769C80 41.0286 78.0463 42.935 75.6364 42.935Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M40.7273 59.9675C38.3173 59.9675 36.3636 58.0611 36.3636 55.7094C36.3636 53.3577 38.3173 51.4513 40.7273 51.4513C43.1372 51.4513 45.0909 53.3577 45.0909 55.7094C45.0909 58.0611 43.1372 59.9675 40.7273 59.9675Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M5.81818 42.935C3.40821 42.935 1.45455 41.0286 1.45455 38.6769C1.45455 36.3252 3.40821 34.4188 5.81818 34.4188C8.22815 34.4188 10.1818 36.3252 10.1818 38.6769C10.1818 41.0286 8.22815 42.935 5.81818 42.935Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M23.2727 77C20.8628 77 18.9091 75.0936 18.9091 72.7419C18.9091 70.3902 20.8628 68.4838 23.2727 68.4838C25.6827 68.4838 27.6364 70.3902 27.6364 72.7419C27.6364 75.0936 25.6827 77 23.2727 77Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M75.6364 77C73.2264 77 71.2727 75.0936 71.2727 72.7419C71.2727 70.3902 73.2264 68.4838 75.6364 68.4838C78.0463 68.4838 80 70.3902 80 72.7419C80 75.0936 78.0463 77 75.6364 77Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                            <path
                                d="M-11.6364 77C-14.0463 77 -16 75.0936 -16 72.7419C-16 70.3902 -14.0463 68.4838 -11.6364 68.4838C-9.22639 68.4838 -7.27273 70.3902 -7.27273 72.7419C-7.27273 75.0936 -9.22639 77 -11.6364 77Z"
                                fill="#F7F8FD" fill-opacity="0.64" />
                        </svg>
                    </div>
                </div>
            </section>
        </section>
<?php
    }
}
