<?php
// Template Name: قالب وبلاگ
get_header();
?>

<main class="container">
    <?php breadcrumb() ?>
    <section class="blog-section">
        <section class="sidebar-sticky">
            <?php dynamic_sidebar('blog-sidebar'); ?>
        </section>

        <section class="items-blog-archive">
            <?php
            // --- دریافت پارامترهای URL
            $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
            $posts_per_page = get_option('posts_per_page');
            $sort = isset($_GET['sort']) ? sanitize_text_field($_GET['sort']) : 'newest';

            // --- تنظیم مرتب‌سازی
            $query_args = [
                'post_type'      => 'post',
                'posts_per_page' => $posts_per_page,
                'paged'          => $paged,
            ];

            switch ($sort) {
                case 'oldest':
                    $query_args['orderby'] = 'date';
                    $query_args['order'] = 'ASC';
                    break;
                case 'popular':
                    // اگر از افزونه Post Views Counter استفاده می‌کنی:
                    $query_args['meta_key'] = 'post_views_count';
                    $query_args['orderby'] = 'meta_value_num';
                    $query_args['order'] = 'DESC';
                    break;
                default:
                    // جدیدترین‌ها
                    $query_args['orderby'] = 'date';
                    $query_args['order'] = 'DESC';
                    break;
            }

            $query = new WP_Query($query_args);
            ?>

            <!-- فیلتر مرتب سازی -->
            <section class="filter-archive-blog">
                <span><?php echo __("مرتب سازی:", "lamkadeh"); ?></span>
                <div>
                    <a href="<?php echo add_query_arg('sort', 'newest'); ?>" class="<?php echo ($sort === 'newest') ? 'active' : ''; ?>">
                        <?php echo __("جدیدترین ها", "lamkadeh"); ?>
                    </a>

                    <a href="<?php echo add_query_arg('sort', 'popular'); ?>" class="<?php echo ($sort === 'popular') ? 'active' : ''; ?>">
                        <?php echo __("پربازدید ترین ها", "lamkadeh"); ?>
                    </a>

                    <a href="<?php echo add_query_arg('sort', 'oldest'); ?>" class="<?php echo ($sort === 'oldest') ? 'active' : ''; ?>">
                        <?php echo __("قدیمی ترین ها", "lamkadeh"); ?>
                    </a>
                </div>
            </section>

            <?php if ($query->have_posts()) : ?>
                <?php while ($query->have_posts()) : $query->the_post(); ?>
                    <div class="item-blog">
                        <a href="<?php the_permalink(); ?>" class="item-blog-thumbnail">
                            <?php if (has_post_thumbnail()) : ?>
                                <?php the_post_thumbnail('medium'); ?>
                            <?php else : ?>
                                <img src="https://placehold.co/1200x600?text=LAMKADEH" alt="<?php the_title(); ?>">
                            <?php endif; ?>
                            <div class="arrow-angle-cover-item-blog">
                                <svg width="29" height="29" viewBox="0 0 29 29" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M16.3976 8.97965C16.4409 9.3221 16.1984 9.63482 15.8559 9.67813L10.3377 10.376L19.6819 17.622C19.9546 17.8335 20.0043 18.2261 19.7928 18.4989C19.5812 18.7717 19.1886 18.8213 18.9159 18.6098L9.57171 11.3638L10.2696 16.8821C10.3129 17.2245 10.0704 17.5372 9.72797 17.5805C9.38552 17.6238 9.0728 17.3813 9.02949 17.0389L8.14227 10.0237C8.09896 9.68126 8.34146 9.36854 8.68391 9.32523L15.6991 8.43801C16.0415 8.3947 16.3543 8.6372 16.3976 8.97965Z" fill="#1D2977" />
                                </svg>
                            </div>
                        </a>

                        <?php
                        $categories = get_the_category();
                        if (!empty($categories)) :
                            $first_category = $categories[0];
                        ?>
                            <a href="<?php echo esc_url(get_category_link($first_category->term_id)); ?>" class="item-blog-category">
                                <?php echo esc_html($first_category->name); ?>
                            </a>
                        <?php endif; ?>

                        <h2 class="item-blog-title">
                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                        </h2>

                        <div class="item-blog-meta">
                            <div class="item-blog-time">
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M10.0003 2.2915C5.74313 2.2915 2.29199 5.74264 2.29199 9.99984C2.29199 14.257 5.74313 17.7082 10.0003 17.7082C14.2575 17.7082 17.7087 14.257 17.7087 9.99984C17.7087 5.74264 14.2575 2.2915 10.0003 2.2915ZM1.04199 9.99984C1.04199 5.05229 5.05277 1.0415 10.0003 1.0415C14.9479 1.0415 18.9587 5.05229 18.9587 9.99984C18.9587 14.9474 14.9479 18.9582 10.0003 18.9582C5.05277 18.9582 1.04199 14.9474 1.04199 9.99984ZM10.0003 6.0415C10.3455 6.0415 10.6253 6.32133 10.6253 6.6665V9.74095L12.5256 11.6412C12.7697 11.8853 12.7697 12.281 12.5256 12.5251C12.2815 12.7692 11.8858 12.7692 11.6417 12.5251L9.55838 10.4418C9.44117 10.3246 9.37533 10.1656 9.37533 9.99984V6.6665C9.37533 6.32133 9.65515 6.0415 10.0003 6.0415Z"
                                        fill="#020308" fill-opacity="0.64" />
                                </svg>
                                <span><?php echo __('زمان مطالعه: ', 'lamkadeh'); ?><?php echo rand(3, 8); ?> دقیقه</span>
                            </div>

                            <div class="item-blog-likes">
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M4.6868 3.68675C3.30431 4.31869 2.2915 5.82179 2.2915 7.61417C2.2915 9.44534 3.04085 10.8568 4.11508 12.0664C5.00044 13.0634 6.0722 13.8896 7.11744 14.6954C7.3657 14.8868 7.61246 15.0771 7.85488 15.2682C8.29324 15.6137 8.68427 15.917 9.06118 16.1373C9.43829 16.3576 9.74184 16.4583 9.99984 16.4583C10.2578 16.4583 10.5614 16.3576 10.9385 16.1373C11.3154 15.917 11.7064 15.6137 12.1448 15.2682C12.3872 15.0771 12.634 14.8868 12.8822 14.6954C13.9275 13.8896 14.9992 13.0634 15.8846 12.0664C16.9588 10.8568 17.7082 9.44534 17.7082 7.61417C17.7082 5.82179 16.6954 4.31869 15.3129 3.68675C13.9698 3.07282 12.1651 3.23541 10.4501 5.0172C10.3323 5.13962 10.1697 5.20879 9.99984 5.20879C9.82994 5.20879 9.66735 5.13962 9.54953 5.0172C7.83456 3.23541 6.02989 3.07282 4.6868 3.68675ZM9.99984 3.71561C8.07313 1.99179 5.91564 1.75065 4.16714 2.54989C2.32043 3.39403 1.0415 5.35412 1.0415 7.61417C1.0415 9.83545 1.96692 11.53 3.18044 12.8964C4.15223 13.9907 5.34169 14.9066 6.39219 15.7154C6.63033 15.8988 6.86132 16.0766 7.08102 16.2498C7.50788 16.5863 7.96612 16.9452 8.43052 17.2165C8.89472 17.4878 9.42451 17.7083 9.99984 17.7083C10.5752 17.7083 11.105 17.4878 11.5692 17.2165C12.0336 16.9452 12.4918 16.5863 12.9187 16.2498C13.1384 16.0766 13.3693 15.8988 13.6075 15.7154C14.658 14.9066 15.8474 13.9907 16.8192 12.8964C18.0328 11.53 18.9582 9.83545 18.9582 7.61417C18.9582 5.35412 17.6792 3.39403 15.8325 2.54989C14.084 1.75065 11.9266 1.99179 9.99984 3.71561Z"
                                        fill="#1D2977" />
                                </svg>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>

                <!-- صفحه‌بندی -->
                <?php lamkadeh_blog_pagination($query); ?>

            <?php else : ?>
                <p><?php _e('هیچ مقاله‌ای یافت نشد.', 'lamkadeh'); ?></p>
            <?php endif; ?>

            <?php wp_reset_postdata(); ?>
        </section>
    </section>
</main>

<?php get_footer(); ?>