/**
 * سیستم OTP لمکده
 */
jQuery(document).ready(function ($) {
    'use strict';

    // ==================== مدیریت حالت‌ها ====================

    // نمایش فرم ثبت‌نام
    $(".show-register").on("click", function (e) {
        e.preventDefault();
        $("#wc-login-form").fadeOut(200, function () {
            $("#wc-register-form").fadeIn(200);
        });
    });

    // نمایش فرم ورود
    $(".show-login").on("click", function (e) {
        e.preventDefault();
        $("#wc-register-form").fadeOut(200, function () {
            $("#wc-login-form").fadeIn(200);
        });
    });

    // ==================== ارسال OTP ====================

    $(".send-otp-btn").on("click", function (e) {
        e.preventDefault();
        lamkadeh_send_otp($(this));
    });

    function lamkadeh_send_otp(button) {
        const wrapper = button.closest("form");
        const phone = wrapper.find(".otp-phone").val().trim();
        const name = wrapper.find(".otp-name").val() || "";
        const type = wrapper.find(".otp-type").val();

        // اعتبارسنجی
        if (!lamkadeh_validate_phone(phone)) return;
        if (type === 'register' && !lamkadeh_validate_name(name)) return;

        // نرمال سازی شماره
        const normalizedPhone = lamkadeh_normalize_phone(phone);

        // غیرفعال کردن دکمه
        lamkadeh_set_button_loading(button, true, 'در حال ارسال...');

        // درخواست AJAX
        $.ajax({
            url: lamkadeh_ajax_obj.ajaxurl,
            type: 'POST',
            data: {
                action: "lamkadeh_send_otp",
                phone: normalizedPhone,
                name: name,
                type: type,
                nonce: lamkadeh_ajax_obj.nonce
            },
            success: function (response) {
                console.log('✅ پاسخ سرور:', response);

                if (response.success) {
                    lamkadeh_show_success(response.data);

                    $("#otp-step-2")
                        .data("phone", normalizedPhone)
                        .data("type", type)
                        .data("name", name)
                        .find(".phone-display").text(normalizedPhone);

                    if (type === "login") {
                        $("#wc-login-form").fadeOut(200, function () {
                            $("#otp-step-2").fadeIn(200);
                            $("#otp-step-2 .otp-code").first().focus();
                        });
                    } else {
                        $("#wc-register-form").fadeOut(200, function () {
                            $("#otp-step-2").fadeIn(200);
                            $("#otp-step-2 .otp-code").first().focus();
                        });
                    }

                    lamkadeh_start_resend_timer();

                } else {
                    lamkadeh_show_error(response.data);
                }
            },
            error: function (xhr, status, error) {
                console.error('❌ خطای AJAX:', error);
                lamkadeh_show_error('خطا در ارتباط با سرور. لطفاً مجدداً تلاش کنید.');
            },
            complete: function () {
                lamkadeh_set_button_loading(button, false, 'ادامه');
            }
        });
    }

    // ==================== تأیید OTP ====================

    $(".verify-otp-btn").on("click", function (e) {
        e.preventDefault();
        lamkadeh_verify_otp($(this));
    });

    function lamkadeh_verify_otp(button) {
        const phone = $("#otp-step-2").data("phone");
        const type = $("#otp-step-2").data("type");
        const name = $("#otp-step-2").data("name");
        const code = lamkadeh_get_otp_code();

        // اعتبارسنجی کد
        if (!lamkadeh_validate_otp_code(code)) return;

        console.log('🔐 تأیید OTP:', {
            phone: phone,
            type: type,
            code: code
        });

        // غیرفعال کردن دکمه
        lamkadeh_set_button_loading(button, true, 'در حال تأیید...');

        // درخواست AJAX
        $.ajax({
            url: lamkadeh_ajax_obj.ajaxurl,
            type: 'POST',
            data: {
                action: "lamkadeh_verify_otp",
                phone: phone,
                code: code,
                type: type,
                name: name,
                nonce: lamkadeh_ajax_obj.nonce
            },
            success: function (response) {
                console.log('✅ پاسخ تأیید:', response);

                if (response.success) {
                    lamkadeh_show_success(response.data.message);

                    // ریدایرکت
                    setTimeout(function () {
                        if (response.data.redirect) {
                            window.location.href = response.data.redirect;
                        } else {
                            window.location.reload();
                        }
                    }, 1000);

                } else {
                    lamkadeh_show_error(response.data);
                    // پاک کردن فیلدها
                    $(".otp-code").val('').first().focus();
                }
            },
            error: function (xhr, status, error) {
                console.error('❌ خطای تأیید:', error);
                lamkadeh_show_error('خطا در ارتباط با سرور. لطفاً مجدداً تلاش کنید.');
            },
            complete: function () {
                lamkadeh_set_button_loading(button, false, 'تایید و ادامه');
            }
        });
    }

    // ==================== توابع کمکی ====================

    function lamkadeh_get_otp_code() {
        let code = '';

        $(".otp-code").each(function (index) {
            const value = $(this).val() || '';
            const name = $(this).attr('name') || 'no-name';
            console.log(`فیلد ${index + 1} [${name}]: "${value}"`);
            code += value;
        });

        return code;
    }

    // اعتبارسنجی شماره تلفن
    function lamkadeh_validate_phone(phone) {
        if (!phone) {
            lamkadeh_show_error('لطفاً شماره تلفن همراه را وارد کنید.');
            return false;
        }

        const normalized = lamkadeh_normalize_phone(phone);
        if (!/^09[0-9]{9}$/.test(normalized)) {
            lamkadeh_show_error('لطفاً شماره تلفن همراه معتبر وارد کنید. (مثال: 09123456789)');
            return false;
        }

        return true;
    }

    // اعتبارسنجی نام
    function lamkadeh_validate_name(name) {
        if (!name.trim()) {
            lamkadeh_show_error('لطفاً نام و نام خانوادگی را وارد کنید.');
            return false;
        }
        return true;
    }

    // اعتبارسنجی کد OTP
    function lamkadeh_validate_otp_code(code) {
        const expectedLength = $(".otp-code").length;

        if (code.length !== expectedLength) {
            lamkadeh_show_error(`لطفاً تمام ${expectedLength} رقم کد را وارد کنید. (فعلاً ${code.length} رقم وارد شده)`);
            return false;
        }

        // بررسی اینکه همه ارقام عدد هستند
        if (!/^\d+$/.test(code)) {
            lamkadeh_show_error('کد باید فقط شامل اعداد باشد.');
            return false;
        }

        return true;
    }

    // نرمال سازی شماره تلفن
    function lamkadeh_normalize_phone(phone) {
        let normalized = phone.replace(/[^0-9]/g, '');
        if (normalized.startsWith('9') && normalized.length === 10) {
            normalized = '0' + normalized;
        }
        return normalized;
    }

    // مدیریت وضعیت دکمه
    function lamkadeh_set_button_loading(button, loading, text) {
        if (loading) {
            button.prop('disabled', true).find('span').text(text);
        } else {
            button.prop('disabled', false).find('span').text(text);
        }
    }

    // نمایش پیام موفقیت
    function lamkadeh_show_success(message) {
        const Toast = Swal.mixin({
            toast: true,
            position: "bottom-end",
            showConfirmButton: false,
            timer: 4000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.onmouseenter = Swal.stopTimer;
                toast.onmouseleave = Swal.resumeTimer;
            }
        });
        Toast.fire({
            icon: "success",
            title: message
        });
    }

    // نمایش پیام خطا
    function lamkadeh_show_error(message) {
        const Toast = Swal.mixin({
            toast: true,
            position: "bottom-end",
            showConfirmButton: false,
            timer: 4000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.onmouseenter = Swal.stopTimer;
                toast.onmouseleave = Swal.resumeTimer;
            }
        });
        Toast.fire({
            icon: "error",
            title: message
        });
    }

    // ==================== مدیریت فیلدهای OTP ====================

    // حرکت خودکار بین فیلدهای OTP
    $(document).on('input', '.otp-code', function () {
        const value = $(this).val();

        // فقط اعداد مجاز
        if (value && !/^\d+$/.test(value)) {
            $(this).val('');
            return;
        }

        // محدود کردن به یک رقم
        if (value.length > 1) {
            $(this).val(value.charAt(0));
            value = value.charAt(0);
        }

        // رفتن به فیلد بعدی اگر مقدار وارد شده
        if (value.length === 1) {
            const $next = $(this).next('.otp-code');
            if ($next.length) {
                $next.focus();
            }
        }
    });

    // مدیریت Backspace
    $(document).on('keydown', '.otp-code', function (e) {
        if (e.key === 'Backspace' && !$(this).val()) {
            const $prev = $(this).prev('.otp-code');
            if ($prev.length) {
                $prev.focus();
            }
            e.preventDefault();
        }
    });

    // ==================== تایمر ارسال مجدد ====================

    function lamkadeh_start_resend_timer() {
        let timer = 120; // 2 دقیقه
        const $resendLink = $("#otp-step-2 .show-register");
        const originalText = $resendLink.text();

        $resendLink.prop('disabled', true).css('opacity', '0.5');

        const countdown = setInterval(function () {
            const minutes = Math.floor(timer / 60);
            const seconds = timer % 60;

            $resendLink.text(`ارسال مجدد (${minutes}:${seconds.toString().padStart(2, '0')})`);

            if (timer-- <= 0) {
                clearInterval(countdown);
                $resendLink.text(originalText).prop('disabled', false).css('opacity', '1');
            }
        }, 1000);
    }

    // ارسال مجدد کد
    $(document).on('click', '#otp-step-2 .show-register', function (e) {
        if ($(this).prop('disabled')) {
            e.preventDefault();
            return;
        }

        const phone = $("#otp-step-2").data("phone");
        const type = $("#otp-step-2").data("type");
        const name = $("#otp-step-2").data("name");

        // شبیه‌سازی کلیک روی دکمه ارسال
        $(".send-otp-btn").click();
    });

    // ==================== تست اتصال ====================

    // تست اولیه اتصال به سرور
    console.log('🚀 سیستم OTP لمکده فعال شد');
    console.log('🔗 Endpoint:', lamkadeh_ajax_obj.ajaxurl);

    // اضافه کردن تابع دیباگ به global برای تست دستی
    window.debugOtpFields = function () {
        console.log('=== دیباگ دستی فیلدهای OTP ===');
        let code = '';
        $(".otp-code").each(function (index) {
            const value = $(this).val() || '';
            console.log(`فیلد ${index + 1}: "${value}"`);
            code += value;
        });
        console.log('کد نهایی:', code);
        console.log('طول:', code.length);
        return code;
    };
});
