document.addEventListener("DOMContentLoaded", () => {
  const triggers = document.querySelectorAll(".mega-menu-trigger");
  triggers.forEach((trigger) => {
    const link = trigger.querySelector("a");
    const menu = trigger.querySelector(".mega-menu");
    const overlay = trigger.querySelector(".overly-mega-menu");
    let timeoutId;
    const addActive = () => {
      clearTimeout(timeoutId);
      trigger.classList.add("active");
    };
    const removeActive = (delay = 150) => {
      clearTimeout(timeoutId);
      timeoutId = setTimeout(() => {
        trigger.classList.remove("active");
      }, delay);
    };
    link.addEventListener("mouseenter", addActive);
    menu.addEventListener("mouseenter", addActive);
    overlay.addEventListener("mouseenter", () => removeActive(500));
    trigger.addEventListener("mouseleave", () => removeActive(150));
  });
});

document.addEventListener("DOMContentLoaded", function () {
  const tabs = document.querySelectorAll(
    ".navbar-sidebar-responsive-tab ul li"
  );
  const panels = document.querySelectorAll(
    ".navbar-sidebar-responsive-content-item"
  );

  function activateTab(tab) {
    const targetId = tab.dataset.tabNavbar;
    const targetPanel = document.getElementById(targetId);
    if (!targetPanel) {
      return;
    }
    tabs.forEach((t) => t.classList.remove("active"));
    panels.forEach((p) => p.classList.remove("active"));
    tab.classList.add("active");
    targetPanel.classList.add("active");
  }
  tabs.forEach((tab) => {
    tab.addEventListener("click", function (e) {
      e.preventDefault();
      activateTab(this);
    });
  });
  if (tabs.length > 0 && panels.length > 0) {
    activateTab(tabs[0]);
  }
});

document.addEventListener("DOMContentLoaded", () => {
  const signupTop = document.querySelector(".my-account-header-name");

  if (signupTop) {
    signupTop.addEventListener("mouseenter", () => {
      signupTop.classList.add("active");
    });

    document.addEventListener("click", (e) => {
      if (!signupTop.contains(e.target)) {
        signupTop.classList.remove("active");
      }
    });
  }
});

document.addEventListener("DOMContentLoaded", () => {
  const navbarToggle = document.querySelector(".navbar-toggle svg");
  const navbarBtnClose = document.querySelector(".close-navbar-toggle");
  const navbarOverly = document.querySelector(".navbar-toggle-overly");
  const navbarResult = document.querySelector(".navbar-toggle-result");

  if (navbarToggle && navbarBtnClose) {
    navbarToggle.addEventListener("click", () => {
      navbarToggle.classList.toggle("active");
    });

    navbarBtnClose.addEventListener("click", () => {
      navbarToggle.classList.toggle("active");
    });

    navbarOverly.addEventListener("click", () => {
      navbarToggle.classList.toggle("active");
    });

    window.addEventListener("scroll", () => {
      if (window.scrollY >= 65) {
        navbarOverly.style.top = "0px";
        navbarResult.style.top = "20px";
      } else {
        navbarOverly.style.top = "90px";
        navbarResult.style.top = "122px";
      }
    });
  }
});

window.addEventListener("elementor/frontend/init", function () {

  elementorFrontend.hooks.addAction(
    "frontend/element_ready/global",
    function () {

      document.querySelectorAll(".mega-menu-responsive").forEach((megaMenu) => {

        const megaMenuTabs = megaMenu.querySelectorAll(
          ".mega-menu-tab-item-responsive"
        );

        const megaMenuPanels = megaMenu.querySelectorAll(
          ".mega-menu-content-responsive"
        );

        megaMenuTabs.forEach((tabItem) => {

          tabItem.addEventListener("click", function () {

            const panelId = this.dataset.tabResponsive;

            megaMenuTabs.forEach((item) =>
              item.classList.remove("active")
            );

            megaMenuPanels.forEach((panel) =>
              panel.classList.remove("active")
            );

            this.classList.add("active");

            const activePanel = megaMenu.querySelector(
              "#" + CSS.escape(panelId)
            );

            if (activePanel) {
              activePanel.classList.add("active");
            }

          });

        });

        // فعال‌سازی پیش‌فرض اولین تب
        if (megaMenuTabs.length > 0) {
          megaMenuTabs[0].click();
        }

      });

    }
  );

});

document.addEventListener("DOMContentLoaded", function () {
  const tabs = document.querySelectorAll(".mega-menu-tab-item");
  const panels = document.querySelectorAll(".mega-menu-content-item");

  tabs.forEach((tab) => {
    tab.addEventListener("mouseenter", function () {
      const targetId = this.getAttribute("data-tab");
      tabs.forEach((t) => t.classList.remove("active"));
      panels.forEach((panel) => panel.classList.remove("active"));
      this.classList.add("active");
      const targetPanel = document.getElementById(targetId);
      if (targetPanel) {
        targetPanel.classList.add("active");
      }
    });
  });
  if (tabs.length > 0) {
    tabs[0].dispatchEvent(new Event("mouseenter"));
  }
});

// Main Sale Products
document.addEventListener("DOMContentLoaded", () => {
  const circles = document.querySelectorAll(
    ".sale-products-card-circle-color span"
  );

  circles.forEach((el, index) => {
    el.style.zIndex = circles.length - index;
  });
});

new Swiper(".sale-products-body-bottom", {
  loop: true,
  // autoplay: {
  //   delay: 6000,
  //   disableOnInteraction: false,
  // },
  navigation: {
    nextEl: ".sale-products-body-bottom-right",
    prevEl: ".sale-products-body-bottom-left",
  },
  breakpoints: {
    640: {
      slidesPerView: 1,
    },
    768: {
      slidesPerView: 1,
    },
    1024: {
      slidesPerView: 3,
    },
  },
});

new Swiper(".review-wrapper-center-content .swiper", {
  loop: true,
  autoplay: {
    delay: 6000,
    disableOnInteraction: false,
  },
  navigation: {
    nextEl: ".review-wrapper-center-pagination-right",
    prevEl: ".review-wrapper-center-pagination-left",
  },
});

// Main Slider Product
document.addEventListener("DOMContentLoaded", function () {
  function initSlider(tabContainer) {
    const cards = tabContainer.querySelectorAll(".slider-product-card");
    const prevBtn = tabContainer.querySelector(".slider-product-prev");
    const nextBtn = tabContainer.querySelector(".slider-product-next");
    const detailCard = tabContainer.querySelector(
      ".slider-product-main-wrapper"
    );

    if (!cards.length || !detailCard) return;

    let currentIndex = 0;

    function formatPrice(number) {
      return new Intl.NumberFormat("fa-IR").format(number);
    }

    function updateDetailCard(card) {
      if (!card) return;

      const titleEl = detailCard.querySelector(".product-title");
      const linkEl = detailCard.querySelector(".product-link");
      const linkAddToCart = detailCard.querySelector(
        ".slider-product-main-wrapper-header-left-add-to-cart-button a"
      );
      if (titleEl) titleEl.textContent = card.dataset.title || "";
      if (linkEl) linkEl.href = card.dataset.link || "#";
      if (linkAddToCart) linkAddToCart.href = card.dataset.link || "#";

      const imageEl = detailCard.querySelector(".product-image");
      if (imageEl && card.querySelector("img")) {
        imageEl.src = card.querySelector("img").src;
        imageEl.alt = card.dataset.title || "";
      }

      const regularPriceEl = detailCard.querySelector(".product-regular");
      const salePriceEl = detailCard.querySelector(".product-sale");
      const discountPercentEl = detailCard.querySelector(
        ".product-discount-percent"
      );

      const regularPrice = card.dataset.price || 0;
      const salePrice = card.dataset.salePrice || 0;
      const discount = card.dataset.discount || 0;

      if (regularPriceEl)
        regularPriceEl.textContent = formatPrice(regularPrice);
      if (salePriceEl) salePriceEl.textContent = formatPrice(salePrice);
      if (discountPercentEl)
        discountPercentEl.textContent = discount ? `%${discount}` : "";

      const shareBtn = detailCard.querySelector(
        ".slider-product-main-wrapper-header-left-add-to-cart-share .product-share-btn"
      );
      const wishlistBtn = detailCard.querySelector(
        ".slider-product-main-wrapper-header-left-add-to-cart-share .wishlist-btn"
      );

      if (shareBtn) {
        shareBtn.dataset.productTitle = card.dataset.title || "";
        shareBtn.dataset.productUrl = card.dataset.link || "#";
      }

      if (wishlistBtn) {
        const productId = card.dataset.id || card.getAttribute("data-id") || "";

        wishlistBtn.dataset.productId = productId;
        if (card.dataset.isFavorite === "1") {
          wishlistBtn.classList.add("active");
        } else {
          wishlistBtn.classList.remove("active");
        }
      }

      const reviewsEl = detailCard.querySelector(".product-reviews");
      if (reviewsEl)
        reviewsEl.textContent = card.dataset.reviews
          ? `(${card.dataset.reviews} نظر)`
          : "";

      const starsEl = detailCard.querySelector(
        ".slider-product-main-wrapper-header-left-review-stars"
      );
      if (starsEl) {
        starsEl.innerHTML = "";
        const rating = parseFloat(card.dataset.rating || 0);
        for (let i = 1; i <= 5; i++) {
          const star = document.createElement("span");
          star.classList.add(
            "fa",
            "fa-star",
            i <= Math.round(rating) ? "active" : "inactive"
          );
          starsEl.appendChild(star);
        }
      }

      const badgeEl = detailCard.querySelector(".product-discount");
      if (badgeEl) badgeEl.textContent = card.dataset.badge || "";

      const sold = parseInt(card.dataset.sold || 0);
      const remaining = parseInt(card.dataset.remaining || 0);
      const total = sold + remaining;
      const soldPercent = total > 0 ? (sold / total) * 100 : 0;

      const progressBar = detailCard.querySelector(
        ".slider-product-main-wrapper-header-left-counter-progressbar"
      );
      if (progressBar) progressBar.style.width = soldPercent + "%";

      const soldText = detailCard.querySelector(
        ".slider-product-main-wrapper-header-left-counter-progressbar-head span:first-child b"
      );
      const remainingText = detailCard.querySelector(
        ".slider-product-main-wrapper-header-left-counter-progressbar-head span:last-child b"
      );
      if (soldText) soldText.textContent = sold;
      if (remainingText) remainingText.textContent = remaining;

      const galleryContainer = detailCard.querySelector(
        ".slider-product-main-wrapper-body"
      );
      if (galleryContainer) {
        galleryContainer.innerHTML = "";
        try {
          const images = JSON.parse(card.dataset.gallery);
          images.slice(0, 5).forEach((img) => {
            const div = document.createElement("div");
            const imgEl = document.createElement("img");
            imgEl.src = img;
            imgEl.alt = card.dataset.title || "Product image";
            div.appendChild(imgEl);
            galleryContainer.appendChild(div);
          });
        } catch (e) {
          const div = document.createElement("div");
          const imgEl = document.createElement("img");
          imgEl.src = card.querySelector("img").src;
          imgEl.alt = card.dataset.title || "Product image";
          div.appendChild(imgEl);
          galleryContainer.appendChild(div);
        }
      }
    }

    function updateSlider() {
      cards.forEach((card) => {
        card.classList.remove("active");
        card.style.display = "none";
      });

      const isMobile = window.innerWidth <= 768;

      const prevIndex = currentIndex - 1;
      const nextIndex = currentIndex + 1;

      if (isMobile) {
        if (cards[currentIndex]) {
          cards[currentIndex].style.display = "block";
          cards[currentIndex].classList.add("active");
          updateDetailCard(cards[currentIndex]);
        }
        return;
      }

      if (prevIndex >= 0) cards[prevIndex].style.display = "block";
      if (cards[currentIndex]) {
        cards[currentIndex].style.display = "block";
        cards[currentIndex].classList.add("active");
      }
      if (nextIndex < cards.length) cards[nextIndex].style.display = "block";

      // حلقه‌ای نمایش ۳ کارت
      if (currentIndex === 0 && cards.length > 2)
        cards[2].style.display = "block";
      if (currentIndex === cards.length - 1 && cards.length > 2)
        cards[cards.length - 3].style.display = "block";

      if (cards[currentIndex]) updateDetailCard(cards[currentIndex]);
    }

    if (prevBtn)
      prevBtn.addEventListener("click", () => {
        currentIndex = currentIndex > 0 ? currentIndex - 1 : cards.length - 1;
        updateSlider();
      });

    if (nextBtn)
      nextBtn.addEventListener("click", () => {
        currentIndex = currentIndex < cards.length - 1 ? currentIndex + 1 : 0;
        updateSlider();
      });

    cards.forEach((card, idx) => {
      card.addEventListener("click", () => {
        currentIndex = idx;
        updateSlider();
      });
    });

    updateSlider();
  }

  // ساخت اسلایدر برای همه تب‌ها
  const tabContents = document.querySelectorAll(".slider-product-main");
  tabContents.forEach((tabContent) => initSlider(tabContent));

  // مدیریت تب‌ها
  const tabs = document.querySelectorAll(".slider-product-head-tab-item");
  const contents = document.querySelectorAll(".slider-product-main");

  function showTab(tab) {
    const targetId = tab.dataset.tabProduct;
    contents.forEach((content) => {
      content.style.opacity = content.id === targetId ? "1" : "0";
      content.style.visibility = content.id === targetId ? "visible" : "hidden";
      content.style.position =
        content.id === targetId ? "absolute" : "absolute";
      content.style.top = content.id === targetId ? "100px" : "150px";
    });
    tabs.forEach((t) => t.classList.remove("active"));
    tab.classList.add("active");
  }

  tabs.forEach((tab) => {
    tab.addEventListener("click", () => showTab(tab));
  });

  const activeTab = document.querySelector(
    ".slider-product-head-tab-item.active"
  );
  if (activeTab) showTab(activeTab);
});

// Sub More Footer
document.addEventListener("click", function (e) {
  const btn = e.target.closest(".more-description");
  if (!btn) return;
  const p = btn.closest(".footer-body-top-section-two-about-description p");
  const expanded = p.classList.toggle("expanded");
  btn.setAttribute("aria-expanded", expanded ? "true" : "false");
  btn.textContent = expanded ? "مشاهده کمتر" : "مشاهده بیشتر …";
});

function loginBeforeWhishlist() {
  const Toast = Swal.mixin({
    toast: true,
    position: "bottom-end",
    showConfirmButton: false,
    timer: 4000,
    timerProgressBar: true,
    didOpen: (toast) => {
      toast.onmouseenter = Swal.stopTimer;
      toast.onmouseleave = Swal.resumeTimer;
    },
  });
  Toast.fire({
    icon: "info",
    title: wc_ajax_obj.title_whishlist,
  });
}

document.addEventListener("DOMContentLoaded", function () {
  const wishlistButtons = document.querySelectorAll(".lamkadeh-wishlist-btn");

  wishlistButtons.forEach((btn) => {
    btn.addEventListener("click", function () {
      const productId = this.getAttribute("data-product-id");

      fetch(wc_ajax_obj.ajax_url, {
        method: "POST",
        headers: {
          "Content-Type": "application/x-www-form-urlencoded",
        },
        body: new URLSearchParams({
          action: "toggle_wishlist",
          product_id: productId,
          security: wc_ajax_obj.nonce,
        }),
      })
        .then((response) => response.json())
        .then((data) => {
          if (data.success) {
            const added = data.data.added;

            const Toast = Swal.mixin({
              toast: true,
              position: "bottom-end",
              showConfirmButton: false,
              timer: 4000,
              timerProgressBar: true,
              didOpen: (toast) => {
                toast.onmouseenter = Swal.stopTimer;
                toast.onmouseleave = Swal.resumeTimer;
              },
            });

            if (added) {
              this.classList.add("active");
              Toast.fire({
                icon: "success",
                title: wc_ajax_obj.add_whishlist,
              });
            } else {
              this.classList.remove("active");
              Toast.fire({
                icon: "info",
                title: wc_ajax_obj.remove_whishlist,
              });
            }
          } else {
            const Toast = Swal.mixin({
              toast: true,
              position: "bottom-end",
              showConfirmButton: false,
              timer: 4000,
              timerProgressBar: true,
              didOpen: (toast) => {
                toast.onmouseenter = Swal.stopTimer;
                toast.onmouseleave = Swal.resumeTimer;
              },
            });
            Toast.fire({
              icon: "error",
              title: wc_ajax_obj.error_whishlist,
            });
          }
        });
    });
  });
});

document.addEventListener("DOMContentLoaded", function () {
  const shareBtn = document.querySelector(".shareProductBtn");
  const shareBtnTwo = document.querySelector(".shareProductBtnTwo");

  if (shareBtn) {
    shareBtn.addEventListener("click", async function () {
      const shareData = {
        title: document.title,
        text: "این محصول رو ببین 👇",
        url: window.location.href,
      };

      if (navigator.share) {
        try {
          await navigator.share(shareData);
          console.log("اشتراک‌گذاری موفق");
        } catch (err) {
          console.log("اشتراک‌گذاری لغو شد", err);
        }
      } else if (navigator.clipboard && navigator.clipboard.writeText) {
        try {
          await navigator.clipboard.writeText(window.location.href);
          showInfo(wc_ajax_obj.save_link_clipboard);
        } catch (err) {
          fallbackCopy(window.location.href);
        }
      } else {
        fallbackCopy(window.location.href);
      }
    });
  }

  if (shareBtnTwo) {
    shareBtnTwo.addEventListener("click", async function () {
      const shareData = {
        title: document.title,
        text: "این محصول رو ببین 👇",
        url: window.location.href,
      };

      if (navigator.share) {
        try {
          await navigator.share(shareData);
          console.log("اشتراک‌گذاری موفق");
        } catch (err) {
          console.log("اشتراک‌گذاری لغو شد", err);
        }
      } else if (navigator.clipboard && navigator.clipboard.writeText) {
        try {
          await navigator.clipboard.writeText(window.location.href);
          showInfo(wc_ajax_obj.save_link_clipboard);
        } catch (err) {
          fallbackCopy(window.location.href);
        }
      } else {
        fallbackCopy(window.location.href);
      }
    });
  }

  function fallbackCopy(text) {
    const textarea = document.createElement("textarea");
    textarea.value = text;
    document.body.appendChild(textarea);
    textarea.select();
    document.execCommand("copy");
    document.body.removeChild(textarea);
    showInfo(wc_ajax_obj.save_link_clipboard);
  }

  function showInfo(message) {
    const Toast = Swal.mixin({
      toast: true,
      position: "bottom-end",
      showConfirmButton: false,
      timer: 4000,
      timerProgressBar: true,
      didOpen: (toast) => {
        toast.onmouseenter = Swal.stopTimer;
        toast.onmouseleave = Swal.resumeTimer;
      },
    });
    Toast.fire({
      icon: "success",
      title: message,
    });
  }
});

document.addEventListener("click", function (e) {
  const plusBtn = e.target.closest(".cart-counter-plus");
  const minusBtn = e.target.closest(".cart-counter-mines");

  if (plusBtn) {
    const wrapper = plusBtn.closest(".cart-counter-product");
    const input = wrapper.querySelector(".number-input-cart");
    let value = parseInt(input.value, 10);
    if (isNaN(value)) value = 0;
    const max = parseInt(input.getAttribute("max"), 10) || 500;
    if (value < max) input.value = value + 1;
    return;
  }

  if (minusBtn) {
    const wrapper = minusBtn.closest(".cart-counter-product");
    const input = wrapper.querySelector(".number-input-cart");
    let value = parseInt(input.value, 10);
    if (isNaN(value)) value = 1;
    const min = parseInt(input.getAttribute("min"), 10) || 1;
    if (value > min) input.value = value - 1;
    return;
  }
});

document.addEventListener("change", function (e) {
  if (!e.target.matches(".number-input-cart")) return;
  const input = e.target;
  let v = parseInt(input.value, 10);
  const min = parseInt(input.getAttribute("min"), 10) || 1;
  const max = parseInt(input.getAttribute("max"), 10) || 500;
  if (isNaN(v) || v < min) input.value = min;
  else if (v > max) input.value = max;
});

document.addEventListener("DOMContentLoaded", function () {
  const items = document.querySelectorAll(
    ".product-brands-list-left-header-item"
  );

  items.forEach((item) => {
    item.addEventListener("click", () => {
      items.forEach((i) => i.classList.remove("active"));

      item.classList.add("active");
    });
  });
});

document.addEventListener("DOMContentLoaded", function () {
  const shareBtn = document.getElementById("share-single-blog");
  if (!shareBtn) return;

  shareBtn.addEventListener("click", async function () {
    const shareUrl = window.location.href;
    const shareTitle = document.title;

    if (navigator.share) {
      try {
        await navigator.share({
          title: shareTitle,
          url: shareUrl,
        });
      } catch (err) {
        console.log("اشتراک‌گذاری لغو شد یا خطا:", err);
      }
    } else {
      const tempInput = document.createElement("input");
      tempInput.value = shareUrl;
      document.body.appendChild(tempInput);
      tempInput.select();
      tempInput.setSelectionRange(0, 99999);
      document.execCommand("copy");
      document.body.removeChild(tempInput);

      const Toast = Swal.mixin({
        toast: true,
        position: "bottom-right",
        showConfirmButton: false,
        timer: 4000,
        timerProgressBar: true,
        didOpen: (toast) => {
          toast.onmouseenter = Swal.stopTimer;
          toast.onmouseleave = Swal.resumeTimer;
        },
      });
      Toast.fire({
        icon: "success",
        title: "لینک با موفقیت کپی شد",
      });
    }
  });
});

document.addEventListener("DOMContentLoaded", function () {
  const titles = document.querySelectorAll(
    ".footer-body-top-section-one-list-title.footer-head-title-nav span"
  );

  titles.forEach((title) => {
    let text = title.textContent.trim();
    if (!text) return;
    let parts = text.split(/\s+/);
    if (parts.length > 1) {
      let lastWord = parts.pop();
      title.innerHTML = parts.join(" ") + " <strong>" + lastWord + "</strong>";
    } else {
      title.innerHTML = "<strong>" + text + "</strong>";
    }
  });
});

document.addEventListener("DOMContentLoaded", function () {
  const items = document.querySelectorAll(".product-archive-content-item");
  const count = items.length;
  const style = document.createElement("style");

  if (count <= 4) {
    style.innerHTML = `
      .product-archive .product-archive-content::after {
        height: 580px !important;
      }
    `;
  } else if (count > 4) {
    style.innerHTML = `
      .product-archive .product-archive-content::after {
        height: 1080px !important;
      }
    `;
  }

  document.head.appendChild(style);
});

document.addEventListener("DOMContentLoaded", function () {
  const menuItems = document.querySelectorAll(
    ".navbar-sidebar-responsive-content-item .menu-item-has-children > a"
  );

  menuItems.forEach(function (menuItem) {
    menuItem.addEventListener("click", function (e) {
      if (window.innerWidth <= 991) {
        e.preventDefault();
        const parentLi = this.parentElement;
        parentLi.classList.toggle("active");
      }
    });
  });
});

document.addEventListener("DOMContentLoaded", function () {
  const wrapper = document.querySelector(
    ".product-brands-list-left-header-item-wrapper"
  );
  const btnLeft = document.querySelector(".brands-scroll-btn.left");
  const btnRight = document.querySelector(".brands-scroll-btn.right");

  const scrollAmount = 200;

  btnLeft.addEventListener("click", () => {
    wrapper.scrollBy({
      left: -scrollAmount,
      behavior: "smooth",
    });
  });

  btnRight.addEventListener("click", () => {
    wrapper.scrollBy({
      left: scrollAmount,
      behavior: "smooth",
    });
  });
});

document
  .querySelectorAll(".features-center .features-center-top-title-content span")
  .forEach((p) => {
    const text = p.textContent;
    p.innerHTML = `<span style="color:white;">${text.slice(
      0,
      4
    )}</span>${text.slice(4)}`;
  });
